<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
jimport('joomla.application.component.view');
jimport('joomla.filesystem.folder');

class DatsogalleryViewUpload extends JViewLegacy {
  protected $item;
  protected $state;

  public function display($tpl = null) {
		$app	= JFactory::getApplication();
    $user		= JFactory::getUser();
    $isroot = $user->authorise('core.admin');
    $this->state = $this->get('State');
    $this->item = $this->get('Data');
    $this->params = $app->getParams('com_datsogallery');
    $this->settings = dg::getConfig();
    $itemId = dg::itemId(true);
    $authorised = $user->authorise('core.create', 'com_datsogallery');
    if ($authorised !== true) {
      $app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'warning');
      $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=categories'.$itemId, false));
    }
    if ($this->settings->users_categories && !$this->settings->members_category && !$isroot){
      $app->enqueueMessage(JText::_('COM_DATSOGALLERY_MEMBERS_CATEGORIES_MSG'), 'warning');
      $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=categories'.$itemId, false));
    }
    if (!$this->settings->users_categories && !$this->settings->allowed_categories && !$isroot){
      $app->enqueueMessage(JText::_('COM_DATSOGALLERY_ALLOWED_CATEGORIES_MSG'), 'warning');
      $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=categories'.$itemId, false));
    }
    $this->aup = !$isroot ? $this->settings->{'acl_'.max($user->groups)} : 0;
    $this->tup = dg::userimages();
    $this->max = (!$isroot && $this->aup != '-1') ? $this->aup - $this->tup : 0;
    if (!$isroot && $this->tup == $this->aup && $this->aup != '-1') {
      $app->enqueueMessage(JText::sprintf('COM_DATSOGALLERY_MAX_FILES_REACHED_MSG', $this->aup), 'warning');
      $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=categories'.$itemId, false));
    }
    if (count($errors = $this->get('Errors'))) {
        throw new Exception(implode("\n", $errors));
    }
    $this->_prepareDocument();
    parent::display($tpl);
  }

  protected function _prepareDocument() {
    $app  = JFactory::getApplication();
    $doc  = JFactory::getDocument();
    $user = JFactory::getUser();
    $lng = substr($this->document->language, 0, 2);
    $this->document->addScript(JUri::root(true).'/components/com_datsogallery/assets/js/upload.min.js');
    $this->document->addScriptDeclaration('dguplim = '.$this->max.';');
    dg::jslang('upload.min.js');
    if ($this->settings->allow_geotagging) {
      if ($this->settings->gm_api_key != '') {
      $this->document->addScript('//maps.googleapis.com/maps/api/js?key='.$this->settings->gm_api_key.'&amp;libraries=places&amp;language='.$lng);
      }
      else {
        $this->document->addScript('//maps.googleapis.com/maps/api/js?libraries=places&amp;language='.$lng);
      }
    }
    if (JFolder::exists(JPATH_SITE.$this->settings->path_to_tmp.'/'.$user->id)) {
      JFolder::delete(JPATH_SITE.$this->settings->path_to_tmp.'/'.$user->id);
    }
  }

}