<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewTags extends JViewLegacy
{
  protected $items;
  protected $pagination;
  protected $state;
  protected $params;

  public function display($tpl = null)
  {
    $app                  = JFactory::getApplication();
    $this->state          = $this->get('State');
    $this->items          = $this->get('Items');
    $this->pagination     = $this->get('Pagination');
    $menu                 = $app->getMenu();
    $members_ids          = $menu->getItems('link', 'index.php?option=com_datsogallery&view=members');
    $this->members_itemid = isset($members_ids[0]) ? '&Itemid=' . $members_ids[0]->id : '';
    $model                = $this->getModel();
    $model->hit();
    if (count($errors = $this->get('Errors'))) {
      throw new Exception(implode("\n", $errors));
    }
    $this->params   = $app->getParams('com_datsogallery');
    $this->settings = dg::getConfig();
    $this->_prepareDocument();
    parent::display($tpl);
  }

  protected function _prepareDocument()
  {
    $app   = JFactory::getApplication();
    $menus = $app->getMenu();
    $title = null;
    $menu  = $menus->getActive();
    if ($menu) {
      $this->params->def('page_heading', $this->params->get('page_title', $menu->title));
    } else {
      $this->params->def('page_heading', JText::_('COM_DATSOGALLERY_DEFAULT_PAGE_TITLE'));
    }
    $pathway = $app->getPathway();
    $pathway->addItem(JText::_('COM_DATSOGALLERY_TAGS'), '');
    $title = JText::sprintf('COM_DATSOGALLERY_MATCHES_BY_TAG', $app->input->getString('tag', ''));
    $this->document->setTitle($title);
  }
}
