<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

$app    = JFactory::getApplication();
$items = count($this->items);
$do_grid = $items > 0 ? 'dg-grid' : 'dg-nogrid';
?>
<div class="dg-ui">
  <h3 class="dg-page-title">
    <?= JText::sprintf('COM_DATSOGALLERY_MATCHES_BY_TAG', $app->input->getString('tag', '')); ?>
  </h3>
  <?= JHtml::_('datsogallery.search'); ?>
  <div id="dg-pregrid">
    <div id="dg-tags" class="<?= $do_grid ?>"
         data-container-breakpoints="<?= $this->settings->category_container_breakpoints ?>"
         data-breakpoint-xl="<?= $this->settings->category_breakpoint_xl ?>"
         data-breakpoint-l="<?= $this->settings->category_breakpoint_l ?>"
         data-breakpoint-m="<?= $this->settings->category_breakpoint_m ?>"
         data-breakpoint-s="<?= $this->settings->category_breakpoint_s ?>"
         data-margin-y="<?= $this->settings->category_margin_y ?>"
         data-margin-x="<?= $this->settings->category_margin_x ?>">
      <?php
        if ($items > 0) {
          foreach ($this->items as $item) {
            $covers       = dg::catcover($item->id);
            $parents      = dg::getparents($item->id);
        ?>
      <div id="image-<?=$item->id ?>" class="dg-grid-item">
        <div class="image-block dg-image">
          <div class="dg-spiner"></div>
          <a id="<?= $item->id ?>" href="<?= JRoute::_('index.php?option=com_datsogallery&view=image&catid='.$item->catid.'&id='.$item->id.dg::menuid($item->catid)) ?>">
          <img src="<?=JHtml::_('datsogallery.image', $item->original, $item->id, $item->catid, 'category') ?>" alt="<?=$item->title ?>" <?=dg::is_anim($item->original, $item->catid) ?> <?=get_width_height($item->original, $this->settings->category_image_width, $this->settings->category_image_height, $item->catid, $this->settings->category_image_aspect_ratio);?> /></a>
          <?php
            echo JHtml::_('datsogallery.details', $item->id, $item->user_id, $item->title, $item->user_name, $item->created, JRoute::_('index.php?option=com_datsogallery&view=image&catid='.$item->catid.'&id='.$item->id.dg::menuid($item->catid)), 'category', $item->catid);
            echo JHtml::_('datsogallery.stats', $item->id, null, $item->user_id, $item->user_name, $item->original, $item->featured, $item->hits, $item->downloads, JRoute::_('index.php?option=com_datsogallery&view=image&catid='.$item->catid.'&id='.$item->id.dg::menuid($item->catid)), $item->title, $item->created, 'category');
            ?>
        </div>
        <?php if ($this->settings->category_details) { ?>
        <div class="image-card">
          <?php if ($this->settings->category_title && $this->settings->category_title_position == 0) { ?>
          <h4 class="image-title"><a href="<?= JRoute::_('index.php?option=com_datsogallery&view=image&catid='.$item->catid.'&id='.$item->id.dg::menuid($item->catid)) ?>"><?= $item->title ?></a></h4>
          <?php } ?>
          <?php if ($this->settings->category_image_description) { ?>
          <p class="image-desc"><?= strip_tags($item->description) ?></p>
          <?php } ?>
        </div>
        <?php } ?>
      </div>
      <?php
          }
        } else { ?>
      <div class="dg-message-info">
        <p><?= JText::_('COM_DATSOGALLERY_NO_ITEMS') ?></p>
      </div>
      <?php
        }
        ?>
    </div>
    <div class="ias-conteiner"></div>
  </div>
  <?php if ($this->pagination->limit < $this->pagination->total) {?>
  <div class="dg-pagination"<?=$this->settings->category_pagination_type ? ' style="display:none"' : '';?>>
  <?php if (!$this->settings->category_pagination_type) {?>
  <p class="counter pull-right">
    <?=$this->pagination->getPagesCounter();?>
  </p>
  <?php
    }
      echo $this->pagination->getPagesLinks();
    ?>
  </div>
  <?php }
  if ($this->settings->backlink) {?>
  <div class="backlink">
    <?= dg::backlink() ?>
  </div>
  <?php } ?>
</div>
<?php
  $doc    = JFactory::getDocument();
  $doc->addScriptDeclaration('var dgrid = ".dg-grid";');
  if ($this->settings->category_pagination_type) {
    $ias = ($this->pagination->limit >= $this->pagination->total) ? 'true' : 'false';
    $doc->addScriptDeclaration('var iasdestroy = ' . $ias . ';');
    $doc->addScriptDeclaration('var dgoffset = ' . (int) $this->settings->pagination_offset . ';');
} else {
  $doc->addScriptDeclaration('var iasdestroy = true;');
}