<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
?>

<div class="dg-ui">
   <h3 class="dg-page-title"><?php echo JText::_("COM_DATSOGALLERY_OUR_MEMBERS"); ?></h3>
   <div id="dg-members" class="dg-flx-grid">
      <?php
         foreach ($this->items as $item) :
         $member = dg::profile($item->id);
         ?>
      <div class="dg-flx-item">
         <?php if ($this->settings->allow_avatar) : ?>
         <div class="dg-members-avatar">
            <a href="<?php echo JRoute::_('index.php?option=com_datsogallery&view=member&id=' . (int)$item->id.dg::itemId()); ?>">
               <?php echo dg::avatar($item->id); ?>
            </a>
            <div class="dg-flx-grid">
                <?php echo @$item->featured ? '<div class="box hot"><i class="dgi-hot"></i> HOT!</div>' : ''; ?>
                <div class="boxi"><i class="dgi-album"></i><span><?php echo dg::totalcategories($item->id); ?></span></div>
                <div class="boxi"><i class="dgi-image"></i><span><?php echo dg::totalimages($item->id); ?></span></div>
             </div>
         </div>
         <?php endif; ?>
         <a href="<?php echo JRoute::_('index.php?option=com_datsogallery&view=member&id=' . (int)$item->id.dg::itemId()); ?>">
            <h3 class="dg-title ellipsis dg-text-center"><?php echo $item->name; ?></h3>
         </a>
         <h5 class="dg-text-center"><?php echo isset($member['location']) ? $member['location'] : ''; ?></h5>
         <div class="dg-text-center dg-text-medium"><?php echo isset($member['about']) ? dg::dgwordlimiter(nl2br($member['about']),20) : ''; ?></div>
      </div>
      <?php endforeach; ?>
   </div>
<div class="ias-conteiner"></div>
  <?php if ($this->pagination->limit < $this->pagination->total) {?>
  <div class="dg-pagination"<?=$this->settings->category_pagination_type ? ' style="display:none"' : '';?>>
    <?php if (!$this->settings->category_pagination_type) {?>
    <p class="counter pull-right">
      <?=$this->pagination->getPagesCounter();?>
    </p>
    <?php
      }
        echo $this->pagination->getPagesLinks();
      ?>
  </div>
  <?php }
    if ($this->settings->backlink) {?>
  <div class="backlink">
    <?= dg::backlink() ?>
  </div>
  <?php } ?>
</div>
<?php
  if ($this->settings->category_pagination_type) {
  ?>
<script>
var dgoffset = <?=$this->settings->pagination_offset;?>;
var mias = jQuery.ias({
  container:  '.dg-flx-grid',
  item:       '.dg-flx-item',
  pagination: '.dg-pagination',
  next:       '.pagination-next a',
  delay: 500,
  negativeMargin: 600
}).extension(new IASTriggerExtension({
    triggerContainer: '.ias-conteiner',
    offset: (dgoffset == 0 || dgoffset == 1) ? false : dgoffset,
    textPrev: Joomla.JText._("COM_DATSOGALLERY_IAS_TRIGGER_PREV"),
    htmlPrev: '<div class="ias-trigger ias-trigger-prev"><a class="dgi-arrow-prev" title="{text}"></a></div>',
    text: Joomla.JText._("COM_DATSOGALLERY_IAS_TRIGGER_NEXT"),
    html: '<div class="ias-trigger ias-trigger-next"><a class="dgi-arrow-next" title="{text}"></a></div>'
})).extension(new IASHistoryExtension({
    prev: 'a.pagenav:has(span.icon-back), .pagination-prev a'
})).extension(new IASNoneLeftExtension({
    noneLeftContainer: '.ias-conteiner',
    html: '<div class="ias-noneleft"><a class="dgi-arrow-next" title="' + Joomla.JText._("COM_DATSOGALLERY_IAS_NONELEFT") + ' ' + Joomla.JText._("COM_DATSOGALLERY_IAS_SCROLL_TOP") + '"></a></div>'
})).extension(new IASPagingExtension()).on('render', function(items) {}).on('rendered', function(items) {}).on('next', function(url) {
    preapp = '.ias-conteiner';
}).on('prev', function(url) {
    preapp = '.ias-conteiner';
}).on('noneLeft', function() {
    preapp = '.ias-conteiner';
}).extension(new IASSpinnerExtension({
    spinnerContainer: '.ias-conteiner',
    html: '<div class="ias-spinner"><span class="dgi-spin"></span></div>'
}));
iasdestroy = true;
</script>
<?php
}