<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2019 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
$user = JFactory::getUser();
?>
<div class="dg-ui">
<form id="member-profile" action="<?php echo JRoute::_('index.php?option=com_datsogallery&task=member.save'); ?>" method="post" enctype="multipart/form-data">
    <ul class="dg-flex-margin-5">
      <li style="width: 100%;">
        <ul class="dg-flex-margin-5" style="margin-bottom:10px">
          <li style="flex-basis:50%">
              <div class="inline-group">
                <label class="radio"><input id="male" type="radio" name="gender"<?= isset($this->member['gender']) && $this->member['gender'] == 'male' ? ' checked value="male"' : '' ?>><i></i><?= JText::_("COM_DATSOGALLERY_MALE") ?></label>
                <label class="radio"><input id="female" type="radio" name="gender"<?= isset($this->member['gender']) && $this->member['gender'] == 'female' ? ' checked value="female"' : '' ?>><i></i><?= JText::_("COM_DATSOGALLERY_FEMALE") ?></label>
              </div>
          </li>
          <li style="flex-basis:50%">
            <div class="input">
              <i class="dg-icon-append dgi-user"></i>
              <input type="text" placeholder="<?= $user->name ?>" value="<?= $user->name ?>" disabled>
            </div>
          </li>
        </ul>
        <ul class="dg-flex-margin-5" style="margin-bottom:10px">
          <li class="location" style="flex-basis:50%">
            <div class="input">
              <i class="dg-icon-append dgi-add-location"></i>
              <input type="text" name="location" value="<?= isset($this->member['location']) ? $this->member['location'] : '' ?>" placeholder="<?= JText::_("COM_DATSOGALLERY_CITY") ?>, <?= JText::_("COM_DATSOGALLERY_COUNTRY") ?>">
              <b class="tooltip tooltip-top-right"><?php echo JText::_("COM_DATSOGALLERY_LOCATION_HINT"); ?></b>
            </div>
          </li>
          <li class="website" style="flex-basis:50%">
            <div class="input">
              <i class="dg-icon-append dgi-link"></i>
              <input type="text" placeholder="<?php echo JText::_("COM_DATSOGALLERY_WEBSITE"); ?>" name="website" value="<?php echo isset($this->member['website']) ? $this->member['website'] : ''; ?>" />
              <b class="tooltip tooltip-top-right"><?php echo JText::_("COM_DATSOGALLERY_WEBSITE"); ?></b>
            </div>
          </li>
        </ul>
      </li>
    </ul>
    <ul class="dg-flex-margin-5" style="margin-bottom:10px">
      <li style="flex: 1;">
        <label class="textarea textarea-expandable">
          <i class="dg-icon-append dgi-comment"></i>
          <textarea rows="3" id="about" name="about" placeholder="<?php echo JText::_("COM_DATSOGALLERY_ABOUT_YOU"); ?>"><?php echo isset($this->member['about']) ? $this->member['about'] : ''; ?></textarea>
          <b class="tooltip tooltip-top-right"><?php echo JText::_("COM_DATSOGALLERY_WEBSITE"); ?></b>
        </label>
      </li>
    </ul>
    <footer style="margin-bottom:10px">
      <button type="submit" class="btn" id="save-profile"><?php echo JText::_("JSAVE"); ?></button>
      <a class="btn" style="margin-left:5px" href="<?php echo JRoute::_('index.php?option=com_datsogallery&task=member.cancel&id='.$user->id); ?>"><?php echo JText::_('JCANCEL'); ?></a>
    </footer>
    <input type="hidden" name="id" value="<?= $user->id ?>" />
    <?php echo JHtml::_('form.token'); ?>
</form>
<?php if ($this->settings->backlink) { ?>
  <div class="backlink">
    <?= dg::backlink() ?>
  </div>
<?php } ?>
</div>
<script>
var iasdestroy = true;
</script>