<?php
defined('_JEXEC') or die;
$user = JFactory::getUser();
$lang = JFactory::getLanguage();
$lang->load('com_datsogallery', JPATH_ADMINISTRATOR);
$is_rtl = $lang->get('rtl');
$groups = $user->getAuthorisedViewLevels();
$language = JLanguageMultilang::isEnabled() ? '&lang='.substr($lang->getTag(), 0, 2) : '';
if ($this->settings->allow_report && in_array($this->settings->report_access, $groups)) : ?>
<div id="report_form">
  <p class="report_msg"><?php echo JText::_("COM_DATSOGALLERY_REPORT_IMAGE_MSG"); ?></p>
  <form id="dg-image-report" action="<?= JUri::root(true); ?>/index.php?option=com_datsogallery&task=image.report<?= $language ?>&<?= JSession::getFormToken() ?>=1" autocomplete="off" method="post">
    <?php if ($user->id) : ?>
    <input id="title" name="title" type="hidden" value="<?php echo $user->name; ?>">
    <?php else: ?>
    <div class="input">
      <i class="dg-icon-<?php echo $is_rtl ? 'prepend' : 'append';?> dgi-user"></i>
      <input id="title" name="title" type="text" placeholder="<?php echo JText::_("COM_DATSOGALLERY_COMMENTS_NAME"); ?>">
      <b class="tooltip tooltip-top-<?php echo $is_rtl ? 'left' : 'right';?>"><?php echo JText::_("COM_DATSOGALLERY_ENTER_NAME"); ?></b>
    </div>
    <?php endif; ?>
    <div class="textarea textarea-expandable" style="margin-top: 10px;<?php echo $this->settings->report_captcha ? 'margin-bottom:10px' : ''; ?>">
      <i class="dg-icon-<?php echo $is_rtl ? 'prepend' : 'append';?> dgi-comment"></i>
      <textarea id="message" name="message" rows="3" placeholder="<?php echo JText::_("COM_DATSOGALLERY_REPORT_IMAGE_REASON"); ?>"></textarea>
      <b class="tooltip tooltip-top-<?php echo $is_rtl ? 'left' : 'right';?>"><?php echo JText::_("COM_DATSOGALLERY_ENTER_COMMENT"); ?></b>
    </div>
    <?php if ($this->settings->report_captcha) : ?>
    <ul class="captcha<?php echo $is_rtl ? ' reverse' : '';?>">
      <li class="dg-form-captcha<?php echo $is_rtl ? ' reverse' : '';?>">
        <label class="input input-captcha">
        <img id="dgrcaptcha" src="<?php echo Juri::base(); ?>index.php?option=com_datsogallery&task=image.dgcaptchar&tmpl=component" onclick="dgCaptchar()" width="100" height="35" alt="Captcha" />
        <input type="text" maxlength="4" name="dgrcaptchaval" id="dgrcaptchaval" placeholder="<?php echo JText::_("COM_DATSOGALLERY_COMMENTS_CAPTCHA"); ?>" autocomplete="off">
        <b class="tooltip tooltip-top-<?php echo $is_rtl ? 'left' : 'right';?>"><?php echo JText::_("COM_DATSOGALLERY_COMMENTS_CAPTCHA_HINT"); ?></b>
        </label>
      </li>
    </ul>
    <?php endif; ?>
    <input id="image_id" name="image_id" type="hidden" value="<?php echo $this->item->id ?>">
  </form>
</div>
<script>
dgCaptchar();
jQuery(function($) {
 $("#dg-image-report").validate({
   rules: {
     title: {
       required: true,
       minlength: 3
     },
     message: {
       required: true,
       minlength: 3,
       minWords: 2
     },
     dgrcaptchaval: {
       required: true,
       minlength: 4,
       remote: ajax_url+'&task=image.validatecaptchar'
     }
   },
   messages: {
     title: {
       required: "<?php echo JText::_("COM_DATSOGALLERY_ENTER_NAME"); ?>",
       minlength: "<?php echo JText::sprintf("COM_DATSOGALLERY_NAME_IS_TOO_SHORT", 3); ?>"
     },
     message: {
       required: "<?php echo JText::_("COM_DATSOGALLERY_REPORT_IMAGE_VALIDATE_ENTER_REASON"); ?>",
       minlength: "<?php echo JText::sprintf("COM_DATSOGALLERY_REPORT_IMAGE_VALIDATE_MINCHARS_REASON", 3); ?>",
       minWords: "<?php echo JText::sprintf("COM_DATSOGALLERY_REPORT_IMAGE_VALIDATE_MINWORDS_REASON", 2); ?>"
     },
     dgrcaptchaval: {
       required: "<?php echo JText::_("COM_DATSOGALLERY_ENTER_CAPTCHA_CODE"); ?>",
       minlength: "<?php echo JText::sprintf("COM_DATSOGALLERY_CAPTCHA_IS_TOO_SHORT", 4); ?>",
       remote: "<?php echo JText::_("COM_DATSOGALLERY_CAPTCHA_INVALID"); ?>"
     }
   },
   submitHandler: function(form) {
     $('#submit-report').attr('disabled', true);
     $('#submit-report').html('<i class="dgi-load da-spin"></i>');
     $.ajax({
         type: $(form).attr('method'),
         url: $(form).attr('action'),
         data: $(form).serialize()
       })
       .done(function(response) {
         $('#modalReport').find('.report_msg').text(response);
         $('#modalReport').find('.btn-success').hide();
         $('#modalReport').find('.dg-cancel-report').text("<?= JText::_('JLIB_HTML_BEHAVIOR_CLOSE'); ?>");
         $('#title').val('');
         $('#message').val('');
         $('#dgrcaptchaval').val('');
         $('#dg-image-report').hide();
       });
       return false;
   },
   errorPlacement: function(error, element) {
     error.insertAfter(element.parent());
   }
 });
});
</script>
<?php endif; ?>
