<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

$is_rtl = $lang->get('rtl');
$language = JLanguageMultilang::isEnabled() ? '&lang='.substr($lang->getTag(), 0, 2) : '';
$db = JFactory::getDbo();
$user = JFactory::getUser();
$groups = $user->getAuthorisedViewLevels();
$canEdit = $user->authorise('core.edit', 'com_datsogallery.' . $this->item->id);
if (!$canEdit && $user->authorise('core.edit.own', 'com_datsogallery' . $this->item->id)) {
  $canEdit = $user->id == $this->item->created_by;
}
$uri        = JFactory::getURI();
$return     = $uri->toString();
?>
  <div id="comments">
  <h4 class="dg-h4 dg-separator"><?php echo JText::_("COM_DATSOGALLERY_COMMENTS_TITLE"); ?></h4>
  <?php if ($this->blocked) { ?>
  <div class="dg-alert dg-alert-warning">
    <div class="dg-alert-close dg-close"></div>
    <p><?php echo JText::_("COM_DATSOGALLERY_BLOCKED_MSG"); ?></p>
  </div>
  <?php } ?>
  <?php if (!$this->blocked) { ?>
  <?php if (in_array($this->settings->comments_access, $groups)) { ?>
  <form id="add-comment" action="<?php echo JUri::root(true); ?>/index.php?option=com_datsogallery&task=image.comments<?= $language ?>&<?= JSession::getFormToken() ?>=1" autocomplete="off" method="post">
    <?php if ($user->id) { ?>
    <ul>
      <?php if ($this->settings->allow_avatar && $this->settings->comments_avatar) { ?>
      <li id="uavatar">
          <?php echo dg::avatar($user->id, null, false, true, false, 'comments'); ?>
      </li>
      <?php } ?>
      <li class="comment-area">
        <div class="textarea textarea-expandable">
          <i class="dg-icon-<?php echo $is_rtl ? 'prepend' : 'append';?> dgi-comment"></i>
          <textarea rows="1" data-min-rows="1" class="auto-expand" id="user_text" name="user_text" placeholder="<?php echo JText::_("COM_DATSOGALLERY_COMMENTS_ADD_COMMENT_TITLE"); ?>"></textarea>
          <b class="tooltip tooltip-top-<?php echo $is_rtl ? 'left' : 'right';?>"><?php echo JText::_("COM_DATSOGALLERY_COMMENTS_ADD_COMMENT_HINT"); ?></b>
        </div>
      </li>
    </ul>
    <input type="hidden" id="user_name" name="user_name" value="<?php echo $user->name;?>" />
    <input type="hidden" id="user_email" name="user_email" value="<?php echo $user->email;?>" />
    <?php } else { ?>
    <ul class="guest">
      <li>
        <label class="input">
        <i class="dg-icon-<?php echo $is_rtl ? 'prepend' : 'append';?> dgi-user"></i>
        <input type="text" id="user_name" name="user_name" placeholder="<?php echo JText::_("COM_DATSOGALLERY_COMMENTS_NAME"); ?>">
        <b class="tooltip tooltip-top-<?php echo $is_rtl ? 'left' : 'right';?>"><?php echo JText::_("COM_DATSOGALLERY_ENTER_NAME"); ?></b>
        </label>
      </li>
      <li>
        <label class="input">
        <i class="dg-icon-<?php echo $is_rtl ? 'prepend' : 'append';?> dgi-mail"></i>
        <input type="email" id="user_email" name="user_email" placeholder="<?php echo JText::_("COM_DATSOGALLERY_COMMENTS_EMAIL"); ?>">
        <b class="tooltip tooltip-top-<?php echo $is_rtl ? 'left' : 'right';?>"><?php echo JText::_("COM_DATSOGALLERY_ENTER_EMAIL"); ?></b>
        </label>
      </li>
    </ul>
    <ul class="comment-area-margin">
      <li>
        <label class="textarea textarea-expandable">
        <i class="dg-icon-<?php echo $is_rtl ? 'prepend' : 'append';?> dgi-comment"></i>
        <textarea rows="1" data-min-rows="1" class="auto-expand" id="user_text" name="user_text" placeholder="<?php echo JText::_("COM_DATSOGALLERY_COMMENTS_ADD_COMMENT_TITLE"); ?>"></textarea>
        <b class="tooltip tooltip-top-<?php echo $is_rtl ? 'left' : 'right';?>"><?php echo JText::_("COM_DATSOGALLERY_ENTER_COMMENT"); ?></b>
        </label>
      </li>
    </ul>
    <?php
    if ($this->settings->comments_captcha) {
      if (in_array($this->settings->comments_captcha_type, array(1,2,3))) {
      ?>
    <ul>
      <li>
        <?= dg::recaptcha('recaptcha_comments') ?>
        <?php if ($this->settings->comments_captcha_type == 1) { ?>
        <input type="hidden" class="recaptcha_comments required" name="recaptcha_comments" id="recaptcha_comments">
        <?php } ?>
      </li>
    </ul>
    <?php
    } else {
    ?>
    <ul class="captcha">
      <li>
      <label class="input input-captcha<?php echo $is_rtl ? ' reverse' : '';?>">
      <img id="dgcaptcha" src="<?php echo JUri::base(); ?>index.php?option=com_datsogallery&task=image.dgcaptcha" onclick="dgCaptcha()" width="100" height="35" alt="Captcha" />
      <input type="text" maxlength="4" name="dgcaptchaval" id="dgcaptchaval" placeholder="<?php echo JText::_("COM_DATSOGALLERY_COMMENTS_CAPTCHA"); ?>">
      <b class="tooltip normal tooltip-top-<?php echo $is_rtl ? 'left' : 'right';?>"><?php echo JText::_("COM_DATSOGALLERY_COMMENTS_CAPTCHA_HINT"); ?></b>
      </label>
      </li>
      <li>
        <button id="post-comment" class="button" type="submit" title="<?php echo JText::_('JSUBMIT'); ?>"><span class="dgi-send"></span></button>
      </li>
    </ul>
    <?php
    }
    }
    }
    ?>
    <input type="hidden" id="image_id" name="image_id" value="<?php echo $this->item->id; ?>" />
  </form>
  <?php } else { ?>
    <div class="dg-alert dg-alert-warning">
    <div class="dg-alert-close dg-close"></div>
    <h4><?php echo JText::_('WARNING'); ?></h4>
    <p><?php echo JText::sprintf('COM_DATSOGALLERY_LEAVE_COMMENT_MSG', '<a href="'.JRoute::_('index.php?option=com_users&amp;view=login&amp;return='.urlencode(base64_encode($return))).'">'.JText::_('COM_DATSOGALLERY_LOGIN').'</a>'); ?></p>
  </div>
  <?php } ?>
  <?php } ?>
  <?php if ($this->settings->allow_comments && $this->settings->image_comments) { ?>
  <!-- START COMMENTS -->
  <ul id="<?= $this->item->id ?>" class="dg-comments-container <?= $is_rtl ? 'direction-rtl' : 'direction-ltr' ?>" data-returnlink="<?= urlencode(base64_encode($return)) ?>">
    <?php
    if (count($this->comments) > 0) {
      foreach ($this->comments as $row) {
        if ($row->parent_id != 0) continue;
          $is_author = $row->created_by == $this->item->created_by;
          $author_bg = $is_author ? ' img-author' : '';
          $comment_text = strip_tags(trim(html_entity_decode($row->text, ENT_QUOTES, 'UTF-8'), "\xc2\xa0"));
          $can_edit = dg::canEditComment($row->id);
          $can_delete = dg::candeletecomment($row->id);
          $liked = dg::is_likedcomment($row->id);
          $likes = dg::commentlikes($row->id);
          $is_liked = $liked ? ' liked' : '';
          $liked_icon = $is_liked ? 'like' : 'likes';
          $like_hint = $liked ? JText::_("COM_DATSOGALLERY_ALREADY_LIKED") : JText::_("COM_DATSOGALLERY_LIKE");
      ?>
      <li id="<?= $row->id ?>" class="dg-comment-container first-level">
        <ul id="comment<?= $row->id ?>">
          <?php if ($this->settings->allow_avatar && $this->settings->comments_avatar) { ?>
          <li class="dg-comment-avatar">
            <?php echo dg::avatar($row->created_by, $row->id, false, true, false, 'comments'); ?>
          </li>
          <?php } ?>
          <li>
            <ul class="dg-comment-top">
              <li>
                <ul class="dg-comment-user-data">
                  <li class="dg-comment-user-name">
                    <?=($row->created_by ? JFactory::getUser($row->created_by)->get('name') : $row->user_name)?> <?=$is_author ? ' <span title="'.JText::_('COM_DATSOGALLERY_IMAGE_DATA_AUTHOR').'"></span>' : ''?>
                  </li>
                  <li>&bull;</li>
                  <li class="dg-comment-date">
                    <?php echo dg::timelapse($row->date, $this->settings->comments_date_format);?>
                  </li>
                </ul>
              </li>
              <li>
                <ul class="dg-comment-user-actions">
                  <li>
                    <ul class="dg-comment-action-like">
                      <li class="hint--top hint--small" data-hint="<?= $like_hint ?>"><i class="dgi-<?= $liked_icon ?>"></i></li>
                      <li><?= $likes ?></li>
                    </ul>
                  </li>
                  <?php if (dg::canreply($row->id)) { ?>
                  <li id="<?= $row->id ?>" class="dg-comment-reply<?= (!$user->id ? ' is_guest' : '') ?> hint--top-left" data-hint="<?= JText::_('COM_DATSOGALLERY_REPLY') ?>">
                    <ul class="dg-comment-action-reply">
                      <li><i class="dgi-reply"></i></li>
                      <li><?= JText::_('COM_DATSOGALLERY_REPLY') ?></li>
                    </ul>
                  </li>
                  <?php
                  }
                  ?>
                  <li>
                    <ul class="dg-comment-action-copy">
                      <li class="hint--top-left hint--small copylink" data-hint="<?= JText::_('COM_DATSOGALLERY_COPYLINK') ?>">
                        <i class="dgi-link"></i>
                        <input class="linktocopy" type="text" value="<?= $return ?>#comment<?= $row->id ?>" />
                      </li>
                    </ul>
                  </li>
                  <?php
                  if (in_array(1, array($can_edit,$can_delete))) { ?>
                  <li class="dg-drop-menu">
                    <ul>
                      <?php if ($can_edit) { ?>
                      <li id="dgcomment<?= $row->id ?>" class="dg-comment-edit">
                        <ul>
                          <li><i class="dgi-edit"></i></li>
                          <li><?= JText::_('JACTION_EDIT') ?></li>
                        </ul>
                      </li>
                      <?php
                      }
                      if ($can_delete) { ?>
                      <li id="<?= $row->id ?>" class="dg-comment-delete">
                        <ul>
                          <li><i class="dgi-delete"></i></li>
                          <li><?= JText::_('JACTION_DELETE') ?></li>
                        </ul>
                      </li>
                      <?php } ?>
                    </ul>
                    <a class="dg-toggle-menu"><i class="dgi-more-horiz"></i></a>
                  </li>
                  <?php } ?>
                </ul>
              </li>
            </ul>
            <ul>
              <li class="dg-comment-box id-<?= $row->id ?> dg-parent<?=$is_author ? ' dg-is-author' : ''?>">
                <span id="<?= $row->id ?>" class="editable" data-activator="#dgcomment<?= $row->id ?>">
                  <?=nl2br($comment_text)?>
                </span>
              </li>
              <li class="dg-insert"></li>
              <?php
                if (count($this->parentcomments)) {
                  echo dg::nestedcomments($row->id, $this->parentcomments, $this->item->created_by, $is_rtl, $row->created_by, $return);
                }
              ?>
            </ul>
          </li>
        </ul>
      </li>
    <?php } ?>
    <?php } else { ?>
    <?php if (!$this->blocked) : ?>
    <li id="no-comments"></li>
    <?php endif; ?>
    <?php } ?>
  </ul>
  <div class="ias-conteiner"></div>
  <div class="dg-pagination"><?php echo $this->pagination->getPagesLinks(); ?></div>
  <!-- END COMMENTS -->
  <?php } ?>
  </div>
<?php
$captcha = (!$user->id && $this->settings->comments_captcha_type == 0) ? 'true' : 'false';
$recaptcha = (!$user->id && $this->settings->comments_captcha_type == 1) ? 'true' : 'false';
$invisible_recaptcha = (!$user->id && $this->settings->comments_captcha_type == 2) ? 'true' : 'false';
?>
<script>
var ias = jQuery.ias({
  container:  '.dg-comments-container',
  item:       '.dg-comment-container.first-level',
  pagination: '.dg-pagination',
  next:       '.pagination-next a'
}).extension(new IASSpinnerExtension({
    spinnerContainer: '.ias-conteiner',
    html: '<div class="ias-spinner"><span class="dgi-spin"></span></div>'
}));
var recaptcha = <?= $recaptcha ?>,
    invisible_recaptcha = <?= $invisible_recaptcha ?>,
    dgcaptch = <?= $captcha ?>,
    name_too_short = "<?= JText::sprintf("COM_DATSOGALLERY_NAME_IS_TOO_SHORT", 3) ?>",
    comment_min_chars = <?= $this->settings->comment_min_chars ?>,
    comment_too_short = "<?= JText::sprintf('COM_DATSOGALLERY_COMMENT_IS_TOO_SHORT', $this->settings->comment_min_chars) ?>",
    dgcaptchaval_length = "<?php echo JText::sprintf('COM_DATSOGALLERY_CAPTCHA_IS_TOO_SHORT', 1); ?>",
    iasdestroy = true;
</script>
