<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewCategory extends JViewLegacy
{
  protected $items;
  protected $pagination;
  protected $state;
  protected $params;
  protected $category;

  public function display($tpl = null)
  {
    $app              = JFactory::getApplication();
    $user             = JFactory::getUser();
    $this->state      = $this->get('State');
    $this->items      = $this->get('Items');
    $this->pagination = $this->get('Pagination');
    $this->category   = $this->get('Category');
    if (count($errors = $this->get('Errors'))) {
      throw new Exception(implode("\n", $errors));
    }
    $groups = $user->getAuthorisedViewLevels();
    if (!in_array($this->category->access, $groups)) {
      $app->enqueueMessage(JText::_('COM_DATSOGALLERY_NO_ACCESS_CATEGORY'), 'error');
      $app->setHeader('status', 403, true);
      $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=categories' . dg::itemId(), false));
    }
    $this->params   = $app->getParams('com_datsogallery');
    $this->settings = dg::getConfig();
    if ($this->settings->meta_generator) {
      $model = $this->getModel();
      $model->addMeta();
    }
    $this->_prepareDocument();
    parent::display($tpl);
  }

  protected function _prepareDocument()
  {
    $app   = JFactory::getApplication();
    $menus = $app->getMenu();
    $title = null;
    $menu  = $menus->getActive();
    if ($menu && ($menu->query['view'] == 'category' && $menu->query['catid'] == $this->category->id)) {
      $this->params->def('page_heading', $this->params->get('page_title', $menu->title));
      $title = $this->params->get('page_title', '');
    } else {
      $this->params->def('page_heading', $this->category->title);
      $title = $this->category->title;
    }
    if (empty($title)) {
      $title = $app->get('sitename');
    } elseif ($app->get('sitename_pagetitles', 0) == 1) {
      $title = JText::sprintf('JPAGETITLE', $app->get('sitename'), $title);
    } elseif ($app->get('sitename_pagetitles', 0) == 2) {
      $title = JText::sprintf('JPAGETITLE', $title, $app->get('sitename'));
    }
    if (empty($title)) {
      $title = $this->category->title;
    }
    $title = JText::sprintf('JPAGETITLE', $title, $app->get('sitename'));

    $this->document->setTitle($title);

    if ($this->params->get('menu-meta_description')) {
      $this->document->setDescription($this->params->get('menu-meta_description'));
    } elseif ($this->category->metadesc) {
      $this->document->setDescription($this->category->metadesc);
    }

    $pathway = $app->getPathway();
    $path    = $this->get('Path');
    foreach ($path as $item) {
      $pathway->addItem($item->title, $item->link);
    }
  }
}
