<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

$app      = JFactory::getApplication();
$menuitem = $app->getMenu()->getActive();
$params   = $menuitem->params;
$items = count($this->items);
$do_grid = $items > 0 ? 'dg-grid' : 'dg-nogrid';

$html = '<div class="dg-ui">';
$html .= '<h3 class="dg-page-title">';
$html .= JText::_($this->title);
$html .= '</h3>';
if ($params->get('show_base_description') && !empty(trim($params->get('categories_description')))) {
  $categories_description = $params->get('categories_description');
  if ($params->get('base_description_triggering')) {
    JPluginHelper::importPlugin('content');
    $categories_description = JHtml::_('content.prepare', $categories_description);
  } else {
    $categories_description = preg_replace('/[\[{\(].*[\]}\)]/U', '', $categories_description);
  }
$html .= '<div class="dg-description dg-more">';
$html .= $categories_description;
$html .= '</div>';
}
$html .= JHtml::_('datsogallery.search');
$html .= '<div id="dg-categories" class="'.$do_grid.'"';
$html .= ' data-container-breakpoints="' . $this->settings->categories_container_breakpoints . '"';
$html .= ' data-breakpoint-xl="' . $this->settings->categories_breakpoint_xl . '"';
$html .= ' data-breakpoint-l="' . $this->settings->categories_breakpoint_l . '"';
$html .= ' data-breakpoint-m="' . $this->settings->categories_breakpoint_m . '"';
$html .= ' data-breakpoint-s="' . $this->settings->categories_breakpoint_s . '"';
$html .= ' data-margin-y="' . ($this->settings->categories_details ? 0 : $this->settings->categories_margin_y) . '"';
$html .= ' data-margin-x="' . $this->settings->categories_margin_x . '">';
if ($items > 0) {
  foreach ($this->items as $item) {
    $covers  = dg::catcover($item->id);
    $parents = dg::getparents($item->id);
    $category_image = dg::category_image($item->image_id);
    $url = JRoute::_('index.php?option=com_datsogallery&view=category&catid=' . (int) $item->id . dg::menuid($item->id));
    $html .= '<div id="image-' . $item->id . '" class="dg-grid-item">';
    $html .= '<div class="image-block dg-album">';
    $html .= '<a href="' . $url . '">';
    if ($item->image_id) {
      $html .= '<img class="dgimg" src="' . JHtml::_('datsogallery.image', $category_image, $item->id, 0, 'categories') . '" alt="' . $item->title . '" />';
    } else if ($this->settings->categories_view_type == 1) {
      $inc = (4 - count($covers));
      if ($inc != 0) {
        for ($x = 1; $x <= $inc; $x++) {
          array_push($covers, $x);
        }
      }
      $html .= '<ul class="dg-cover-foursquare">';
      foreach ($covers as $cover) {
        $html .= '<li><img class="'.(isset($cover->original) && dg::is_alpha_png($cover->original) ? 'dgimg dg-has-alpha' : 'dgimg').'" class="dgimg" src="' . JHtml::_('datsogallery.image', (isset($cover->original) ? $cover->original : 'no_image.png'), $item->id, 0, 'categories', 1, '1:1') . '" alt="' . $item->title . '" /></li>';
      }
      $html .= '</ul>';
    } else if ($this->settings->categories_view_type == 2) {
    $inc = (3 - count($covers));
    if ($inc != 0) {
      for ($x = 1; $x <= $inc; $x++) {
        array_push($covers, $x);
      }
    }
    $html .= '<ul class="dg-cover-trio">';
    $i = 1;
    foreach ($covers as $cover) {
        if ($i == 1) {
          $html .= '<li class="dg-cover-leading dg-cover-pos">';
          $html .= '<img class="'.(isset($cover->original) && dg::is_alpha_png($cover->original) ? 'dgimg dg-has-alpha' : 'dgimg').'" src="' . JHtml::_('datsogallery.image', (isset($cover->original) ? $cover->original : 'no_image.png'), $item->id, 0, 'categories', 1, '3:2', true) . '" alt="' . $item->title . '" />';
          $html .= '</li>';
        }
        if (in_array($i, array(2,3))) {
          $html .= $i == 2 ? '<ul class="dg-cover-column">' : '';
          $html .= '<li class="dg-cover-grow dg-cover-pos">';
          $html .= '<img class="'.(isset($cover->original) && dg::is_alpha_png($cover->original) ? 'dgimg dg-has-alpha' : 'dgimg').'" src="' . JHtml::_('datsogallery.image', (isset($cover->original) ? $cover->original : 'no_image.png'), $item->id, 0, 'categories', 1, '1:1') . '" alt="' . $item->title . '" />';
          $html .= '</li>';
          $html .= $i == 3 ? '</ul>' : '';
        }
$html .= '</li>';
      $i++;
    }
    $html .= '</ul>';
    } else {
      if (count($covers)) {
        foreach ($covers as $cover) {
          $html .= '<img class="'.(dg::is_alpha_png($cover->original) ? 'dgimg dg-has-alpha' : 'dgimg').'" src="' . JHtml::_('datsogallery.image', $cover->original, $item->id, 0, 'categories') . '" alt="' . $item->title . '" />';
        }
      } else {
        $html .= '<img class="dgimg" src="' . JHtml::_('datsogallery.image', 'no_image.png', $item->id, 0, 'categories') . '" alt="no_image" />';
      }
    }
    $html .= '</a>';
    $html .= JHtml::_('datsogallery.details', $item->id, $item->created_by, $item->title, $item->name, $item->created_time, $url, 'categories');
    $html .= JHtml::_('datsogallery.stats', $item->id, $parents, 0, 0, '', 0, 0, 0, '', '', '', 'categories');
    $html .= '</div>';
    if ($this->settings->categories_details) {
      $html .= '<div class="image-card">';
      if ($this->settings->categories_title && !$this->settings->categories_title_position) {
        $html .= '<h4 class="image-title"><a href="' . $url . '">' . $item->title . '</a></h4>';
      }
      if ($this->settings->categories_description) {
        $html .= '<p class="image-desc">' . strip_tags($item->description) . '</p>';
      }
      $html .= '</div>';
    }
    $html .= '</div>';
  }
} else {
  $html .= '<div class="dg-message-info">';
  $html .= '<h4>' . JText::_('NOTICE') . '</h4>';
  $html .= '<p>' . JText::_('COM_DATSOGALLERY_NO_ITEMS') . '</p>';
  $html .= '</div>';
}
$html .= '</div>';
$html .= '<div class="ias-conteiner"></div>';
if ($this->pagination->limit < $this->pagination->total) {
  $html .= '<div class="dg-pagination' . ($this->settings->category_pagination_type ? ' dg-hidden' : '') . '">';
  if (!$this->settings->category_pagination_type) {
    $html .= '<p class="counter pull-right">';
    $html .= $this->pagination->getPagesCounter();
    $html .= '</p>';
  }
  $html .= $this->pagination->getPagesLinks();
  $html .= '</div>';
}
if ($this->settings->backlink) {
  $html .= '<div class="backlink">';
  $html .= dg::backlink();
  $html .= '</div>';
}
$html .= '</div>';
echo $html;
$doc = JFactory::getDocument();
$doc->addScriptDeclaration('var dgrid = ".dg-grid";');
if ($this->settings->category_pagination_type) {
  $ias = ($this->pagination->limit >= $this->pagination->total) ? 'true' : 'false';
  $doc->addScriptDeclaration('var iasdestroy = ' . $ias . ';');
  $doc->addScriptDeclaration('var dgoffset = ' . (int) $this->settings->pagination_offset . ';');
} else {
  $doc->addScriptDeclaration('var iasdestroy = true;');
}