<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

require_once JPATH_ADMINISTRATOR . '/components/com_datsogallery/helpers/datsogallery.php';

class DatsogalleryRouter extends JComponentRouterBase
{
  public function build(&$query)
	{
		$sef_advanced = dg::getConfig()->sef_advanced;
		$segments     = array();
		if (empty($query['Itemid'])) {
			$menu = $this->menu->getActive();
		} else {
			$menu = $this->menu->getItem($query['Itemid']);
		}
		$menu_view = empty($menu->query['view']) ? null : $menu->query['view'];
		$catid     = empty($menu->query['catid']) ? null : $menu->query['catid'];
		$view      = '';
		if (isset($query['view'])) {
			$view = $query['view'];
			if (empty($query['Itemid'])) {
				$segments[] = $view;
			}
			unset($query['view']);
		}
		if ($menu_view == $view && isset($query['catid']) && $catid == $query['catid']) {
			unset($query['catid']);
			return $segments;
		}
		if (in_array($view, array('category', 'image')) && $sef_advanced) {
			$inactive = $catid != (int) $query['catid'];
			if ($inactive) {
				$categories = $this->getCategories($query['catid'], true);
				foreach ($categories as $category) {
					list($tmp, $category) = explode(':', $category, 2);
					$segments[]           = $category;
				}
			}
			unset($query['catid']);
			if (isset($query['id'])) {
				$image_alias             = $this->getPhoto($query['id']);
				list($tmp, $image_alias) = explode(':', $image_alias, 2);
				$segments[]              = $image_alias;
			}
			unset($query['id']);
		}
		switch ($view) {
			case 'category':
				if (!$sef_advanced) {
					$segments[] = 'view-album';
					$segments[] = $query['catid'];
					unset($query['catid']);
				}
				break;

			case 'image':
				if (!$sef_advanced) {
					$segments[] = 'view-photo';
					if (isset($query['catid'])) {
						$segments[] = $query['catid'];
						unset($query['catid']);
					}
					if (isset($query['id'])) {
						$segments[] = $query['id'];
						unset($query['id']);
					}
				}
				break;
			case 'upload':
				if ($menu_view != $view) {
					$segments[] = 'add-photo';
				}
				break;
			case 'favorites':
				if ($menu_view != $view) {
					$segments[] = 'my-favorites';
				}
				break;
			case 'members':
				if ($menu_view != $view) {
					$segments[] = 'our-members';
				}
				break;
			case 'search':
				if ($menu_view != $view) {
					$segments[] = 'search-results';
				}
				break;
			case 'tags':
				if ($menu_view != $view) {
					$segments[] = 'tags';
				}
				if (isset($query['tag'])) {
					$segments[] = $query['tag'];
				}
				unset($query['tag']);
				break;
			case 'colors':
				if ($menu_view != $view) {
					$segments[] = 'colors';
				}
				if (isset($query['hex'])) {
					$segments[] = $query['hex'];
				}
				unset($query['hex']);
				break;
			case 'member':
				if ($menu_view != $view) {
					$segments[] = 'images-by';
				}
				if (isset($query['id'])) {
					$username         = $this->getUsername($query['id']);
					list($tmp, $name) = explode(':', $username, 2);
					$segments[]       = $name;
				}
				unset($query['id']);
				break;
		}
		if (isset($query['limitstart'])) {
			unset($query['limitstart']);
		}
		return $segments;
	}

	public function parse(&$segments)
	{
		$sef_advanced = dg::getConfig()->sef_advanced;
		$db           = JFactory::getDbo();
		$total        = count($segments);
		$vars         = array();
		$main         = $this->menu->getItems('link', 'index.php?option=com_datsogallery&view=categories', true);
		$item         = $this->menu->getActive();
		$count        = count($segments);
		if ($sef_advanced) {
			$views = array('add-photo', 'my-favorites', 'search-results', 'tags', 'colors', 'our-members', 'images-by');
			if ($count && preg_grep("/page/i", @$segments)) {
				$found = 0;
				foreach ($segments as $segment) {
					$query = $db->getQuery(true)
						->select(array('id', 'parent_id', 'alias'))
						->from($db->qn('#__datsogallery_categories'));
					$db->setQuery($query);
					$rows = $db->loadObjectList();
					foreach ($rows as $row) {
						if ($row->alias == str_replace(':', '-', $segment)) {
							if (isset($segments[$count - 1])) {
								$vars['limitstart'] = $segments[$count - 1];
							}
							$vars['catid'] = $row->id;
							$vars['view']  = 'category';
							$rows          = $row->parent_id;
							$found         = 1;
							break;
						}
					}
				}
				$found = 0;
			} else {
				$found = 0;
				foreach ($segments as $segment) {
					if (isset($item->query['catid'])) {
						$query = $db->getQuery(true)
							->select($db->qn('id'))
							->from($db->qn('#__datsogallery_images'))
							->where($db->qn('catid') . ' = ' . (int) $item->query['catid'])
							->where($db->qn('alias') . ' = ' . $db->q(str_replace(':', '-', $segment)));
						$db->setQuery($query);
						$id            = $db->loadResult();
						$vars['catid'] = $item->query['catid'];
						$vars['view']  = 'image';
						$vars['id']    = $id;
					} else {
						$query = $db->getQuery(true)
							->select(array('id', 'parent_id', 'alias'))
							->from($db->qn('#__datsogallery_categories'));
						$db->setQuery($query);
						$rows = $db->loadObjectList();
						foreach ($rows as $row) {
							if ($row->alias == str_replace(':', '-', $segment)) {
								$vars['catid'] = $row->id;
								$vars['view']  = 'category';
								$rows          = $row->parent_id;
								$found         = 1;
								break;
							}
						}
					}
					if ($found == 0 && !preg_grep("/{$segments[$count - 1]}/", $views)) {
						$query = $db->getQuery(true)
							->select($db->qn('id'))
							->from($db->qn('#__datsogallery_images'))
							->where($db->qn('catid') . ' = ' . (int) @$vars['catid'])
							->where($db->qn('alias') . ' = ' . $db->q(str_replace(':', '-', $segment)));
						$db->setQuery($query);
						$id           = $db->loadResult();
						$vars['id']   = $id;
						$vars['view'] = 'image';
						break;
					}
					$found = 0;
				}
			}
		}
		if (isset($main->id) && $main->id == $item->id) {
			switch ($segments[0]) {
				case 'images-by':
					$vars['view'] = 'member';
					$vars['id']   = $this->getUserId($segments[$count - 1]);
					break;
				case 'our-members':
					$vars['view'] = 'members';
					break;
				case 'my-favorites':
					$vars['view'] = 'favorites';
					break;
				case 'search-results':
					$vars['view'] = 'search';
					break;
				case 'tags':
					$vars['view'] = 'tags';
					$vars['tag']  = $segments[$count - 1];
					break;

				case 'colors':
					$vars['hex']  = $segments[$count - 1];
					$vars['view'] = 'colors';
					break;
				case 'view-album':
					if (!$sef_advanced) {
						$vars['catid'] = $segments[1];
						$vars['view']  = 'category';
					}
					break;
				case 'view-photo':
					if (!$sef_advanced) {
						$vars['view'] = 'image';
						if (isset($segments[1])) {
							$vars['catid'] = $segments[1];
						}
						if (isset($segments[2])) {
							$vars['id'] = $segments[2];
						}
					}
					break;
			}
			return $vars;
		} else {
			if (isset($item->query['view']) && $item->query['view'] === 'member') {
				$vars['id']   = $this->getUserId($segments[$count - 1]);
				$vars['view'] = $item->query['view'];
			}
		}
		return $vars;
	}

	protected function getUsername($id)
	{
		if ((int) $id == 0) {
			return false;
		}
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true)
			->select($db->qn('username'))
			->from($db->qn('#__users'))
			->where($db->qn('id') . ' = ' . (int) $id);
		$db->setQuery($query);
		$alias = $db->loadResult();
		return $id . ':' . $alias;
	}

	protected function getUserId($username)
	{
		if (!isset($username)) {
			return false;
		}
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true)
			->select($db->qn('id'))
			->from($db->qn('#__users'))
			->where($db->qn('username') . ' = ' . $db->q($username));
		$db->setQuery($query);
		$id = $db->loadResult();
		return $id;
	}

	protected function getPhoto($id)
	{
		if ((int) $id == 0) {
			return false;
		}
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true)
			->select($db->qn('alias'))
			->from($db->qn('#__datsogallery_images'))
			->where($db->qn('id') . ' = ' . (int) $id);
		$db->setQuery($query);
		$alias = $db->loadResult();
		return $id . ':' . $alias;
	}

	protected function getCategories($catid, $begin = false)
	{
		static $array = array();
		if ((int) $catid == 0) {
			return false;
		}
		if ($begin) {
			$array = array();
		}
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true)
			->select(array('parent_id', 'alias'))
			->from($db->qn('#__datsogallery_categories'))
			->where($db->qn('id') . ' = ' . (int) $catid)
			->where($db->qn('alias') . ' != ' . $db->q('root'));
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		foreach ($rows as $row) {
			$alias = $catid . ':' . $row->alias;
			array_push($array, $alias);
			$this->getCategories($row->parent_id, false);
		}
		return array_reverse($array);
	}
}

function datsogalleryBuildRoute(&$query)
{
	$router = new DatsogalleryRouter;
	return $router->build($query);
}

function datsogalleryParseRoute($segments)
{
	$router = new DatsogalleryRouter;
	return $router->parse($segments);
}
