<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2019 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
jimport('joomla.application.component.modellist');

class DatsogalleryModelColors extends JModelList {

  public function __construct($config = array()) {
    parent::__construct($config);
  }

  protected function populateState($ordering = null, $direction = null) {
    $app = JFactory::getApplication();
    $settings = dg::getConfig();
    $params = JComponentHelper::getParams('com_datsogallery');
    $tag = $app->input->getString('hex', '');
    //$tag = JString::strtoupper($tag);
    //$tag = ltrim($tag, '#');
    $this->setState('list.hex', $tag);
    $limit = $app->input->get('limit', $settings->category_per_page, 'uint');
    $this->setState('list.limit', $limit);
    $limitstart = $app->input->get('limitstart', 0, 'uint');
    $this->setState('list.start', $limitstart);
    $this->setState('filter.language', JLanguageMultilang::isEnabled());
    $this->setState('params', $params);
  }

  protected function getListQuery() {
    $user = JFactory::getUser();
    $groups = implode(',', $user->getAuthorisedViewLevels());
    $db = $this->getDbo();
    $nullDate = $db->q($db->getNullDate());
    $date = JFactory::getDate();
    $nowDate = $db->q($date->toSql());
    $query = $db->getQuery(true);
    $query->select($this->getState('list.select', 'a.id, a.catid, a.title, a.description, a.original, a.featured, a.hits, a.downloads, a.created_by, a.created, u.id AS user_id, u.name AS user_name, u.email AS user_email, t.hex'));
    $query->from($db->qn('#__datsogallery_images', 'a'));
    $query->where($db->qn('a.access').' IN ('.$groups.')');
    $query->where($db->qn('a.state').' = 1');
    $query->where('('.$db->qn('a.publish_up').' = '.$nullDate.' OR '.$db->qn('a.publish_up').' <= '.$nowDate.')');
    $query->where('('.$db->qn('a.publish_down').' = '.$nullDate.' OR '.$db->qn('a.publish_down').' >= '.$nowDate.')');
    $query->select(array('u.id AS user_id', 'u.name AS user_name', 'u.email AS user_email'));
    $query->join('LEFT', $db->qn('#__users', 'u').' ON u.id = a.created_by');
    $query->select(array('c.title AS ca_title', 'c.path AS ca_path', 'c.created_by AS ca_created_by', 'c.created_time AS ca_created_time'));
    $query->join('LEFT', $db->qn('#__datsogallery_categories', 'c').' ON c.id = a.catid');
    $query->where($db->qn('c.access').' IN ('.$groups.')');
    $query->where($db->qn('c.published').' = 1');
    $query->where('('.$db->qn('c.publish_up').' = '.$nullDate.' OR '.$db->qn('c.publish_up').' <= '.$nowDate.')');
    $query->where('('.$db->qn('c.publish_down').' = '.$nullDate.' OR '.$db->qn('c.publish_down').' >= '.$nowDate.')');
    $query->join('LEFT', $db->qn('#__datsogallery_colors', 't').' ON t.image_id = a.id');
    $query->where($db->qn('t.hex').' = '.$db->q($this->getState('list.hex')));
    if (JLanguageMultilang::isEnabled()) {
      $query->where($db->qn('a.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      $query->where($db->qn('c.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
    }
    $query->group('a.id');
    $query->order('t.hex DESC');
    return $query;
  }

  public function getItems() {
    return parent::getItems();
  }

  public function hit() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->update($db->qn('#__datsogallery_colors'))
          ->set($db->qn('hits').'= hits + 1')
          ->where($db->qn('hex').' = '.$db->q($this->getState('list.hex')));
    $db->setQuery($query);
    return $db->execute();
  }

  public function getAllColors()
  {
    $db       = $this->getDbo();
    $query    = $db->getQuery(true);
    $query->select('DISTINCT hex')
      ->from('#__datsogallery_colors');
    $db->setQuery($query);
    return $db->loadColumn();
  }

  public function getPath() {
    $return = array();
    $parent_id = $this->getState('category.id');
    $row = JTable::getInstance('Category', 'DatsogalleryTable');
    while ($parent_id > 1) {
      $row->load($parent_id);
      $parent_id = $row->parent_id;
      $obj = new stdClass();
      $obj->title = $row->title;
      $obj->link = JRoute::_("index.php?option=com_datsogallery&amp;view=category&amp;catid=".$row->id.dg::itemId());
      $return [] = $obj;
    }
    krsort($return);
    return $return;
  }

}
