<?php
  /**
   * @package    com_datsogallery
   * @author     Andrey Datso <support@datso.fr>
   * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
   * @license    GNU General Public License version 2 or later; see LICENSE.txt
   */
  defined('_JEXEC') or die;

  abstract class JHtmlDatsogallery
  {

    public static function published($value = 0, $i, $canChange = true)
    {
      JHtml::_('bootstrap.tooltip');
      $states = array(0 => array('eye-slash', 'images.publish', 'COM_CONTENT_PUBLISHED', 'COM_CONTENT_TOGGLE_TO_PUBLISH'), 1 => array('eye', 'images.unpublish', 'COM_CONTENT_UNPUBLISHED', 'COM_CONTENT_TOGGLE_TO_UNPUBLISH'), );
      $state  = JArrayHelper::getValue($states, (int) $value, $states[1]);
      $icon   = $state[0];
      if ($canChange) {
        $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" class="btn-state hasTooltip' . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[3]) . '"><i class="dg-icon-' . $icon . '"></i></a>';
      } else {
        $html = '<a class="btn-state hasTooltip disabled' . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[2]) . '"><i class="dg-icon-' . $icon . '"></i></a>';
      }
      return $html;
    }

    public static function published1($value = 0, $i, $canChange = true)
    {
      JHtml::_('bootstrap.tooltip');
      $states = array(0 => array('eye-slash', 'categories.publish', 'COM_CONTENT_PUBLISHED', 'COM_CONTENT_TOGGLE_TO_PUBLISH'), 1 => array('eye', 'categories.unpublish', 'COM_CONTENT_UNPUBLISHED', 'COM_CONTENT_TOGGLE_TO_UNPUBLISH'), );
      $state  = JArrayHelper::getValue($states, (int) $value, $states[1]);
      $icon   = $state[0];
      if ($canChange) {
        $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" class="btn-state hasTooltip' . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[3]) . '"><i class="dg-icon-' . $icon . '"></i></a>';
      } else {
        $html = '<a class="btn-state hasTooltip disabled' . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[2]) . '"><i class="dg-icon-' . $icon . '"></i></a>';
      }
      return $html;
    }

    public static function featured($value = 0, $i, $canChange = true)
    {
      JHtml::_('bootstrap.tooltip');
      $states = array(
        0 => array('star-empty', 'images.featured', 'JUNFEATURED', 'COM_CONTENT_TOGGLE_TO_FEATURE'),
        1 => array('star', 'images.unfeatured', 'JFEATURED', 'COM_CONTENT_TOGGLE_TO_UNFEATURE'),
      );
      $state = JArrayHelper::getValue($states, (int) $value, $states[1]);
      $icon  = $state[0];
      if ($canChange) {
        $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" class="btn-state hasTooltip' . ($value == 1 ? ' featured' : ' featured') . '" title="' . JHtml::tooltipText($state[3]) . '"><i class="dg-icon-' . $icon . '"></i></a>';
      } else {
        $html = '<a class="btn-state hasTooltip disabled' . ($value == 1 ? '' : '') . '" title="' . JHtml::tooltipText($state[2]) . '"><i class="dg-icon-' . $icon . '"></i></a>';
      }
      return $html;
    }

    public static function appruved($value = 0, $i, $canChange = true)
    {
      JHtml::_('bootstrap.tooltip');
      $states = array(0 => array('eye-slash', 'eye-slash', 'COM_CONTENT_UNFEATURED', 'COM_CONTENT_TOGGLE_TO_FEATURE'), 1 => array('eye', 'eye', 'COM_CONTENT_FEATURED', 'COM_CONTENT_TOGGLE_TO_UNFEATURE'), );
      $state  = JArrayHelper::getValue($states, (int) $value, $states[1]);
      $icon   = $state[0];
      if ($canChange) {
        $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" class="btn-state hasTooltip' . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[3]) . '"><i class="dg-icon-' . $icon . '"></i></a>';
      } else {
        $html = '<a class="btn-state hasTooltip disabled' . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[2]) . '"><i class="dg-icon-' . $icon . '"></i></a>';
      }
      return $html;
    }

    public static function favorite($value = 0, $id = null, $allow = 0, $remove = false)
    {
      JHtml::_('bootstrap.tooltip');
      $user   = JFactory::getUser();
      $states = array(0 => array('unfavorited', 'favorited', 'COM_DATSOGALLERY_UNFAVORITED', 'COM_DATSOGALLERY_TOGGLE_TO_FAVORITE'), 1 => array('favorited', 'unfavorited', 'COM_DATSOGALLERY_FAVORITED', 'COM_DATSOGALLERY_TOGGLE_TO_UNFAVORITE'), );
      $state  = JArrayHelper::getValue($states, (int) $value, $states[1]);
      $icon   = $state[0];
      $html   = '';
      if ($allow && $user->id) {
        $html = '<li id="' . $id . '" class="dg-favicon' . ($remove ? ' dg-remove-favorite' : '') . ' hint--bottom-left hint--small' . ($value == 1 ? ' favorited' : ' unfavorited') . '" data-hint="' . JHtml::tooltipText($state[3]) . '"><span class="dgi-' . $icon . '"></span></li>';
      }
      return $html;
    }

    public static function is_featured($id = null, $image = false)
    {
      $html = (int) $id ? ($image ? '<div class="position-small position-bottom-left hint--top-right hint--small" data-hint="' . JText::_("COM_DATSOGALLERY_HOT") . '"><i class="dgi-hot" style="color:#fff;font-size: 15px;width: 30px;height: 30px;text-align: center;line-height: 30px;display: block;"></i></div>' : '<li class="box hint--top-right hint--small" data-hint="' . JText::_("COM_DATSOGALLERY_HOT") . '"><span class="dgi-hot"></span></li>') : '';
      return $html;
    }

    public static function is_animated($original)
    {
      $html = '<div class="position-small position-bottom-right hint--top-left" data-hint="' . JText::_("COM_DATSOGALLERY_ANIMATED_GIF") . '">' . dg::is_animated($original, true) . '</div>';
      return $html;
    }

    public static function download($id = null)
    {
      $user     = JFactory::getUser();
      $groups   = $user->getAuthorisedViewLevels();
      $settings = dg::getConfig();
      $html     = '';
      if ($id && $settings->allow_downloads && in_array($settings->download_access, $groups)) {
        $html .= '  <li id="' . (int) $id . '" class="dg-download-btn dg-download">';
        $html .= '    <ul class="hint--top hint--small" data-hint="' . JText::_("COM_DATSOGALLERY_DOWNLOAD_IMAGE") . '">';
        $html .= '      <li><i class="dgi-download"></i></li>';
        $html .= '    </ul>';
        $html .= '  </li>';
      }
      return $html;
    }

    public static function delete($value = 0, $i, $canChange = true)
    {
      JHtml::_('bootstrap.tooltip');
      $states = array(0 => array('trash', 'images.trash', 'COM_CONTENT_UNFEATURED', 'COM_CONTENT_TOGGLE_TO_FEATURE'), 1 => array('trash', 'images.untrash', 'COM_CONTENT_FEATURED', 'COM_CONTENT_TOGGLE_TO_UNFEATURE'), );
      $state  = JArrayHelper::getValue($states, (int) $value, $states[1]);
      $icon   = $state[0];
      if ($canChange) {
        $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" class="btn-state hasTooltip' . ($value == 0 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[3]) . '"><i class="dg-icon-' . $icon . '"></i></a>';
      } else {
        $html = '<a class="btn-state hasTooltip disabled' . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[2]) . '"><i class="dg-icon-' . $icon . '"></i></a>';
      }
      return $html;
    }

    public static function search()
    {
      $app      = JFactory::getApplication();
      $settings = dg::getConfig();
      $user     = JFactory::getUser();
      $groups   = $user->getAuthorisedViewLevels();
      $lang     = JFactory::getLanguage();
      $is_rtl   = $lang->get('rtl');
      $cmd      = $app->input->getCmd('view', '');
      $db       = JFactory::getDbo();
      $query    = $db->getQuery(true);
      $query->select('COUNT(id)');
      $query->from('`#__datsogallery_favorites`');
      $query->where('user_id = ' . (int) $user->id);
      $numfav = $db->setQuery($query)->loadResult();
      $sh     = $numfav ? 'block' : 'none';
      if ($cmd == 'categories') {
        $margin_y = $settings->categories_details && in_array(1, array($settings->categories_title,$settings->categories_description)) ? ' style="margin-bottom:'.$settings->categories_margin_y.'px"' : '';
      } else {
         $margin_y = $settings->category_details && in_array(1, array($settings->category_title,$settings->category_description)) ? ' style="margin-bottom:'.$settings->categories_margin_y.'px"' : '';
      }
      $html   = '';
      if ($settings->allow_search && in_array($settings->search_access, $groups)) {
        $html .= '<form id="dg-search-top" style="margin-bottom:'.$settings->categories_margin_y.'px" action="' . JRoute::_('index.php?option=com_datsogallery&amp;view=search' . dg::menuid('search')) . '" method="post" name="adminForm">';
        $html .= '  <ul>';
        $html .= '    <li class="dg-dashboard">';
        $html .= '       <div class="hint--top-right hint--small" data-hint="' . JText::_('COM_DATSOGALLERY_MAIN_PAGE') . '">';
        $html .= '         <a href="' . JRoute::_("index.php?option=com_datsogallery&amp;view=categories" . dg::menuid('categories')) . '"><span class="dgi-dashboard"></span></a>';
        $html .= '       </div>';
        $html .= '    </li>';
        $html .= '    <li class="dg-input-search">';
        $html .= '       <a href="javascript:void(0)"><i class="dg-icon-append dgi-search"></i></a>';
        $html .= '       <input type="text" name="searchword" id="filter-search" class="dg-input' . ((!$user->id && $cmd != 'colors') ? ' dg-right-radius' : '') . '" onchange="document.adminForm.submit();" title="' . JText::_('JSEARCH_FILTER') . '" placeholder="' . JText::_('JSEARCH_FILTER') . '" autocomplete="off">';
        $html .= '    </li>';
        if ($cmd == 'colors') {
          $html .= '    <li' . (!$user->id ? ' class="dg-right-radius"' : '') . '>';
          $html .= '      <div class="hint--top-left hint--small" data-hint="' . JText::_('COM_DATSOGALLERY_UNFOLD_COLORS') . '">';
          $html .= '        <a id="togglecolors" href="javascript:void(0)"><span class="dgi-palette"></span></a>';
          $html .= '      </div>';
          $html .= '    </li>';
        }
        if ($cmd == 'favorites' && $numfav > 0 && $user->id && $settings->download_favorites && $settings->allow_favorites) {
          $html .= '    <li>';
          $html .= '       <div class="zipdownload hint--top-left hint--small" data-hint="' . JText::_('COM_DATSOGALLERY_DOWNLOAD_FAVORITES') . '">';
          $html .= '         <span class="dgi-archive"></span>';
          $html .= '       </div>';
          $html .= '    </li>';
        }
        if ($user->id && $settings->allow_favorites) {
          $html .= '    <li>';
          $html .= '      <div style="display:' . $sh . '" id="my-favorites" class="hint--top-left hint--small" data-hint="' . JText::_('COM_DATSOGALLERY_FAVORITES_ICON') . '">';
          $html .= '        <a href="' . JRoute::_('index.php?option=com_datsogallery&view=favorites' . dg::menuid('favorites')) . '"><span class="dgi-favorites"></span></a>';
          $html .= '        <span id="pulsor" class="dg-fav-badge">' . $numfav . '</span>';
          $html .= '      </div>';
          $html .= '    </li>';
        }
        if ($user->id && $user->authorise('core.create', 'com_datsogallery')) {
          $html .= '    <li>';
          $html .= '      <div class="hint--top-left hint--small" data-hint="' . JText::_('COM_DATSOGALLERY_UPLOAD_STEP_ONE') . '">';
          $html .= '        <a href="' . JRoute::_('index.php?option=com_datsogallery&view=upload' . dg::menuid('upload')) . '"><span class="dgi-add-image"></span></a>';
          $html .= '      </div>';
          $html .= '    </li>';
        }
        if ($user->id) {
          $html .= '    <li class="dg-user-avatar">';
          $html .= dg::avatar($user->id, null, false, true, false, 'search');
          $html .= '    </li>';
        }
        $html .= '  </ul>';
        $html .= '</form>';
        return $html;
      }
    }

    public static function actions($id = null, $geo = null, $created_by = null, $liked = null)
    {
      $app      = JFactory::getApplication();
      $user     = JFactory::getUser();
      $groups   = $user->getAuthorisedViewLevels();
      $settings = dg::getConfig();
      $canEdit  = $user->authorise('core.edit', 'com_datsogallery.image.' . (int) $id);
      if ($canEdit || $user->authorise('core.edit.own', 'com_datsogallery.image.' . (int) $id)) {
        $canEdit = $user->id == (int) $created_by;
      }
      $canDelete = $user->authorise('core.delete', 'com_datsogallery.image.' . (int) $id);
      if ($canDelete || $user->authorise('core.delete.own', 'com_datsogallery.image.' . (int) $id)) {
        $canDelete = $user->id == (int) $created_by;
      }
      $html       = '';
      $is_liked   = $liked ? ' liked' : '';
      $liked_icon = $is_liked ? 'like' : 'likes';
      $like_hint  = $liked ? JText::_("COM_DATSOGALLERY_ALREADY_LIKED") : JText::_("COM_DATSOGALLERY_LIKE");
      $html .= '<div class="dg-separator dg-actions"><ul class="dg-flex-margin-5 dg-flex-nowrap">';
      $html .= '  <li id="' . (int) $id . '" class="dg-like-btn image' . $is_liked . '">';
      $html .= '    <ul class="hint--top hint--small" data-hint="' . $like_hint . '">';
      $html .= '      <li><i class="dgi-' . $liked_icon . '"></i></li>';
      $html .= '    </ul>';
      $html .= '  </li>';
      $html .= self::favorite(dg::is_favorited($id), $id, $settings->allow_favorites, 0);
      $html .= self::download((int) $id);
      if ($settings->addthis) {
        $html .= '  <li class="dg-share-btn" data-toggle="modal" data-target="#modalShare">';
        $html .= '    <ul class="hint--top hint--small" data-hint="' . JText::_("COM_DATSOGALLERY_SHARE_HINT") . '">';
        $html .= '      <li><i class="dgi-share"></i></li>';
        $html .= '    </ul>';
        $html .= '  </li>';
      }
      if ($settings->allow_geotagging && $settings->image_geolocation && $geo) {
        $html .= '  <li class="dg-map-btn" data-toggle="modal" data-target="#modalMap">';
        $html .= '    <ul class="dg-map-view hint--top hint--small" data-hint="' . JText::_("COM_DATSOGALLERY_VIEW_MAP") . '">';
        $html .= '      <li><i class="dgi-map"></i></li>';
        $html .= '    </ul>';
        $html .= '  </li>';
      }
      if ($settings->allow_report && in_array($settings->report_access, $groups)) {
        $html .= '  <li id="report_image" class="dg-report-btn" data-toggle="modal" data-target="#modalReport">';
        $html .= '    <ul class="hint--top hint--small" data-hint="' . JText::_("COM_DATSOGALLERY_REPORT_IMAGE") . '">';
        $html .= '      <li><i class="dgi-report"></i></li>';
        $html .= '    </ul>';
        $html .= '  </li>';
      }
      if ($settings->allow_fancybox && in_array($settings->fancybox_access, $groups)) {
        $html .= '  <li id="' . (int) $id . '" class="dg-fb">';
        $html .= '    <ul class="hint--top hint--small" data-hint="' . JText::_("COM_DATSOGALLERY_ENLARGE_SB") . '">';
        $html .= '      <li><i class="dgi-fullscreen"></i></li>';
        $html .= '    </ul>';
        $html .= '  </li>';
      }
      if ($canEdit) {
        $html .= '  <li class="dg-edit-btn">';
        $html .= '    <a id="' . (int) $id . '" class="dg-edit-image">';
        $html .= '      <ul class="hint--top hint--small" data-hint="' . JText::_("COM_DATSOGALLERY_EDIT_ITEM") . '">';
        $html .= '        <li><i class="dgi-edit"></i></li>';
        $html .= '      </ul>';
        $html .= '    </a>';
        $html .= '  </li>';
      }
      if ($canDelete) {
        $html .= '  <li class="dg-delete-btn">';
        $html .= '    <a  id="' . (int) $id . '" class="dg-delete-image">';
        $html .= '      <ul class="hint--top hint--small" data-hint="' . JText::_("COM_DATSOGALLERY_DELETE_ITEM") . '">';
        $html .= '        <li><i class="dgi-delete"></i></li>';
        $html .= '      </ul>';
        $html .= '    </a>';
        $html .= '  </li>';
      }
      $html .= '</ul></div>';
      return $html;
    }

    public static function overlay($id = null,
      $user_id = null,
      $user_name = '',
      $original = '',
      $featured = null,
      $hits = null,
      $downloads = null,
      $href = '',
      $title = '',
      $created = '') {
      $config = dg::getConfig();
      $user   = JFactory::getUser();
      $groups = $user->getAuthorisedViewLevels();
    if ($config->category_stats) {?>
    <div class="stats-bar">
      <ul>
        <li class="dg-featured">
          <ul>
            <?php
              echo dg::is_animated($original);
                    echo self::is_featured($featured);
                  ?>
          </ul>
        </li>
        <li class="box">
          <span class="dgi-visibility"></span>
          <span><?=dg::human_number($hits);?></span>
        </li>
        <?php if ($config->allow_downloads) {?>
        <li class="box">
          <span class="dgi-download"></span>
          <span><?=dg::human_number($downloads);?></span>
        </li>
        <?php }if ($config->allow_comments) {?>
        <li class="box">
          <span class="dgi-comments"></span>
          <span><?=dg::numcomments($id);?></span>
        </li>
        <?php }if ($config->allow_rating && in_array($config->rating_access, $groups) && $config->category_likes) {
                  $like       = dg::is_liked($id) == 1 ? 1 : 0;
                  $liked      = $like ? ' liked' : '';
                  $liked_icon = $like ? 'like' : 'likes';
                  $liked_hint = $like ? JText::_("COM_DATSOGALLERY_ALREADY_LIKED") : JText::_("COM_DATSOGALLERY_LIKE");
                ?>
        <li class="box hint--top-left hint--small" data-hint="<?=$liked_hint;?>">
          <span id="<?=$id;?>" class="like-btn cat dgi-<?=$liked_icon;?><?=$liked;?>"></span>
          <span class="likes-count"><?=dg::numlikes($id);?></span>
        </li>
        <?php
        }; //echo self::favorite(dg::is_favorited($id), $id, $config->allow_favorites);?>
      </ul>
    </div>
    <?php }?>
<?php
  }

    public static function management($id = null, $catid = null, $created_by = null, $notify = null)
    {
      $config  = dg::getConfig();
      $user    = JFactory::getUser();
      $canEdit = $user->authorise('core.edit', 'com_datsogallery.image.' . (int) $id);
      if ($canEdit || $user->authorise('core.edit.own', 'com_datsogallery.image.' . (int) $id)) {
        $canEdit = $user->id == (int) $created_by;
      }
      $canDelete = $user->authorise('core.delete', 'com_datsogallery.image.' . (int) $id);
      if ($canDelete || $user->authorise('core.delete.own', 'com_datsogallery.image.' . (int) $id)) {
        $canDelete = $user->id == (int) $created_by;
      }
      $html = '';
      if (in_array(1, array($canEdit, $canDelete))) {
        $html .= '<ul class="dg-management position-top-right">';
        if ($canEdit) {
          $html .= '  <li>';
          $html .= '    <a id="'.$id.'" class="dg-edit-image hint--left hint--small" data-hint="' . JText::_('COM_DATSOGALLERY_EDIT_ITEM') . '">';
          $html .= '    <i class="dgi-edit"></i></li>';
          $html .= '    </a>';
          $html .= '  </li>';
        }
        if ($canDelete) {
          $html .= '  <li>';
          $html .= '    <a class="hint--left hint--small deleteajax" data-hint="' . JText::_('COM_DATSOGALLERY_DELETE_ITEM') . '">';
          $html .= '    <i class="dgi-delete"></i>';
          $html .= '    </a>';
          $html .= '  </li>';
        }
        if ($config->comment_notify) {
          $html .= '  <li id="' . (int) $created_by . '">';
          $html .= '    <a id="' . (int) $id . '" class="hint--left hint--small notifysingle" data-hint="' . JText::_($notify ? 'COM_DATSOGALLERY_UNNOTIFY' : 'COM_DATSOGALLERY_NOTIFY') . '">';
          $html .= '    <i class="dgi-notifications' . ((int) $notify ? '-on' : '') . '"></i><input name="' . (int) $id . '" type="hidden" value="' . (int) $notify . '">';
          $html .= '    </a>';
          $html .= '  </li>';
        }
        $html .= '</ul>';
      }
      return $html;
    }

    public static function stats($id = null, $parents = null, $user_id = null, $user_name = '',
      $original = '', $featured = null, $hits = null, $downloads = null, $href = '',
      $title = '', $created = '', $view = '') {
      $config = dg::getConfig();
      $user   = JFactory::getUser();
      $groups = $user->getAuthorisedViewLevels();
      $html   = '';
      if (!empty($view)) {
        switch ($view) {
          case 'categories':
            if ($config->categories_stats) {
              $html .= '<div class="stats-bar">';
              $html .= '  <ul>';
              if ((count($parents) - 1) > 0) {
                $html .= '    <li class="box">';
                $html .= '      <span class="dgi-album"></span>';
                $html .= '      <span>' . (count($parents) - 1) . '</span>';
                $html .= '    </li>';
              }
              $html .= '    <li class="box">';
              $html .= '      <span class="dgi-image"></span>';
              $html .= '      <span>' . dg::numimagesCat($id) . '</span>';
              $html .= '    </li>';
              $html .= '  </ul>';
              $html .= '</div>';
            }
            break;
          case 'category':
            if (in_array(1,
              array(
                $config->category_featured,
                $config->category_hits,
                $config->category_downloads,
                $config->category_comments,
                $config->category_likes
              ))) {
              $html .= '<div class="stats-bar">';
              $html .= '  <ul>';
              $html .= '    <li class="dg-featured">';
              $html .= '      <ul>';
              $html .= dg::is_animated($original);
              if ($config->category_featured) {
                $html .= self::is_featured($featured);
              }
              $html .= '      </ul>';
              $html .= '    </li>';
              if ($config->category_hits) {
                $html .= '    <li class="box">';
                $html .= '      <span class="dgi-visibility"></span>';
                $html .= '      <span>' . dg::human_number($hits) . '</span>';
                $html .= '    </li>';
              }
              if ($config->allow_downloads && $config->category_downloads) {
                $html .= '    <li class="box">';
                $html .= '      <span class="dgi-download"></span>';
                $html .= '      <span>' . dg::human_number($downloads) . '</span>';
                $html .= '    </li>';
              }
              if ($config->allow_comments && $config->category_comments) {
                $html .= '    <li class="box">';
                $html .= '      <span class="dgi-comments"></span>';
                $html .= '      <span>' . dg::numcomments($id) . '</span>';
                $html .= '    </li>';
              }
              if ($config->allow_rating && in_array($config->rating_access, $groups) && $config->category_likes) {
                $like       = dg::is_liked($id) == 1 ? 1 : 0;
                $liked      = $like ? ' liked' : '';
                $liked_icon = $like ? 'like' : 'likes';
                $liked_hint = $like ? JText::_("COM_DATSOGALLERY_ALREADY_LIKED") : JText::_("COM_DATSOGALLERY_LIKE");
                $html .= '    <li class="box dg-like-btn hint--top-left hint--small" data-hint="' . $liked_hint . '">';
                $html .= '      <span id="' . $id . '" class="cat dgi-' . $liked_icon . '' . $liked . '"></span>';
                $html .= '      <span class="likes-count">' . dg::numlikes($id) . '</span>';
                $html .= '    </li>';
              }
              $html .= '  </ul>';
              $html .= '</div>';
            }
            break;
        }
      }
      return $html;
    }

    public static function details($id = null, $user_id = null, $title = '', $user_name = '',
      $created_time = '', $href = '', $view = '', $catid = null) {
      $config = dg::getConfig();
      $app    = JFactory::getApplication();
      $page   = $app->input->getCmd('view', '');
      $remove = $page == 'favorites' ? 1 : 0;
      $html   = '';
      if (!empty($view)) {
        switch ($view) {
          case 'categories':
          case 'search':
            if ($config->categories_details
              && in_array(1, array($config->categories_avatar, $config->categories_title, $config->categories_owner, $config->categories_date))) {
              $html .= '<div class="stats-bar-top">';
              $html .= '  <ul>';
              if ($config->categories_avatar) {
                $html .= '    <li>' . dg::avatar($user_id, null, false, true, false, 'category') . '</li>';
              }
              $html .= '    <li class="user-data">';
              $html .= '      <ul>';
              if ($config->categories_title && $config->categories_title_position) {
              $html .= '        <li>';
              $html .= '          <div>';
              $html .= '            <a class="ellipsis" href="' . $href . '" title="' . $title . '">' . $title . '</a>';
              $html .= $title;
              $html .= '            </a>';
              $html .= '          </div>';
              $html .= '        </li>';
              }
              if (in_array(1, array($config->categories_owner, $config->categories_date))) {
                $html .= '        <li class="dg-added">';
                if ($config->categories_owner) {
                  $html .= '          <span>' . $user_name . '</span>';
                }
                if ($config->categories_title && $config->categories_title_position) {
                  if ($config->categories_owner && $config->categories_date) {
                    $html .= '          <span>&nbsp;&bull;&nbsp;</span>';
                  }
                } else {
                  $html .= '        </li><li>';
                }
                if ($config->categories_date) {
                  $html .= '          <span' . ($config->categories_title && $config->categories_title_position ? '' : ' class="in-category"') . '>' . dg::timelapse($created_time, $config->categories_date_format) . '</span>';
                }
                $html .= '        </li>';
              }
              $html .= '      </ul>';
              $html .= '    </li>';
              $html .= '  </ul>';
              $html .= '</div>';
            }
            break;
          case 'category':
            if ($config->category_details) {
              $html .= '<div class="stats-bar-top">';
              $html .= '  <ul>';
              if ($config->category_avatar) {
                $html .= '    <li>' . dg::avatar($user_id, null, false, true, false, 'category') . '</li>';
              }
              $html .= '    <li class="user-data">';
              $html .= '      <ul>';
              if ($config->category_title && $config->category_title_position) {
                $html .= '        <li>';
                $html .= '          <a class="ellipsis" href="' . $href . '" title="' . $title . '">' . $title . '</a>';
                $html .= '        </li>';
              }
              if (in_array(1, array($config->category_owner, $config->category_date))) {
                $html .= '        <li class="dg-added">';
                if ($config->category_owner) {
                  $html .= '          <span>' . $user_name . '</span>';
                }
                if ($config->category_title && $config->category_title_position) {
                  if ($config->category_owner && $config->category_date) {
                    $html .= '          <span>&nbsp;&bull;&nbsp;</span>';
                  }
                } else {
                  $html .= '        </li><li>';
                }
                if ($config->category_date) {
                  $html .= '          <span' . ($config->category_title && $config->category_title_position ? '' : ' class="in-category"') . '>' . dg::timelapse($created_time, $config->category_date_format) . '</span>';
                }
                $html .= '        </li>';
              }
              if ($page != 'category') {
                $html .= '        <li class="in-category">' . JText::_('COM_DATSOGALLERY_IN') . '<a class="in-category" href="' . JRoute::_("index.php?option=com_datsogallery&amp;view=category&amp;catid=" . (int) $catid . dg::menuid((int) $catid)) . '">' . dg::catnamebyid((int) $catid) . '</a></li>';
              }
              $html .= '      </ul>';
              $html .= '    </li>';
              $html .= self::favorite(dg::is_favorited($id), $id, $config->allow_favorites, $remove);
              $html .= '  </ul>';
              $html .= '</div>';
            }
            break;
        }
      }
      return $html;
    }

    public static function image($original, $id, $catid, $view = '', $crop = false, $ratio = '', $double = false)
    {
      $config = dg::getConfig();
      $prefix = $view == 'image' ? 'image' : '_image';
      $suffix = $view == 'image' ? '_details' : '';
      $view   = $view == 'image' ? '' : $view;
      $width  = $config->{$view . $prefix . '_width' . $suffix};
      $height = $config->{$view . $prefix . '_height' . $suffix};
      $size = @getimagesize(JPath::clean(JPATH_SITE . $config->path_to_originals . '/' . $original));
      return resize($original ? $original : dg::catcover($id),
        $double ? ($size[0] > ($width * 2) ? ($width * 2) : $size[0]) : $width,
        $double ? ($size[1] > ($height * 2) ? ($height * 2) : $size[1]) : $height,
        $crop ? $crop : $config->{$view . $prefix . '_resize_method' . $suffix},
        ($crop && !empty($ratio)) ? $ratio : $config->{$view . $prefix . '_aspect_ratio' . $suffix},
        $config->{$view . $prefix . '_watermark'},
        $catid,
        '',
        $config->{$view . $prefix . '_quality' . $suffix},
        false,
        $config->{$view . $prefix . '_watermark_position'});
    }
}
