<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

//require_once JPATH_COMPONENT_ADMINISTRATOR . '/helpers/datsogallery.php';

class captcha
{
  private $length = 4;
  private $width  = 80;
  private $height = 40;
  private $font;
  private $engine = '';

  public function __construct($setting = [])
  {
    $this->font = JPATH_COMPONENT . '/assets/fonts/captcha/ghost.ttf';
    if (dg::getConfig()->builtin_captcha_type) {
      $this->width = 100;
    }
    foreach ($setting as $key => $val) {
      $this->{$key} = $val;
    }
  }

  public function get($captcha = '')
  {
    $support             = $this->support();
    list($code, $answer) = $this->generateCode();
    $image               = null;
    $session             = JFactory::getSession();
    $session->set($captcha, strtolower($answer));
    if ($support == 'im') {
      $image = new \Imagick();
      $image->newImage($this->width, $this->height, 'none');
      $image->setImageFormat('png');
      $image = $this->imagickDrawText($image, $code);
      $image->swirlImage(30);
      header('Content-type: image/png; Cache-Control: no-store, no-cache, must-revalidate');
      ob_clean();
      echo $image->getImageBlob();
    } else {
      $image = imagecreate($this->width, $this->height);
      $color = imagecolorallocate($image, 255, 255, 255);
      imagecolortransparent($image, $color);
      $this->gdDrawText($image, $code);
      header('Content-type: image/png; Cache-Control: no-store, no-cache, must-revalidate');
      ob_clean();
      imagepng($image);
      imagedestroy($image);
    }
  }

  protected function generateCode()
  {
    $answer = '';
    if (dg::getConfig()->builtin_captcha_type) {
      $operate               = ['+', '-'];
      $opindex               = rand(0, 1);
      $opnum1                = rand(0, 9);
      $opnum2                = rand(0, 9);
      list($opnum1, $opnum2) = $opindex == 1 ? [max($opnum1, $opnum2), min($opnum1, $opnum2)] : [$opnum1, $opnum2];
      $code                  = $opnum1 . $operate[$opindex] . $opnum2 . '=?';
      $answer                = $opindex == 1 ? $opnum1 - $opnum2 : $opnum1 + $opnum2;
    } else {
      $code   = md5(time());
      $code   = substr($code, rand(3, 5), $this->length);
      $code   = str_replace(['2', '0', 'o', '1', 'i'], ['Z', '9', '8', 'L', 'A'], $code);
      $code   = strtoupper($code);
      $answer = $code;
    }
    return [$code, $answer];
  }

  protected function imagickDrawText($image, $text)
  {
    $draw = new \ImagickDraw();
    $draw->setFont($this->font);
    $draw->setFontSize($this->height * 0.8);
    $draw->setFillColor(new \ImagickPixel('#808080'));
    $draw->setStrokeAntialias(true);
    $draw->setTextAntialias(true);
    $metrics = $image->queryFontMetrics($draw, $text);
    $draw->annotation(0, $metrics['ascender'], $text);
    $image->drawImage($draw);
    $draw->destroy();
    return $image;
  }

  protected function gdDrawText($image, $text)
  {
    $code  = md5(time());
    $color = imagecolorallocate($image, 128, 128, 128);
    imagettftext($image, $this->height * 0.6, 3, $this->width * 0.05, $this->height * 0.8, $color, $this->font, $text);
  }

  protected function support()
  {
    if ($this->engine) {
      return $this->engine;
    }
    if (class_exists('Imagick')) {
      return 'im';
    }
    return 'gd';
  }
}