<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

$app    = JFactory::getApplication();
$user   = JFactory::getUser();
$menu   = $app->getMenu();
$main   = $menu->getItems('link', 'index.php?option=com_datsogallery&view=categories', true);
$lang   = JFactory::getLanguage();
$code   = substr($lang->getTag(), 0, 2) == 'ru' ? 'ru/' : '';
$is_admin = $user->authorise('core.admin');
if (!$main->id) {
  $app->enqueueMessage(($is_admin ? JText::sprintf('COM_DATSOGALLERY_ERROR_NO_MENU_ITEM_ADMIN', '<a href="https://www.datso.fr/'.$code.'products/datsogallery/documentation.html" target="_blank">'.JText::_('COM_DATSOGALLERY_ERROR_NO_MENU_ITEM_LINK').'</a>') : JText::_('COM_DATSOGALLERY_ERROR_NO_MENU_ITEM_USER')), 'error');
  $app->redirect('index.php');
}

JPluginHelper::importPlugin('system', 'datsoredirect');
$dispatcher = JDispatcher::getInstance();
$dispatcher->trigger('onAfterDispatch', array());

require_once JPATH_ADMINISTRATOR . '/components/com_datsogallery/helpers/datsogallery.php';

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

$controller = JControllerLegacy::getInstance('Datsogallery');
$controller->execute(JFactory::getApplication()->input->get('task'));
$controller->redirect();
