<?php
  /**
   * @package    com_datsogallery
   * @author     Andrey Datso <support@datso.fr>
   * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
   * @license    GNU General Public License version 2 or later; see LICENSE.txt
   */
  defined('_JEXEC') or die;

  use Joomla\CMS\Factory;

  require_once JPATH_COMPONENT . '/controller.php';
  require_once JPATH_COMPONENT_ADMINISTRATOR . '/images.php';

  jimport('joomla.filesystem.folder');
  jimport('joomla.filesystem.file');
  jimport('joomla.filesystem.archive');

  class DatsogalleryControllerUpload extends DatsogalleryController
  {

    public function __construct($default = array())
    {
      $document = JFactory::getDocument();
      $doc      = JDocument::getInstance('raw');
      $document = $doc;
      $document->setMimeEncoding('application/json');
      parent::__construct($default);
    }

    public function process()
    {
      JSession::checkToken('get') or die(JText::_('JINVALID_TOKEN'));
      require_once JPATH_COMPONENT . '/helpers/uploader.php';
      $settings   = dg::getConfig();
      $extensions = explode(',', $settings->extensions);
      $user       = JFactory::getUser();
      $isroot     = $user->authorise('core.admin');
      $aup        = !$isroot ? $settings->{'acl_' . max($user->groups)} : 0;
      $tup        = dg::userimages();
      $max        = (!$isroot && $aup != '-1') ? $aup : 0;
      $tmp_dir    = JPATH_SITE . $settings->path_to_tmp . '/' . $user->id;
      $settings   = array(
        'uploadFolder' => $tmp_dir,
        'maxFileSize' => dg::mb2kb($settings->max_filesize, $settings->max_filesize_format),
        'protectUploadDirectory' => $settings->protect_upload_dir ? false : false,
        'extension' => array_values($extensions),
        'maxWidth' => $settings->upload_max_width,
        'maxHeight' => $settings->upload_max_height
      );
      $uploader = new RealTimeUpload();
      $uploader->init($settings);
      exit();
    }

    public function resizetmpfile()
    {
      $settings = dg::getConfig();
      $input    = Factory::getApplication()->input;
      $user     = JFactory::getUser();
      $prev     = $settings->path_to_tmp . '/' . $user->id . '/';
      resize($input->getString('preview'), 300, 300, 1, '1:1', 0, 0, $prev, 70);
      exit();
    }

    public function save()
    {
      JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
      $app    = Factory::getApplication();
      $access = $app->get('access');
      $post   = $app->input->post->getArray();
      //var_dump($post);
      jimport('joomla.filesystem.folder');
      jimport('joomla.filesystem.file');
      jimport('joomla.utilities.date');
      require_once JPATH_COMPONENT_ADMINISTRATOR . '/images.php';
      require JPATH_COMPONENT_SITE . '/controllers/datso.iptc.php';
      JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR . '/tables');
      $settings  = dg::getConfig();
      $db        = JFactory::getDbo();
      $user      = JFactory::getUser();
      $isroot    = $user->authorise('core.admin');
      $language  = JFactory::getLanguage()->getTag();
      $model     = $this->getModel('Image', 'DatsogalleryModel');
      $itemid    = dg::itemId(true);
      $tmp_dir   = JPATH_SITE . $settings->path_to_tmp . '/' . $user->id;
      $multilang = JLanguageMultilang::isEnabled();
      array_multisort(array_map('base64_decode', ($files = JFolder::files($tmp_dir))), SORT_ASC, $files);
      $i = 0;
      foreach ($files as $file) {
        $table        = JTable::getInstance('Image', 'DatsogalleryTable');
        $catid        = (!empty($post['catid'][$i]) && !$post['generic-all']) ? $post['catid'][$i] : $post['gcatid'];
        $filename     = JFile::stripExt(JFile::getName($file));
        $ext          = strtolower(JFile::getExt($file));
        $origfilename = $file;
        if (!$ext) {
          JFile::delete($tmp_dir . '/' . $origfilename);
        } else {
          //$newfilename = ($fname) ? dg::sanitize($filename).'.'.$ext : self::dgImgId($catid, $ext);
          $newfilename = self::dgImgId($catid, $ext);
          if (JFile::move($tmp_dir . '/' . $origfilename, JPATH_SITE . $settings->path_to_originals . '/' . $newfilename)) {
            JFile::delete($tmp_dir . '/' . $origfilename);
          }
          $date = JFactory::getDate()->toSql();
          $data = array(
            'title' => (!empty($post['title'][$i]) && !$post['generic-all']) ? $post['title'][$i] : $post['generic-title'] . ' ' . ($i + 1),
            'alias' => (!empty($post['title'][$i]) && !$post['generic-all']) ? dg::sanitize($post['title'][$i]) : dg::sanitize($post['generic-title']) . '-' . ($i + 1),
            'original' => $newfilename,
            'description' => (!empty($post['description'][$i]) && !$post['generic-all']) ? $post['description'][$i] : $post['generic-description'],
            'state' => 1,
            'approved' => ($settings->upload_approval && !$isroot) ? 0 : 1,
            'catid' => $catid,
            'created' => $date,
            'created_by' => $user->id,
            'access' => $access,
            'params' => '',
            'language' => $multilang ? (!empty($post['language'][$i]) && !$post['generic-all'] ? $post['language'][$i] : $post['generic-language']) : '*',
            'lat' => (!empty($post['lat'][$i]) && !$post['generic-all']) ? $post['lat'][$i] : $post['generic-lat'],
            'lng' => (!empty($post['lng'][$i]) && !$post['generic-all']) ? $post['lng'][$i] : $post['generic-lng'],
            'author' => (!empty($post['author'][$i]) && !$post['generic-all']) ? $post['author'][$i] : $post['generic-author'],
            'author_url' => (!empty($post['authorurl'][$i]) && !$post['generic-all']) ? $post['authorurl'][$i] : $post['generic-authorurl']
          );
          $generic_tags = explode(',', $post['generic-tag']);
          $image_tags   = explode(',', $post['image-tags'][$i]);
          $tags         = $post['generic-all'] ? $generic_tags : (empty($post['image-tags'][$i]) ? $generic_tags : (array_merge($generic_tags, $image_tags)));
          if (is_array($tags)) {
            if ($model->addTags($tags) === false) {
              return $model->getError();
            }
          }
          $i++;
          if (!$table->bind($data)) {
            $this->setError($table->getError());
            return false;
          }
          if (!$table->check()) {
            $this->setError($table->getError());
            return false;
          }
          if (!$table->store()) {
            $this->setError($table->getError());
            return false;
          }
        }
      }
      if (JFolder::exists($tmp_dir)) {
        JFolder::delete($tmp_dir);
      }
      if ($settings->avatar_service == 3 && $settings->js_activities) {
        dg::js_activities($user->id, $catid, count($files));
      }
      if ($settings->avatar_service == 6) {
        dg::es_activities($user->id, $catid, count($files));
      }
      if ($settings->upload_approval && !$isroot) {
        $body = sprintf(JText::_('COM_DATSOGALLERY_COMMENT_NOTIFY_HELLO'), JText::_('JADMINISTRATOR')) . "\r\n\r\n";
        $body .= sprintf(JText::_('COM_DATSOGALLERY_UPLOAD_NOTIFY_ADMIN'), $user->name, dg::catbyid($catid)) . "\r\n\r\n";
        $body .= JText::_('COM_DATSOGALLERY_MAIL_MSG');
        $subject = sprintf(JText::_('COM_DATSOGALLERY_UPLOAD_NOTIFY_SUBJECT'), $app->getCfg('sitename'));
        dg::sendmail('', $subject, $body);
        $app->redirect(JRoute::_('index.php?option=com_datsogallery&amp;view=categories' . $itemid, false),
          JText::_('COM_DATSOGALLERY_UPLOAD_APPROVAL_SUCCESS'));
      } elseif ($settings->category_approval && !$isroot) {
        $app->redirect(JRoute::_('index.php?option=com_datsogallery&amp;view=categories' . $itemid, false),
          JText::_('COM_DATSOGALLERY_UPLOAD_APPROVAL_SUCCESS'));
      } else {
        $app->redirect(JRoute::_('index.php?option=com_datsogallery&amp;view=category&amp;catid=' . $catid . $itemid, false),
          JText::_('COM_DATSOGALLERY_UPLOAD_SUCCESS'));
      }
    }

    public function tmpimg()
    {
      JSession::checkToken('get') or die(JText::_('JINVALID_TOKEN'));
      $user = JFactory::getUser();
      if (!$user->id) {
        exit;
      }
      $model = $this->getModel('Upload', 'DatsogalleryModel');
      $model->add_member_album();
      require_once JPATH_COMPONENT_ADMINISTRATOR . '/images.php';
      require_once JPATH_COMPONENT_SITE . '/controllers/datso.iptc.php';
      $app        = Factory::getApplication();
      $settings   = dg::getConfig();
      $languages  = JLanguage::getKnownLanguages();
      $directory  = $settings->path_to_tmp . '/' . $user->id . '/';
      $tmpurl     = JUri::root(true) . $settings->path_to_tmp . '/' . $user->id . '/';
      $file_parts = array();
      $ext        = '';
      $title      = '';
      $catid      = $app->getUserStateFromRequest('catid.com_datsogallery', 'catid', 0, 'int');
      $lang       = JFactory::getLanguage();
      $icon_dir   = $lang->get('rtl') ? 'prepend' : 'append';
      $tip_align  = $lang->get('rtl') ? 'left' : 'right';
    if ($settings->generic_form) {?>
<h4 class="dg-h4 dg-separator"><span><?=JText::_('COM_DATSOGALLERY_GENERIC_DATA');?></span><span class="dgi-help"></span></h4>
<?php if ($settings->generic_form_msg) {?>
<div class="dg-message-box">
   <p><?=JText::_('COM_DATSOGALLERY_GENERIC_DATA_HINT');?></p>
</div>
<?php
  }
if ($settings->generic_form_category) {?>
<section style="margin:0">
   <div id="generic-catid" class="select">
      <div class="dg-icon-<?=$icon_dir;?>"></div>
      <?=dg::getOptions('', 'gcatid', 'id="gcatid" onchange="userCat(this.value);"');?>
      <i></i>
   </div>
</section>
<section id="usercat">
   <div id="nameerr" style="display:none" class="dg-alert dg-alert-danger">
      <p></p>
   </div>
   <div class="input">
      <i class="dg-icon-<?=$icon_dir;?> dgi-info"></i>
      <input placeholder="<?=JText::_('COM_DATSOGALLERY_CATEGORY_NAME');?>" type="text" id="title" name="title" />
      <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_CATEGORY_NAME_HINT');?></b>
   </div>
   <div class="textarea textarea-expandable" style="margin-top: 10px;">
      <i class="dg-icon-<?=$icon_dir;?> dgi-info"></i>
      <textarea placeholder="<?=JText::_('COM_DATSOGALLERY_CATEGORY_DESCRIPTION');?>" cols="35" rows="4" id="description" name="description"></textarea>
      <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_CATEGORY_DESCRIPTION_HINT');?></b>
   </div>
   <?php if (JLanguageMultilang::isEnabled() && !dg::falang_involved()) {?>
   <div class="select" style="margin: 10px 0;">
     <div class="dg-icon-<?=$icon_dir;?>"></div>
     <select id="category-language" name="category-language">
        <option value="*"><?=JText::_('JFIELD_LANGUAGE_LABEL');?> - <?=JText::_('JALL');?></option>
        <?=JHtml::_('select.options', $languages, 'tag', 'name', '*');?>
     </select>
     <i></i>
   </div>
   <?php }?>
   <div style="margin: 10px 0;">
     <button id="create_dg_btn" class="btn" style="margin-top:0;" type="button"><?=JText::_('COM_DATSOGALLERY_CREATE');?></button>
     <button id="cancel_dg_btn" class="btn" style="margin-top:0;margin-left:5px;" type="reset"><?=JText::_('COM_DATSOGALLERY_CANCEL');?></button>
   </div>
   <div style="clear:both"></div>
</section>
  <div class="dg-loading">
    <div class="dg-loading-wheel"></div>
    <div class="wait-msg">
      <?= JText::_('COM_DATSOGALLERY_LOCALIZATION_PROCESS_WAIT_MSG') ?>
    </div>
  </div>
<div style="clear:both"></div>
<?php
echo '<div id="to-hide">';
  }
        $cols = $settings->generic_form_title + $settings->generic_form_author + $settings->generic_form_author_url;
        $col  = 12 / $cols;
        if ($cols > 0) {
        ?>
<section>
   <div class="dg-row">
      <?php if ($settings->generic_form_title) {?>
      <div class="dg-col dg-col-<?=$col;?>">
         <div class="input">
            <i class="dg-icon-<?=$icon_dir;?> dgi-image"></i>
            <input
               type="text"
               name="generic-title"
               id="generic_title"
               placeholder="<?=JText::_('COM_DATSOGALLERY_GENERIC_IMAGE_TITLE');?>">
            <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_GENERIC_IMAGE_TITLE_HINT');?></b>
         </div>
      </div>
      <?php
        }
              if ($settings->generic_form_author) {?>
      <div class="dg-col dg-col-<?=$col;?>">
         <div class="input">
            <i class="dg-icon-<?=$icon_dir;?> dgi-user"></i>
            <input
               type="text"
               placeholder="<?=JText::_('COM_DATSOGALLERY_GENERIC_IMAGE_AUTHOR_PLACEHOLDER');?>"
               name="generic-author"
               >
            <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_GENERIC_IMAGE_AUTHOR_HINT');?></b>
         </div>
      </div>
      <?php
        }
              if ($settings->generic_form_author_url) {?>
      <div class="dg-col dg-col-<?=$col;?>">
         <div class="input">
            <i class="dg-icon-<?=$icon_dir;?> dgi-link"></i>
            <input
               type="text"
               placeholder="<?=JText::_('COM_DATSOGALLERY_GENERIC_IMAGE_AUTHOR_URL_PLACEHOLDER');?>"
               name="generic-authorurl"
               >
            <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_GENERIC_IMAGE_AUTHOR_URL_HINT');?></b>
         </div>
      </div>
      <?php }?>
   </div>
</section>
<?php
  }
      if ($settings->allow_geotagging && $settings->generic_form_geo) {?>
<section>
   <div class="input">
      <i class="dg-icon-<?=$icon_dir;?> dgi-add-location"></i>
      <input id="geocomplete" type="text" placeholder="<?=JText::_('COM_DATSOGALLERY_GENERIC_GEO');?>" />
      <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_GENERIC_GEO_HINT');?></b>
   </div>
   <div style="margin:10px 0">
      <div class="map_canvas"></div>
   </div>
   <input name="generic-lat" id="generic-lat" type="hidden" />
   <input name="generic-lng" id="generic-lng" type="hidden" />
</section>
<?php
  }
      if ($settings->allow_tags && $settings->generic_form_tags) {?>
<section>
   <div class="input tagsarea">
   <i class="dg-icon-<?=$icon_dir;?> dgi-tag"></i>
   <input class="tags" id="generic-tags" type="text" name="generic-tag">
   </div>
</section>
<?php
  }
      if ($settings->generic_form_description) {?>
<section>
   <div class="textarea textarea-expandable">
   <i class="dg-icon-<?=$icon_dir;?> dgi-image-description"></i>
   <textarea id="generic-description" name="generic-description" rows="4" placeholder="<?=JText::_('COM_DATSOGALLERY_GENERIC_IMAGE_DESCRIPTION_PLACEHOLDER');?>"></textarea>
   <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_GENERIC_IMAGE_DESCRIPTION_HINT');?></b>
   </div>
</section>
<?php
  }
      if ($settings->generic_form_language && JLanguageMultilang::isEnabled() && !dg::falang_involved()) {?>
<section>
    <div class="select">
     <div class="dg-icon-<?=$icon_dir;?>"></div>
     <select id="generic-language" name="generic-language">
        <option value="*"><?=JText::_('COM_DATSOGALLERY_GENERIC_LANGUAGE');?></option>
        <?=JHtml::_('select.options', $languages, 'tag', 'name', '*');?>
     </select>
     <i></i>
  </div>
</section>
<?php
  }
      if ($settings->generic_form_apply_all) {?>
<section>
    <div class="select">
       <div class="dg-icon-<?=$icon_dir;?>"></div>
       <select id="generic-all" name="generic-all">
          <option value="0" selected="selected"><?=JText::_('COM_DATSOGALLERY_GENERIC_DATA_TO_ALL');?></option>
          <option value="1"><?=JText::_('JYES');?></option>
       </select>
       <i></i>
    </div>
</section>
<?php }?>

<h4 class="dg-h4 dg-separator"><span><?=JText::_('COM_DATSOGALLERY_INDIVIDUAL_DATA');?></span><span class="dgi-help"></span></h4>
<?php if ($settings->individual_form_msg) {?>
<div class="dg-message-box">
   <p><?=JText::_('COM_DATSOGALLERY_INDIVIDUAL_DATA_HINT');?></p>
</div>
<?php
  }
      }
    ?>
<script>
jQuery(function($){
  $('.dg-select select').chosen();
  $("#usercat").hide();

  $('.toggle input:checkbox').each(function(){
    $(this).click(function(){
      if ($(this).val() == '1') {
        $(this).prop('checked', false);
        $(this).val('0');
      } else {
        $(this).prop('checked', true);
        $(this).val('1');
      }
    });
  });

  $(document).on('click', '#cancel_dg_btn', function () {
    $('#generic-catid select').chosen('destroy');
    $('#generic-catid select').prop("selectedIndex", 0);
    $('#generic-catid select').chosen();
    $('#usercat').hide();
    $('#to-hide,.actions').show();
  });

  $(document).on('click', '#create_dg_btn', function() {
   $("#usercat").next().fadeIn();
   $("#catname").show();
   $.post(ajax_url, {
      task: 'category.check',
      title: $('#title').val(),
      description: $('#description').val(),
      categorylanguage: $('#category-language').val()
   }).done(function(data) {
      $("#usercat").next().fadeOut();
      if (data == "maxcat") {
        $("#ucattip").hide();
        $("#nameerr").show();
        $('#nameerr p').text("<?=JText::_('COM_DATSOGALLERY_MAX_CAT_EXHAUSTED');?>");
          $("#nameerr").delay(6000).fadeOut("slow");
          $("#ucattip").delay(6800).fadeIn();
        return false;
      } else {
        if (data == "exist") {
          $("#ucattip").hide();
          $("#nameerr").show();
          $('#nameerr p').text("<?=JText::_('COM_DATSOGALLERY_CATEGORY_ALREADY_EXIST');?>");
            $("#nameerr").delay(6000).fadeOut("slow");
            $("#ucattip").delay(6800).fadeIn();
          return false;
        } else if (data == "nocat") {
          $("#ucattip").hide();
          $("#nameerr").show();
          $('#nameerr p').text("<?=JText::_('COM_DATSOGALLERY_CATEGORY_CAN_NOT_BE_EMPTY');?>");
            $("#nameerr").delay(6000).fadeOut("slow");
            $("#ucattip").delay(6800).fadeIn();
          return false;
        } else {
          $("#title").val("");
          $("#description").val("");
          $("#category-language").val("*");
          $("#usercat").hide();
          $("#gcatid").hide();
          $("#generic-catid").html(data);
          $('#generic-catid select').chosen('destroy');
          $('#generic-catid select').chosen();
          $("#stepthree").delay(500).fadeIn().slideDown(300);
          $("#disable_buttons").show();
          $("#to-hide,.actions").show();
        }
      }
   });
   return false;
  });
  var options = {
    map: ".map_canvas",
    mapOptions: {
      scrollwheel: true,
      zoom: 10
    },
    markerOptions: {
      draggable: true
    }
  };
  $("#geocomplete").geocomplete(options).on("geocode:result", function(event, result){
    $("input#generic-lat").val(result.geometry.location.lat());
    $("input#generic-lng").val(result.geometry.location.lng());
  }).on("geocode:dragged", function(event, latLng){
    $("input#generic-lat").val(latLng.lat());
    $("input#generic-lng").val(latLng.lng());
    $("#geocomplete").geocomplete("find", latLng.toString());
  })
  if ($("input#generic-lat").val('') && $("input#generic-lng").val('')) {
    $('.map_canvas').addClass('fb');
  } else {
    $('.map_canvas').removeClass('fb');
  }
  $('#generic-tags').tagsInput({
      'defaultText': '<?=JText::_("COM_DATSOGALLERY_ADD_TAG");?>',
      'removeWithBackspace': true,
      'minChars': <?=$settings->min_tag_chars;?>
  });
});
function userCat(b) {
  var a = document.getElementById("usercat");
  a.style.display = b == "usercat" ? "block" : "none";
  if (jQuery("#usercat").is(":visible")) {
    jQuery("#to-hide,.actions").hide();
  } else {
    jQuery("#to-hide,.actions").show();
  }
  if (b != "" && b != "usercat") {
    jQuery("select#gcatid").val(b);
    jQuery("#disable_buttons").show();
  }
  return false
}
function b64_to_utf8(str) {
    return decodeURIComponent(Array.prototype.map.call(atob(str), function(c) {
        return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2)
    }).join('')).replace(/_/g, ' ')
}
function capitalizeFirstLetter(string) {
  return string.charAt(0).toUpperCase() + string.slice(1);
}
</script>
   <?php
     array_multisort(array_map('base64_decode', ($files = JFolder::files(JPATH_SITE . $directory))), SORT_ASC, $files);
         $i = 0;
         foreach ($files as $file) {
           $file_parts  = explode('.', $file);
           $ext         = strtolower(array_pop($file_parts));
           $title       = implode('.', $file_parts);
           $title       = htmlspecialchars($title);
           $title       = str_replace('_', ' ', $title);
           $info        = Iptc::info(JPATH_SITE . $directory . $file);
           $palette     = array();
           $title       = (isset($info['title']) && !empty($info['title'])) ? $info['title'] : $title;
           $description = (isset($info['description']) && !empty($info['description']) && $info['description'] != null) ? $info['description'] : '';
           $imgauthor   = (isset($info['author']) && !empty($info['author'])) ? $info['author'] : '';
           $authorurl   = (isset($info['url']) && !empty($info['url'])) ? $info['url'] : '';
           $tag         = (isset($info['tag']) && !empty($info['tag'])) ? $info['tag'] : '';
           if (in_array($ext, array('jpg', 'jpeg')) && is_callable('exif_read_data')) {
             $imgmeta = JPATH_SITE . $directory . $file;
             $exif    = @exif_read_data($imgmeta);
             $lat     = (!empty($exif['GPSLatitude'])) ? dg::geo_single_gps($exif["GPSLatitude"], $exif['GPSLatitudeRef']) : '';
             $lng     = (!empty($exif['GPSLongitude'])) ? dg::geo_single_gps($exif["GPSLongitude"], $exif['GPSLongitudeRef']) : '';
             if ($lat && $lng) {
               echo '<input name="lat[' . $i . ']" id="lat" type="hidden" value="' . $lat . '" />';
               echo '<input name="lng[' . $i . ']" id="lng" type="hidden" value="' . $lng . '" />';
             }
           }
         ?>
   <script>
      jQuery(document).ready(function($) {
          $('#image-tags<?=$i;?>').tagsInput({
              'defaultText': '<?=JText::_("COM_DATSOGALLERY_ADD_TAG");?>',
              'removeWithBackspace': true,
              'minChars': <?=$settings->min_tag_chars;?>
          });
          <?php if (!isset($info['title'])) { ?>
          var dtitle = $("#title<?=$i;?>").val();
          $("#title<?=$i;?>").val(capitalizeFirstLetter(decodeURI(b64_to_utf8(dtitle))));
          <?php } ?>
      });
   </script>
   <section>
   <div class="dg-row">
   <section class="dg-col dg-col-2 dg-preview" style="margin-bottom:10px;">
      <?php if (!is_ani(JPATH_SITE . $directory . $file)) {?>
      <img src="<?=resize($file, 400, 400, 1, '1:1', 0, 0, $directory, 60);?>" class="dg-img"  alt="" />
      <?php
        if ($settings->extract_color) {
                $palette = dg::palette(JPATH_SITE . $directory . $file, $settings->color_number, 10);
              }
            } else {?>
      <img src="<?=$tmpurl . $file;?>" class="dg-img"  alt="" />
      <?php }
            if ($settings->extract_color && count($palette)) {?>
      <div class="dg-image-colors">
        <?php foreach ($palette as $hex) {?>
          <div style="width:calc(100% / <?=count($palette);?>);background-color:<?='#' . $hex;?>" title="<?='#' . $hex;?>"></div>
          <input type="hidden" id="hex<?=$i;?>" name="hex[<?=$i;?>][]" value="<?=$hex;?>" />
        <?php }?>
        </div>
        <?php }?>
   </section>
   <section class="dg-col dg-col-10">
      <div class="input" style="margin-bottom:10px">
         <i class="dg-icon-<?=$icon_dir;?> dgi-image"></i>
         <input
            id="title<?=$i;?>"
            type="text"
            name="title[<?=$i;?>]"
            onblur="if(jQuery.trim(this.value)=='') this.value='<?=$title;?>';"
            onfocus="if(this.value=='<?=$title;?>') this.value='';"
            value="<?=$title;?>"
            required>
         <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_IMAGE_TITLE_HINT');?></b>
      </div>
      <div class="select">
          <div class="dg-icon-<?=$icon_dir;?>"></div>
          <?=dg::getOptions('', 'catid[' . $i . ']', 'class="catid"', 1);?>
          <i></i>
      </div>
      <?php if ($settings->individual_form_language && JLanguageMultilang::isEnabled() && !dg::falang_involved()) {?>
      <div class="select">
         <div class="dg-icon-<?=$icon_dir;?>"></div>
          <select id="language[<?=$i;?>]" name="language[<?=$i;?>]">
            <option value="*"><?=JText::_('JFIELD_LANGUAGE_LABEL');?> - <?=JText::_('JALL');?></option>
            <?=JHtml::_('select.options', $languages, 'tag', 'name', '*');?>
          </select>
          <i></i>
      </div>
      <?php }?>
<?php if ($settings->individual_form_author) {?>
      <div class="input" style="margin-bottom:10px">
         <i class="dg-icon-<?=$icon_dir;?> dgi-user"></i>
         <input
            type="text"
            placeholder="<?=JText::_('COM_DATSOGALLERY_IMAGE_AUTHOR_PLACEHOLDER');?>"
            name="author[<?=$i;?>]"
            value="<?=$imgauthor;?>"
            >
         <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_IMAGE_AUTHOR_HINT');?></b>
      </div>
      <?php }?>
<?php if ($settings->individual_form_author_url) {?>
      <div class="input" style="margin-bottom:10px">
         <i class="dg-icon-<?=$icon_dir;?> dgi-link"></i>
         <input
            type="text"
            placeholder="<?=JText::_('COM_DATSOGALLERY_IMAGE_AUTHOR_URL_PLACEHOLDER');?>"
            name="authorurl[<?=$i;?>]"
            value="<?= $authorurl ?>"
            >
         <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_IMAGE_AUTHOR_URL_HINT');?></b>
      </div>
      <?php }?>
<?php if ($settings->allow_tags && $settings->individual_form_tags) {?>
      <div class="input tagsarea hint--top-right" data-hint="<?=JText::_('COM_DATSOGALLERY_ADD_TAG_HINT');?>">
         <i class="dg-icon-<?=$icon_dir;?> dgi-tag hint--top-right"></i>
         <input
            id="image-tags<?=$i;?>"
            class="tags"
            type="text"
            name="image-tags[<?=$i;?>]"
            value="<?=$tag;?>"
            >
      </div>
      <?php }?>
<?php if ($settings->individual_form_description) {?>
      <div class="textarea textarea-expandable">
         <i class="dg-icon-<?=$icon_dir;?> dgi-image-description"></i>
         <textarea id="description[<?=$i;?>]" name="description[<?=$i;?>]" rows="4" placeholder="<?=JText::_('COM_DATSOGALLERY_IMAGE_DESCRIPTION_PLACEHOLDER');?>"><?=$description;?></textarea>
         <b class="tooltip tooltip-top-<?=$tip_align;?>"><?=JText::_('COM_DATSOGALLERY_IMAGE_DESCRIPTION_HINT');?></b>
      </div>
      <?php }?>
   </section>
   </div>
   </section>
   <?php
     $i++;
         }
echo '</div>';
         exit();
       }

       public function dgImgId($catid, $imgext)
       {
         return substr(strtoupper(md5(uniqid(time()))), 5, 12) . '-' . $catid . '.' . strtolower($imgext);
       }
     }
