<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2019 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
require_once JPATH_COMPONENT . '/controller.php';

class DatsogalleryControllerMember extends DatsogalleryController
{

  public function avatarupload()
  {
    require_once JPATH_COMPONENT . '/helpers/uploader.php';
    $app         = JFactory::getApplication();
    $user        = JFactory::getUser();
    $avatars_dir = JPATH_SITE . '/images/dg_avatars';
    $settings    = array(
      'uploadFolder' => $avatars_dir,
      'maxFileSize' => dg::maxuploadsize(),
      'extension' => ['png', 'jpg', 'jpeg', 'gif'],
      'maxFolderFiles' => 100,
      'maxFolderSize' => 0,
      'returnLocation' => false,
      'rename' => true,
      'overwrite' => true,
      'avatarFilename' => true,
      'resizeCrop' => true,
      'changeFile' => true
    );
    $uploader = new RealTimeUpload();
    $uploader->init($settings);
    $app->close();
  }

  public function updateavatar()
  {
    $app    = JFactory::getApplication();
    $user   = JFactory::getUser();
    $avatar = $user->id . '-avatar';
    $file   = dg::resolve($avatar);
    if ($file) {
      echo Juri::root(true) . '/images/dg_avatars/' . $file;
    }
    $app->close();
  }

  public function save()
  {
    JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
    $app        = JFactory::getApplication();
    $profile_id = $app->input->getInt('id');
    $user       = JFactory::getUser();
    if ($user->id && ($user->id == $profile_id)) {
      $data   = $app->input->post->getArray();
      $model  = $this->getModel('Member', 'DatsogalleryModel');
      $return = $model->save($data);
      if ($return === false) {
        $msg = JText::sprintf('Save failed', $model->getError());
      } else {
        $msg = JText::_('COM_DATSOGALLERY_PROFILE_SAVED');
      }
    } else {
      $msg = JText::_('JERROR_ALERTNOAUTHOR');
    }
    $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=member&id=' . $profile_id . dg::menuid('member'), false), $msg);
  }

  public function cancel()
  {
    $app = JFactory::getApplication();
    $id  = $app->input->getInt('id');
    $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=member&id=' . $id . dg::itemId(), false));
    return true;
  }

  public function notify()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $user       = JFactory::getUser();
      $profile_id = $app->input->getInt('id');
      if ($user->id && ($user->id == $profile_id)) {
        $data   = $app->input->getInt('notify');
        $model  = $this->getModel('Member', 'DatsogalleryModel');
        $return = $model->notify($data);
        if ($return === false) {
          $msg = JText::sprintf('Save failed', $model->getError());
        } else {
          $msg = $data;
        }
      } else {
        $msg = JText::_('JERROR_ALERTNOAUTHOR');
      }
      echo $msg;
    } else {
      $this->setMessage(JText::_('JINVALID_TOKEN'), 'error');
    }
    $app->close();
  }

  public function notifysingle()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $user       = JFactory::getUser();
      $profile_id = $app->input->getInt('id');
      if ($user->id && ($user->id == $profile_id)) {
        $image_id = $app->input->getInt('imageid');
        $state    = $app->input->getInt('notify');
        $model    = $this->getModel('Member', 'DatsogalleryModel');
        $return   = $model->notifysingle($image_id, $state);
        if ($return === false) {
          $msg = JText::sprintf('Save failed', $model->getError());
        } else {
          $msg = $state;
        }
      } else {
        $msg = JText::_('JERROR_ALERTNOAUTHOR');
      }
      echo $msg;
    } else {
      $this->setMessage(JText::_('JINVALID_TOKEN'), 'error');
    }
    $app->close();
  }
}
