<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

require_once JPATH_COMPONENT . '/controller.php';

class DatsogalleryControllerCategory extends DatsogalleryController
{

  public function check()
  {
    $model  = $this->getModel('Category', 'DatsogalleryModel');
    $return = $model->check_category();
    if ($return) {
      echo $return;
    }
    JFactory::getApplication()->close();
  }

  public function edit()
  {
    $app        = JFactory::getApplication();
    $previousId = (int) $app->getUserState('com_datsogallery.edit.category.id');
    $editId     = $app->input->getInt('id', null, 'array');
    $app->setUserState('com_datsogallery.edit.category.id', $editId);
    $model = $this->getModel('Category', 'DatsogalleryModel');
    if ($editId) {
      $model->checkout($editId);
    }
    if ($previousId) {
      $model->checkin($previousId);
    }
    $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=categoryform&layout=edit', false));
  }

  public function save()
  {
    JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
    $app   = JFactory::getApplication();
    $model = $this->getModel('Category', 'DatsogalleryModel');
    $data  = $app->input->get('jform', array(), 'array');
    $form  = $model->getForm();
    if (!$form) {
      $app->enqueueMessage($model->getError(), 'error');
      return false;
    }
    $data = $model->validate($form, $data);
    if ($data === false) {
      $errors = $model->getErrors();
      for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
        if ($errors[$i] instanceof Exception) {
          $app->enqueueMessage($errors[$i]->getMessage(), 'warning');
        } else {
          $app->enqueueMessage($errors[$i], 'warning');
        }
      }
      $app->setUserState('com_datsogallery.edit.category.data', $app->input->get('jform'), array());
      $id = (int) $app->getUserState('com_datsogallery.edit.category.id');
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=category&layout=edit&id=' . $id, false));
      return false;
    }
    $return = $model->save($data);
    if ($return === false) {
      $app->setUserState('com_datsogallery.edit.category.data', $data);
      $id = (int) $app->getUserState('com_datsogallery.edit.category.id');
      $this->setMessage(JText::sprintf('Save failed', $model->getError()), 'warning');
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=category&layout=edit&id=' . $id, false));
      return false;
    }
    if ($return) {
      $model->checkin($return);
    }
    $app->setUserState('com_datsogallery.edit.category.id', null);
    $this->setMessage(JText::_('COM_DATSOGALLERY_ITEM_SAVED_SUCCESSFULLY'));
    $menu = JSite::getMenu();
    $item = $menu->getActive();
    $this->setRedirect(JRoute::_($item->link, false));
    $app->setUserState('com_datsogallery.edit.category.data', null);
  }

  public function cancel()
  {
    $menu = JSite::getMenu();
    $item = $menu->getActive();
    $this->setRedirect(JRoute::_($item->link, false));
  }

  public function remove()
  {
    JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
    $app   = JFactory::getApplication();
    $model = $this->getModel('Category', 'DatsogalleryModel');
    $data  = JFactory::getApplication()->input->get('jform', array(), 'array');
    $form  = $model->getForm();
    if (!$form) {
      $app->enqueueMessage($model->getError(), 'error');
      return false;
    }
    $data = $model->validate($form, $data);
    if ($data === false) {
      $errors = $model->getErrors();
      for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
        if ($errors[$i] instanceof Exception) {
          $app->enqueueMessage($errors[$i]->getMessage(), 'warning');
        } else {
          $app->enqueueMessage($errors[$i], 'warning');
        }
      }
      $app->setUserState('com_datsogallery.edit.category.data', $data);
      $id = (int) $app->getUserState('com_datsogallery.edit.category.id');
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=category&layout=edit&id=' . $id, false));
      return false;
    }
    $return = $model->delete($data);
    if ($return === false) {
      $app->setUserState('com_datsogallery.edit.category.data', $data);
      $id = (int) $app->getUserState('com_datsogallery.edit.category.id');
      $this->setMessage(JText::sprintf('Delete failed', $model->getError()), 'warning');
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=category&layout=edit&id=' . $id, false));
      return false;
    }
    if ($return) {
      $model->checkin($return);
    }
    $app->setUserState('com_datsogallery.edit.category.id', null);
    $this->setMessage(JText::_('COM_DATSOGALLERY_ITEM_DELETED_SUCCESSFULLY'));
    $menu = JSite::getMenu();
    $item = $menu->getActive();
    $this->setRedirect(JRoute::_($item->link, false));
    $app->setUserState('com_datsogallery.edit.category.data', null);
  }

  public function fbcontent()
  {
    $app        = JFactory::getApplication();
    /*if (JSession::checkToken('get')) {*/
      $id         = $app->input->getInt('id');
      echo dg::dgslider($id);
    /*} else {
      jexit(JText::_('JINVALID_TOKEN'));
    }*/
    $app->close();
  }
}
