<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.controller');
require_once JPATH_COMPONENT_ADMINISTRATOR . '/images.php';

class DatsogalleryController extends JControllerLegacy
{

  public function __construct()
  {
    parent::__construct();
    JHtml::_('jquery.framework');
    JHtml::_('bootstrap.framework', false);

    $doc    = JFactory::getDocument();
    $app    = JFactory::getApplication();
    $menu   = $app->getMenu();
    $settings = dg::getConfig();
    $lang   = JFactory::getLanguage();
    $is_rtl = $lang->get('rtl');
    $rtl    = $is_rtl ? '-rtl' : '';
    $jslang = JLanguageMultilang::isEnabled() ? '"&lang=' . substr($lang->getTag(), 0, 2) . '"' : '""';
    $options = array();
    $attributes = array();
    $doc->addStyleSheet(JUri::root(true) . '/components/com_datsogallery/assets/css/jquery.fancybox.min.css', $options);
    $doc->addStyleSheet(JUri::root(true) . '/components/com_datsogallery/assets/css/hints.css', $options);
    $doc->addStyleSheet(JUri::root(true) . '/components/com_datsogallery/assets/css/dg-ui-new.css', $options);
    $doc->addStyleSheet(JUri::root(true) . '/components/com_datsogallery/assets/css/icons.css', $options);
    $doc->addStyleSheet(JUri::root(true) . '/components/com_datsogallery/assets/css/animations.css', $options);
    if (JFile::exists(JPATH_COMPONENT.'/assets/css/custom.css')) {
      $doc->addStyleSheet(JUri::root(true).'/components/com_datsogallery/assets/css/custom.css', $options);
    }
    $doc->addScript(JUri::root(true) . '/components/com_datsogallery/assets/js/jquery.plugins.js', $options);
    $doc->addScript(Juri::root(true) . '/components/com_datsogallery/assets/js/macy.js', $options, $attributes);
    $doc->addScript(Juri::root(true) . '/components/com_datsogallery/assets/js/datsogallery.grid.js', $options, $attributes);
    $doc->addScript(JUri::root(true) . '/components/com_datsogallery/assets/js/datsogallery.js', $options, $attributes);
    $doc->addScript(Juri::root(true) . '/components/com_datsogallery/assets/js/jquery.fancybox.min.js', $options, $attributes);
    $doc->addScriptDeclaration('var siteurl = "' . JUri::base() . '";');
    $doc->addScriptDeclaration('var is_rtl = ' . ($is_rtl ? 'false' : 'true') . ';');
    $doc->addScriptDeclaration('var jslang = ' . $jslang . ';');
    $doc->addScriptDeclaration('var token = "&' . JSession::getFormToken() . '=1"');
    $doc->addScriptDeclaration('var ajax_url = "' . JUri::base() . 'index.php?option=com_datsogallery" + jslang + token;');
    $task = $app->input->getCmd('task', '');
    $view = $app->input->getCmd('view', '');
    dg::jslang('datsogallery.js');
    dg::jslang('datsogallery.grid.js');
  }

}
