/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  2006 - 2020 Andrey Datso
 * @license    <https://www.datso.fr/license.html>
 */
jQuery(function($) {
  var preapp,
    container_breakpoints = $('.dg-grid').data('container-breakpoints'),
    breakpoint_xl = $('.dg-grid').data('breakpoint-xl'),
    breakpoint_l = $('.dg-grid').data('breakpoint-l'),
    breakpoint_m = $('.dg-grid').data('breakpoint-m'),
    breakpoint_s = $('.dg-grid').data('breakpoint-s'),
    margin_y = $('.dg-grid').data('margin-y'),
    margin_x = $('.dg-grid').data('margin-x'),
    wh = $(window).innerHeight();
  if ($('.dg-grid')[0]) {
    var macygrid = new Macy({
      container: '.dg-grid',
            trueOrder: false,
            waitForImages: false,
            useOwnImageLoader: false,
            debug: true,
            mobileFirst: true,
            columns: 1,
      margin: {
        y: margin_y,
        x: margin_x,
      },
      useContainerForBreakpoints: container_breakpoints,
      breakAt: {
        1600: breakpoint_xl,
        1200: breakpoint_l,
        960: breakpoint_m,
        640: breakpoint_s
      },
    });
  }
  if (!iasdestroy) {
    var ias = $.ias({
      container: '.dg-grid',
      item: '.dg-grid-item',
      pagination: '.dg-pagination',
      next: 'a.pagenav:has(span.icon-next), .pagination-next a',
      delay: 1500,
      negativeMargin: wh
    }).extension(new IASTriggerExtension({
      triggerContainer: '.ias-conteiner',
      offset: (dgoffset == 0 || dgoffset == 1) ? false : dgoffset,
      textPrev: Joomla.JText._("COM_DATSOGALLERY_IAS_TRIGGER_PREV"),
      htmlPrev: '<div class="ias-trigger ias-trigger-prev"><a class="dgi-arrow-prev" title="{text}"></a></div>',
      text: Joomla.JText._("COM_DATSOGALLERY_IAS_TRIGGER_NEXT"),
      html: '<div class="ias-trigger ias-trigger-next"><a class="dgi-arrow-next" title="{text}"></a></div>'
    })).extension(new IASHistoryExtension({
      prev: 'a.pagenav:has(span.icon-back), .pagination-prev a'
    })).extension(new IASNoneLeftExtension({
      noneLeftContainer: '.ias-conteiner',
      html: '<div class="ias-noneleft"><a class="dgi-arrow-next" title="' + Joomla.JText._("COM_DATSOGALLERY_IAS_NONELEFT") + ' ' + Joomla.JText._("COM_DATSOGALLERY_IAS_SCROLL_TOP") + '"></a></div>'
    })).extension(new IASPagingExtension()).on('render', function(items) {
      $(items).addClass('scale-up-center');
      macygrid.runOnImageLoad(function() {
        macygrid.recalculate(true,true);
      });
      $(items).find('.anigif')
        .each(function() {
          var t = $(this),
            e = t.attr('src'),
            i = t.data('gif-src');
          t.hover(function() {
            t.parent()
              .prev()
              .show(), t.attr('src', i)
              .on('load', function() {
                t.parent()
                  .prev()
                  .hide()
              })
          }, function() {
            t.attr('src', e)
          })
        });
    }).on('rendered', function(items) {}).on('next', function(url) {
      preapp = '.ias-conteiner';
    }).on('prev', function(url) {
      preapp = '.ias-conteiner';
    }).on('noneLeft', function() {
      preapp = '.ias-conteiner';
    }).extension(new IASSpinnerExtension({
      spinnerContainer: '.ias-conteiner',
      html: '<div class="ias-spinner"><span class="dgi-spin"></span></div>'
    }));
  }
  $(document).on('click', '.deleteajax', function() {
    if (confirm(Joomla.JText._("COM_DATSOGALLERY_DELETE_MESSAGE"))) {
      var item = $(this).closest('.dg-grid-item'),
        image_id = item.attr('id');
      $.ajax({
        url: ajax_url,
        data: {
          task: 'image.deleteajax',
          id: image_id
        },
        dataType: 'json',
        type: 'post',
        success: function(data) {
          if (data.status == 'success') {
            item.addClass('slit-out-vertical');
            setTimeout(function() {
              item.remove();
              macygrid.recalculate(true,true);
            }, 500);
          } else {
            alert(data.message);
          }
        }
      });
    }
  });
  $(document)
    .on('click', '.dg-edit-image', function(e) {
      var t = $(this),
        i = t.attr('id'),
        c = t.find('i'),
        a = c.attr('class');
      if (t.data('clicked')) {
        e.preventDefault();
        e.stopPropagation();
      } else {
        t.data('clicked', true);
        c.toggleClass('dgi-spin ' + a);
        $.ajax({
          url: ajax_url,
          data: {
            task: 'image.edit',
            id: i
          },
          type: 'post',
          dataType: 'json',
          success: function(data) {
            window.location.href = data.redirect;

          }
        });
        t.removeData('clicked')
      }
    });
  $(document).on('click', '.ias-noneleft a,.dg-totop', function(e) {
    $('html, body').animate({
      scrollTop: 0
    }, 800);
    e.preventDefault();
  });
});