<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class plgInstallerDatsogallery extends JPlugin
{

  public function onInstallerBeforePackageDownload(&$url, &$headers)
  {
    $uri = JUri::getInstance($url);
    if ($uri->getHost() == 'www.datso.fr') {
      if (!file_exists(JPATH_ADMINISTRATOR . '/components/com_datsogallery/helpers/datsogallery.php')) {
        return;
      }
      JFactory::getLanguage()->load('plg_installer_datsogallery');
      $license = $this->getlic();
      if (!strlen($license)) {
        JFactory::getApplication()->enqueueMessage(JText::_('PLG_INSTALLER_DATSOGALLERY_MISSING_UPDATE_CODE'), 'warning');
        return;
      }
      if (strlen($license) != 20) {
        JFactory::getApplication()->enqueueMessage(JText::_('PLG_INSTALLER_DATSOGALLERY_INCORRECT_CODE'), 'warning');
        return;
      }
      $uri->setVar('domain', JUri::getInstance()->getHost());
      $uri->setVar('lic', $license);
      $url = $uri->toString();
    }
    return true;
  }

  public static function getlic()
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('value')
      ->from('#__datsogallery_settings')
      ->where('name = ' . $db->q('license'));
    $db->setQuery($query);
    return $db->loadResult();
  }
}
