<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

class DatsogalleryViewSettings extends JViewLegacy {

  public function display($tpl = null) {
    $app = JFactory::getApplication();
    if (count($errors = $this->get('Errors'))) {
      $app->enqueueMessage(implode("\n", $errors), 'error');
      return false;
    }
    $user = JFactory::getUser();
    if (!$user->authorise('core.admin', 'com_datsogallery')) {
      $app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'error');
      $app->redirect(JRoute::_('index.php?option=com_datsogallery', false));
    }
    $this->form = $this->get('Form');
    $this->phoca = $this->get('Phoca');
    $this->data = (array) dg::getConfig();
    dg::addSubmenu('settings');
    $this->addToolbar();
    $this->sidebar = JHtmlSidebar::render();
    parent::display($tpl);
  }

  protected function addToolbar() {
    JToolBarHelper::title(JText::_('COM_DATSOGALLERY_TITLE_SETTINGS'), 'settings.png');
    JToolBarHelper::apply('settings.apply');
    JToolBarHelper::save('settings.save');
    JToolBarHelper::cancel('settings.cancel');
  }

}