<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
require_once (JPATH_COMPONENT.'/images.php');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('formbehavior.chosen', 'select');
$user = JFactory::getUser();
$userId = $user->get('id');
$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$saveOrder = $listOrder == 'a.ordering';
if ($saveOrder) {
  $saveOrderingUrl = 'index.php?option=com_datsogallery&task=images.saveOrderAjax&tmpl=component';
  JHtml::_('sortablelist.sortable', 'imageList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}
?>
<form action="<?php echo JRoute::_('index.php?option=com_datsogallery&view=images'); ?>" method="post" name="adminForm" id="adminForm" class="dg-style">
  <?php if (!empty($this->sidebar)) : ?>
  <div id="j-sidebar-container" class="col col-2">
    <div class="filling"><?php echo $this->sidebar; ?></div>
  </div>
  <div id="j-main-container" class="col col-10">
  <?php else : ?>
  <div id="j-main-container">
    <?php endif; ?>
    <?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
    <?php if (empty($this->items)) : ?>
    <div class="alert alert-no-items">
    <?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
    </div>
	<?php else : ?>
    <table class="table table-striped" id="imageList">
      <thead>
        <tr>
          <th width="1%" class="nowrap center hidden-phone">
    		<?php echo JHtml::_('searchtools.sort', '', 'a.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
    	  </th>
    	  <th width="1%" class="center">
    		<?php echo JHtml::_('grid.checkall'); ?>
    	  </th>
    	  <th width="1%" class="nowrap center">
    		<?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
    	  </th>
          <th class="left" style="padding-left: 48px !important">
            <?php echo JHtml::_('searchtools.sort', 'COM_DATSOGALLERY_IMAGES_TITLE', 'a.title', $listDirn, $listOrder); ?>
          </th>
          <?php if ($this->settings->allow_rating) : ?>
          <th style="width:80px" class="nowrap center hidden-phone">
            <?php echo JText::_('COM_DATSOGALLERY_LAKES'); ?>
          </th>
          <?php endif; ?>
          <th class="center hidden-phone">
            <?php echo JHtml::_('searchtools.sort', 'COM_DATSOGALLERY_IMAGES_HITS', 'a.hits', $listDirn, $listOrder); ?>
          </th>
          <?php if ($this->settings->allow_downloads) : ?>
          <th class="center hidden-phone">
            <?php echo JHtml::_('searchtools.sort', 'COM_DATSOGALLERY_IMAGES_DOWNLOADS', 'a.downloads', $listDirn, $listOrder); ?>
          </th>
          <?php endif; ?>
          <th class="center hidden-phone">
            <?php echo JHtml::_('searchtools.sort', 'COM_DATSOGALLERY_IMAGES_ACCESS', 'a.access', $listDirn, $listOrder); ?>
          </th>
          <th class="left">
            <?php echo JHtml::_('searchtools.sort', 'COM_DATSOGALLERY_UPLOADED_BY', 'a.created_by', $listDirn, $listOrder); ?>
          </th>
          <th class="left hidden-phone">
            <?php echo JHtml::_('searchtools.sort', 'COM_DATSOGALLERY_UPLOADED_ON', 'a.created', $listDirn, $listOrder); ?>
          </th>
          <th class="left hidden-phone">
            <?php echo JHtml::_('searchtools.sort', 'COM_DATSOGALLERY_IMAGES_LANGUAGE', 'a.language', $listDirn, $listOrder); ?>
          </th>
          <?php if (isset($this->items[0]->id)) : ?>
          <th width="1%" class="nowrap center hidden-phone">
            <?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
          </th>
          <?php endif; ?>
        </tr>
      </thead>
      <tfoot>
        <?php
        if (isset($this->items[0])) {
          $colspan = count(get_object_vars($this->items[0]));
        }
        else {
          $colspan = 10;
        }
        ?>
        <tr>
          <td colspan="<?php echo $colspan ?>">
            <?php echo $this->pagination->getListFooter(); ?>
          </td>
        </tr>
      </tfoot>
      <tbody>
        <?php
        foreach ($this->items as $i => $item) :
          $ordering = ($listOrder == 'a.ordering');
          $canCreate = $user->authorise('core.create', 'com_datsogallery');
          $canEdit = $user->authorise('core.edit', 'com_datsogallery');
          $canCheckin = $user->authorise('core.manage', 'com_datsogallery');
          $canChange = $user->authorise('core.edit.state', 'com_datsogallery');
          ?>
        <tr class="row<?php echo $i % 2; ?>" sortable-group-id="<?php echo $item->catid; ?>">
          <td class="order nowrap center hidden-phone">
              <?php
              $iconClass = '';
              if (!$canChange) {
                $iconClass = ' inactive';
              }
              elseif (!$saveOrder) {
                $iconClass = ' inactive tip-top hasTooltip" title="'.JHtml::_('tooltipText', 'JORDERINGDISABLED');
              }
              ?>
            <span class="sortable-handler<?php echo $iconClass ?>">
            <span class="icon-menu" aria-hidden="true"></span>
            </span>
            <?php if ($canChange && $saveOrder) : ?>
            <input type="text" style="display:none" name="order[]" size="5" value="<?php echo $item->ordering; ?>" class="width-20 text-area-order" />
            <?php endif; ?>
          </td>
          <td class="center hidden-phone">
            <label class="checkbox">
            <input id="cb<?php echo $i; ?>" name="cid[]" value="<?php echo $item->id; ?>" onclick="Joomla.isChecked(this.checked);" type="checkbox">
            <i></i>
            </label>
          </td>
          <td class="center">
            <div style="display:flex">
            <?php
                echo JHtml::_('jgrid.published', $item->state, $i, 'images.', $canChange, 'cb', $item->publish_up, $item->publish_down);
                echo JHtml::_('datsogallery.approved', $item->approved, $i, $canChange, 'images');
                echo JHtml::_('datsogallery.featured', $item->featured, $i, $canChange, 'images');
                echo JHtml::_('datsogallery.edit', $item->id, $canChange, 'image');
            ?>
            </div>
          </td>
          <td>
            <div class="zoombox">
              <a href="#" class="dg-image-modal" title="<?php echo JText::_('COM_DATSOGALLERY_OPEN_MODAL'); ?>" data-toggle="modal" data-target="#dg-modal" data-img-url="<?php echo JUri::base(); ?>index.php?option=com_datsogallery&task=image.sbox&catid=<?php echo $item->catid; ?>&id=<?php echo $item->id; ?>">
                <div title="<?php echo JText::_('COM_DATSOGALLERY_OPEN_MODAL'); ?>" class="crop showbox" style="background-image: url('<?php echo resize($item->original, 200, 200, 1, '1:1', 0, $item->catid, '', 65); ?>');"></div>
              </a>
            </div>
            <div class="pull-left">
            <?php
                if ($item->checked_out) :
                  echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'images.', $canCheckin);
                endif;
                if ($item->language == '*') :
                  $language = JText::alt('JALL', 'language');
                else :
                  $language = $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED');
                endif;
                echo $this->escape($item->title);
            ?>
              <div class="dg-title-col">
                <span><i class="dgi-album" title="<?php echo JText::_('JCATEGORY'); ?>"></i><?php echo $this->escape($item->category_title); ?></span>
                <span>&nbsp;&nbsp;<i class="dgi-link" title="<?php echo JText::_('JFIELD_ALIAS_LABEL'); ?>"></i><?php echo $this->escape($item->alias); ?></span>
              </div>
            </div>
          </td>
          <?php
          if ($this->settings->allow_rating) :
          ?>
          <td class="nowrap center hidden-phone td-icon">
            <?php $lcolor = dg::likes($item->id) > 0 ? '#f36b6b' : '#999'; ?>
              <i class="dgi-like" style="color:<?= $lcolor ?>"></i>
              <span class="badge"><?php echo dg::likes($item->id); ?></span>
          </td>
          <?php endif; ?>
          <td class="nowrap center hidden-phone td-icon">
              <?php $hcolor = $item->hits > 0 ? '#4682B4' : '#999'; ?>
              <i class="dgi-visibility" style="color:<?= $hcolor ?>"></i>
              <span class="badge"><?php echo $item->hits; ?></span>
          </td>
          <?php if ($this->settings->allow_downloads) : ?>
          <td class="center hidden-phone td-icon">
            <?php $dcolor = $item->downloads > 0 ? '#F4A460' : '#999'; ?>
            <i class="dgi-download" style="color:<?= $dcolor ?>"></i>
            <span class="badge"><?= $item->downloads; ?></span>
          </td>
          <?php endif; ?>
          <td class="center hidden-phone">
            <?php echo $this->escape($item->access_level); ?>
          </td>
          <td>
            <a class="hasTooltip" href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id='.(int) $item->created_by); ?>" title="<?php echo JText::_('JAUTHOR'); ?>">
            <?php echo $this->escape($item->author_name); ?></a>
          </td>
          <td class="hidden-phone" style="font-size: 10px; font-weight: 500;line-height: 15px;">
            <?php echo JHtml::_('date', dg::timezone($item->created), JText::_('COM_DATSOGALLERY_DATE_FORMAT')); ?>
            <div style="color: rgb(136, 136, 136);display:flex">
              <?php echo strftime("%H:%M:%S", strtotime(dg::timezone($item->created))); ?>
            </div>
          </td>
          <td class="nowrap hidden-phone">
              <?php
              if ($item->language == '*') :
                echo JText::alt('JALL', 'language');
              else :
                echo $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED');
              endif;
              ?>
          </td>
          <?php if (isset($this->items[0]->id)) : ?>
          <td class="center hidden-phone">
            <?php echo (int) $item->id; ?>
          </td>
          <?php endif; ?>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
    <?php if ($user->authorise('core.create', 'com_datsogallery')
      && $user->authorise('core.edit', 'com_datsogallery')
      && $user->authorise('core.edit.state', 'com_datsogallery')) : ?>
      <?php echo JHtml::_(
        'bootstrap.renderModal',
        'collapseModal',
        array(
          'title'  => JText::_('COM_DATSOGALLERY_BATCH_OPTIONS'),
          'footer' => $this->loadTemplate('batch_footer'),
        ),
        $this->loadTemplate('batch_body')
      ); ?>
    <?php endif; ?>
    <?php endif; ?>
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    <?php echo JHtml::_('form.token'); ?>
  </div>
</form>
<div class="modal fade" id="dg-modal" tabindex="-1" role="dialog" aria-hidden="true" style="width: 500px;left: calc(50% - 250px);margin: 0 auto;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div id="getipinfo" class="modal-body"></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= JText::_('JLIB_HTML_BEHAVIOR_CLOSE') ?></button>
      </div>
    </div>
  </div>
</div>
<script>
jQuery(function($) {
    $('#dg-modal').on('hidden.bs.modal', function (e) {
      $('#responseip, #getipinfo').empty();
    });
    $(document).on('click', '.dg-image-modal', function(e) {
      var preview = $(this).data('img-url');
      $('<img/>').attr('src', preview).appendTo('#getipinfo');
    });
});
</script>