<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewImage extends JViewLegacy {
	protected $state;
	protected $item;
	protected $form;

	public function display($tpl = null) {
		$app = JFactory::getApplication();
		$this->state = $this->get('State');
		$this->item = $this->get('Item');
		$this->tags = $this->get('Tags');
		$this->form = $this->get('Form');
    $this->settings = dg::getConfig();
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
		dg::addSubmenu('images');
		$this->sidebar = JHtmlSidebar::render();
		$this->addToolbar();
		parent::display($tpl);
	}

	protected function addToolbar() {
	  $app = JFactory::getApplication();
		$app->input->set('hidemainmenu', true);
    $lang = JFactory::getLanguage();
    $lang->load('com_datsogallery', JPATH_ADMINISTRATOR);
    $menus = $app->getMenu();
    $lng = substr($this->document->language, 0, 2);
		$user = JFactory::getUser();
		$isNew = ($this->item->id == 0);
		if (isset($this->item->checked_out)) {
			$checkedOut = !($this->item->checked_out == 0 || $this->item->checked_out == $user->get('id'));
		}
		else {
			$checkedOut = false;
		}
		$canDo = dg::getActions();
		JToolBarHelper::title(JText::_('COM_DATSOGALLERY_TITLE_IMAGE'), 'image');
		if (!$checkedOut && ($canDo->get('core.edit') || ($canDo->get('core.create')))) {
			JToolBarHelper::apply('image.apply', 'JTOOLBAR_APPLY');
			JToolBarHelper::save('image.save', 'JTOOLBAR_SAVE');
		}
		if (!$isNew && $canDo->get('core.create')) {
			JToolBarHelper::custom('image.save2copy', 'save-copy.png', 'save-copy_f2.png', 'JTOOLBAR_SAVE_AS_COPY', false);
		}
		if (empty($this->item->id)) {
			JToolBarHelper::cancel('image.cancel', 'JTOOLBAR_CANCEL');
		}
		else {
			JToolBarHelper::cancel('image.cancel', 'JTOOLBAR_CLOSE');
		}
    $this->document->addScript(JUri::root(true).'/components/com_datsogallery/assets/js/jquery.plugins.js');
    $this->document->addScript(JUri::root(true).'/components/com_datsogallery/assets/js/jquery.validate.min.js');
    $this->document->addScript(JUri::root(true).'/components/com_datsogallery/assets/js/upload.min.js');
    $this->document->addScript(JUri::root(true).'/components/com_datsogallery/assets/js/datsogallery.js');
    if ($this->settings->allow_geotagging) {
      if ($this->settings->gm_api_key != '') {
      $this->document->addScript('//maps.googleapis.com/maps/api/js?key='.$this->settings->gm_api_key.'&amp;libraries=places&amp;language='.$lng);
      }
      else {
        $this->document->addScript('//maps.googleapis.com/maps/api/js?libraries=places&amp;language='.$lng);
      }
    }
	}

}