<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

require_once (JPATH_COMPONENT.'/images.php');
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.formvalidator');
JHtml::_('behavior.keepalive');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');

$doc = JFactory::getDocument();
$doc->addStyleSheet('components/com_datsogallery/assets/css/datsogallery.css');
JHtml::_('bootstrap.framework');

/*$params = new JRegistry();
$params->loadString($this->item->params);*/
?>

<script type="text/javascript">
js = jQuery.noConflict();
js(document).ready(function() {
    js('input:hidden.catid').each(function() {
        var name = js(this).attr('name');
        if (name.indexOf('catidhidden')) {
            js('#jform_catid option[value="' + js(this).val() + '"]').attr('selected', true);
        }
    });
    js("#jform_catid").trigger("liszt:updated");
});

Joomla.submitbutton = function(task) {
    if (task == 'image.cancel') {
        Joomla.submitform(task, document.getElementById('image-form'));
    } else {
        js = jQuery.noConflict();
        if (js('#jform_original').val() != '') {
            js('#jform_original_hidden').val(js('#jform_original').val());
        }
        if (js('#jform_original').val() == '' && js('#jform_original_hidden').val() == '') {
            alert("<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED ')); ?>");
            return;
        }
        if (task != 'image.cancel' && document.formvalidator.isValid(document.id('image-form'))) {
            if (js('#jform_catid option:selected').length == 0) {
                js("#jform_catid option[value=0]").attr('selected', 'selected');
            }
            Joomla.submitform(task, document.getElementById('image-form'));
        } else {
            alert("<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED ')); ?>");
        }
    }
}

</script>
<form method="post" name="adminForm" id="image-form" class="form-validate">
  <?php echo JLayoutHelper::render('joomla.edit.title_alias', $this); ?>
  <div class="form-horizontal">
    <?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'details')); ?>
    <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'details', JText::_('COM_DATSOGALLERY_DETAILS', true)); ?>
    <div class="row-fluid">
      <div class="span9">
        <div class="row-fluid form-horizontal-desktop">
          <div class="span4">
            <?php echo $this->form->getInput('original'); ?>
            <div class="member_avatar dg-image" style="position:relative;padding-bottom:10px">
              <img src="<?php echo resize($this->item->original, 790, 1000, 0, '1:1', 0, $this->item->catid);?>" alt="" />
              <div id="dg-update-avatar" class="hint--bottom hint--medium" data-hint="<?php echo JText::_("COM_DATSOGALLERY_CHANGE_ORIGINAL"); ?>">
                <input class="dg-hiddenFile" name="originalfile" id="originalfile" accept=".gif, .jpg, .jpeg, .png" type="file">
              </div>
              <div class="dg-alert" style="display:none">
                <p>
                </p>
              </div>
            </div>
            <?php if ($this->settings->allow_geotagging) : ?>
            <p style="margin-right:12px;">
              <input id="geocomplete" type="text" placeholder="Type in an address" style="width:100%;" />
            </p>
            <p class="map_canvas">
            </p>
            <?php echo $this->form->getInput('lat'); ?>
            <?php echo $this->form->getInput('lng'); ?>
            <?php endif; ?>
          </div>
          <div class="span8">
            <?php echo $this->form->getInput('description'); ?>
          </div>
        </div>
      </div>
      <div class="span3">
        <?php echo JLayoutHelper::render('joomla.edit.global', $this); ?>
        <fieldset class="form-vertical">
<div class="control-group">
      <div class="control-label">
        <label for="jform_featured" class="hasPopover" data-content="<?= JText::_('COM_DATSOGALLERY_FORM_DESC_IMAGE_TAGS') ?>" data-original-title="<?= JText::_('COM_DATSOGALLERY_FORM_IMAGE_TAGS') ?>"><?= JText::_('COM_DATSOGALLERY_FORM_IMAGE_TAGS') ?></label>
</div>
    <div class="controls">
          <div class="input tagsarea">
            <input
                   class="tags"
                   id="dgtags"
                   type="text"
                   name="jform[tag]"
                   value="<?php echo implode(',', $this->tags); ?>">
          </div>
</div>
</div>
</fieldset>
      </div>
      <?php echo JHtml::_('bootstrap.endTab'); ?>
    </div>
    <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'publishing', JText::_('COM_DATSOGALLERY_FIELDSET_PUBLISHING')); ?>
    <div class="row-fluid form-horizontal-desktop">
      <div class="span6">
        <?php echo JLayoutHelper::render('joomla.edit.publishingdata', $this); ?>
      </div>
      <div class="span6">
        <?php echo JLayoutHelper::render('joomla.edit.metadata', $this); ?>
      </div>
    </div>
    <?php echo JHtml::_('bootstrap.endTab'); ?>
    <?php echo JHtml::_('bootstrap.endTabSet'); ?>
  </div>
  <input type="hidden" name="action" value="<?php echo JRoute::_('index.php?option=com_datsogallery&layout=edit&id=' . (int) $this->item->id); ?>" />
  <input type="hidden" name="task" value="" />
  <?php echo JHtml::_('form.token'); ?>
</form>
<style type="text/css">
#jform_description {
  width:100%
}
.dg-progress-bar {
    border-top:1px solid #fff;
    border-bottom: 1px solid #A9A9A9;
    background: #8FBC8B;
    color: #ffffff;
    float: left;
    font-size: 8px;
    font-weight: bold;
    margin-left:0.5px;
    height: 14px;
    line-height: 14px;
    text-align: center;
    text-shadow: 0 -0.5px 0 rgba(0, 0, 0, 0.2);
    transition: width 0.6s ease 0s;
    width: 0;
}
#replace-msg h2 {
  text-transform: uppercase;
}
.map_canvas {
  border:1px solid #DCDCDC;
  height:260px !important;
  width:100% !important;
}
.dg-uploadContainer {
  height: 97% !important;
}
.dg-uploadLabel {
  width: 100% !important;
  height: 100% !important;
  border-radius: 0 !important;
  line-height: normal !important;
}
#dgtags_tagsinput {
  display:flex;
  flex-wrap: wrap;
  align-items:center;
  margin:0 -3px;
}
#dgtags_tagsinput .tag {
  border: 1px solid #ccc;
  padding: 2px 2px 4px 8px;
  background-color: #fff;
  border-radius: 3px;
  display: flex;
  align-items: baseline;
  margin: 0 3px 6px 3px;
  box-shadow: 0 1px 0 rgba(255,255,255,0.2) inset, 0 1px 2px rgba(0,0,0,0.05);
}
#dgtags_tagsinput i.dgi-cancel {
  color: #bd362f;
}
.dg-uploadLabelImage {
  display: flex !important;
  height: 100% !important;
  width: 100% !important;
  align-items: center !important;
  justify-content: center !important;
}
</style>
<?php
$this->item->lat = $this->item->lat ? $this->item->lat : 0;
$this->item->lng = $this->item->lng ? $this->item->lng : 0;
$arr = array($this->item->lat, $this->item->lng);
?>
<script>
(function($) {
  var colwidth = $("div.col.col-8").width();
  $('.map_canvas').css('width:'+colwidth+'px');
  if ($("input#jform_lat").val('') && $("input#jform_lng").val('')) {
    $('.map_canvas').addClass('fb');
  } else {
    $('.map_canvas').removeClass('fb');
  }
  $("input#jform_lat").val(<?php echo $this->item->lat; ?>);
  $("input#jform_lng").val(<?php echo $this->item->lng; ?>);
  var options = {
      map: ".map_canvas",
      location: [<?php echo implode(',',$arr); ?>],
      mapOptions: {
          scrollwheel: true
      },
      markerOptions: {
          draggable: true
      }
  };
  $("#geocomplete").geocomplete(options).on("geocode:result", function(event, result) {
      $("input#jform_lat").val(result.geometry.location.lat());
      $("input#jform_lng").val(result.geometry.location.lng());
  }).on("geocode:dragged", function(event, latLng) {
      $("input#jform_lat").val(latLng.lat());
      $("input#jform_lng").val(latLng.lng());
      $("#geocomplete").geocomplete("find", latLng.toString());
  });
  $('#dgtags').tagsInput({
      'defaultText': '<?php echo JText::_("COM_DATSOGALLERY_ADD_TAG");?>',
      'removeWithBackspace': true,
      'minChars': 3
  });
})(jQuery);
</script>
<?php
dg::jslang('upload.min.js');
?>
<script>
function uploaded(e, p) {
    var newfile = e.uploadList[p].name;
    jQuery.post('<?php echo JUri::base(true); ?>/index.php?option=com_datsogallery&task=image.updateoriginal&<?= JSession::getFormToken() ?>=1', {
        id: '<?php echo $this->item->id; ?>',
        catid: '<?php echo $this->item->catid; ?>',
        original: '<?php echo $this->item->original; ?>',
        newfile: newfile
      }, function(data) {
      jQuery('.member_avatar img').attr('src', data + '?dt=' + (+new Date()));
      jQuery('#jform_original_hidden').prop('disabled', true);
      jQuery('.member_avatar .dg-alert').addClass('dg-alert-success').show();
      jQuery('.member_avatar .dg-alert p').append('<div class="avr-msg">Success!</div>');
      setTimeout(function(){
          jQuery('.member_avatar .dg-alert').removeClass('dg-alert-success').fadeOut('fast', function() {
            jQuery(".avr-msg, .dg-uploadItem").remove();
          });
      }, 3000);
    });
}
function failed(u, p, e) {
  jQuery('.member_avatar .dg-alert').addClass('dg-alert-danger').show();
  jQuery('.member_avatar .dg-alert p').append('<div class="avr-msg">'+e+'</div>');
  setTimeout(function(){
      jQuery('.member_avatar .dg-alert').removeClass('dg-alert-danger').fadeOut('fast', function() {
          jQuery(".avr-msg, .dg-uploadItem").remove();
       });
  }, 3000);
}
window.onload = function() {
  var uploadSettings = {
    'text': '<?php echo JText::_("Upload a file"); ?>',
    'method': 'POST',
	  'action': '<?php echo JUri::base(true); ?>/index.php?option=com_datsogallery&task=image.originalupload&id=<?php echo $this->item->id; ?>&<?= JSession::getFormToken() ?>=1',
    'avatar': true,
    'encoding': false,
    'extension': ['png', 'jpg', 'jpeg', 'gif'],
    'callbackSuccess': uploaded,
    'callbackError': failed,
    'maxWidth': 8000,
    'maxHeight': 8000,
    'maxFileSize': '<?= dg::maxuploadsize(); ?>',
  };
  var uploader = document.getElementById('originalfile');
  var uploadForm = new RealTimeUpload(uploadSettings, uploader);
};
</script>