<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
require_once (JPATH_COMPONENT.'/images.php');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_datsogallery/assets/css/datsogallery.css');
$document->addScript(Juri::root(true).'/components/com_datsogallery/assets/js/apexcharts.min.js');
$user = JFactory::getUser();
$lang = JFactory::getLanguage();
$dir = $lang->get('rtl');
$comments = dg::usercommentsactivities();
$categories = dg::usercategoriesactivities();
$images = dg::useruploadactivities();
$likes = dg::userlikesactivities();
$tags = dg::usertagsactivities();
if(!empty($this->sidebar)): ?>
<div id="j-sidebar-container" class="span2">
   <div><?php echo $this->sidebar; ?></div>
</div>
<div id="j-main-container" class="span10 dg-style">
<?php else : ?>
<div id="j-main-container" class="dg-style">
<?php endif;?>
<div class="row">
   <div class="col col4">
      <div class="dashboard-stat steelblue">
         <div class="visual">
            <i class="dgi-album"></i>
         </div>
         <div class="details">
            <div class="number">
               <?php echo $this->totalcategories; ?>
            </div>
            <div class="desc">
               <?php echo JText::_('COM_DATSOGALLERY_TOTAL_ALBUMS'); ?>
            </div>
         </div>
         <a class="more" href="<?php echo JRoute::_('index.php?option=com_datsogallery&view=categories'); ?>">
         <?php echo JText::_('COM_DATSOGALLERY_OPEN_MAGAGER'); ?> <i class="icon-arrow-right-2"></i>
         </a>
      </div>
   </div>
   <div class="col col4">
      <div class="dashboard-stat indianred">
         <div class="visual">
            <i class="dgi-image"></i>
         </div>
         <div class="details">
            <div class="number">
               <?php echo $this->totalimages; ?>
            </div>
            <div class="desc">
               <?php echo JText::_('COM_DATSOGALLERY_TOTAL_IMAGES'); ?>
            </div>
         </div>
         <a class="more" href="<?php echo JRoute::_('index.php?option=com_datsogallery&view=images'); ?>">
         <?php echo JText::_('COM_DATSOGALLERY_OPEN_MAGAGER'); ?> <i class="icon-arrow-right-2"></i>
         </a>
      </div>
   </div>
   <div class="col col4">
      <div class="dashboard-stat darkseagreen">
         <div class="visual">
            <i class="dgi-comments"></i>
         </div>
         <div class="details">
            <div class="number">
               <?php echo $this->totalcomments; ?>
            </div>
            <div class="desc">
               <?php echo JText::_('COM_DATSOGALLERY_TOTAL_COMMENTS'); ?>
            </div>
         </div>
         <a class="more" href="<?php echo JRoute::_('index.php?option=com_datsogallery&view=comments'); ?>">
         <?php echo JText::_('COM_DATSOGALLERY_OPEN_MAGAGER'); ?> <i class="icon-arrow-right-2"></i>
         </a>
      </div>
   </div>
</div>
<!-- start -->
<div class="row">
   <div id="firstcol" class="col col6">
      <div class="dg-dashboard-box">
        <legend class="dg-ellipsis"><?php echo JText::sprintf('COM_DATSOGALLERY_TITLE_GALLERY_ACTIVITIES'); ?></legend>
        <div id="galleryactivities"></div>
      </div>
      <div class="dg-dashboard-box">
      <legend class="dg-ellipsis"><?php echo JText::_('COM_DATSOGALLERY_TITLE_MOST_ACTIVE_USERS'); ?></legend>
      <?php
         if (count($this->mostactiveusers)) :
           echo '<div class="row">';
           foreach($this->mostactiveusers as $row) {
                echo '<div class="mau col col6">';
                echo '  <div class="pull-left">';
                echo '    <div class="ma-avatar">'.dg::avatar($row->id, null, false, true, true).'</div>';
                echo '  </div>';
                echo '  <div>';
                echo '    <div class="ma-title">'.$row->name.'</div>';
                echo '    <div class="ma-data">';
                echo '      <i class="dgi-album" title="'.JText::_('COM_DATSOGALLERY_TOTAL_ALBUMS').'"></i>'.$row->cc;
                echo '      &nbsp;<i class="dgi-image" title="'.JText::_('COM_DATSOGALLERY_TOTAL_IMAGES').'"></i>'.$row->ci;
                echo '      &nbsp;<i class="dgi-comments" title="'.JText::_('COM_DATSOGALLERY_TOTAL_COMMENTS').'"></i>'.$row->cm;
                echo '      &nbsp;<i class="dgi-likes" title="'.JText::_('COM_DATSOGALLERY_TOTAL_LIKES').'"></i>'.$row->cl;
                echo '    </div>';
                echo '    <div class="ma-lastvisit"><i class="dgi-time" title="'.JText::_('COM_DATSOGALLERY_LAST_VISIT').'"></i>'.dg::timelapse($row->lastvisitDate).'</div>';
                echo '  </div>';
                echo '</div>';
           }
           echo '</div>';
         else :
           echo JText::_("COM_DATSOGALLERY_NOTHING_TO_SHOW");
         endif;
         ?>
      </div>
      <div class="dg-dashboard-box">
      <legend class="dg-ellipsis"><?php echo JText::_('COM_DATSOGALLERY_TITLE_REPORTED_IMAGES'); ?></legend>
      <?php if (count($this->reportedimages)) : ?>
      <table class="table table-striped" id="pics" style="table-layout: fixed;">
         <?php foreach ($this->reportedimages as $item) : ?>
         <tr>
            <td style="width:25px;">
               <div class="zoombox">
                  <div class="crop showbox" style="background-image: url('<?php echo resize($item->original, 200, 200, 1, '1:1', 0, $item->catid);?>');"></div>
               </div>
            </td>
            <td style="max-width: 200px;">
               <div style="position:relative;margin-top:-3px !important;display:block" class="dg-ellipsis"><?php echo $item->title ?></div>
            </td>
            <td>
               <div class="max-lines"><?php echo $item->message ?></div>
            </td>
            <td style="width: 60px;">
               <div class="btn-group" style="float:right;display:flex">
                  <a id="<?php echo $item->id; ?>" class="btn-state hasTooltip active review" title="<?php echo JText::_('COM_DATSOGALLERY_CLICK_TO_REVIEW'); ?>">
                  <i class="dgi-visibility"></i>
                  </a>
                  <a href="<?php echo JRoute::_('index.php?option=com_datsogallery&task=image.edit&id=' . $item->id); ?>" class="btn-state edit hasTooltip" title="<?php echo JText::_('COM_DATSOGALLERY_CLICK_TO_EDIT'); ?>">
                  <i class="dgi-edit"></i>
                  </a>
               </div>
            </td>
         </tr>
         <?php endforeach; ?>
      </table>
      <?php else : ?>
      <div><?php echo JText::_("COM_DATSOGALLERY_NOTHING_TO_SHOW"); ?></div>
      <?php endif; ?>
      </div>
   </div>
   <div id="secondcol" class="col col6">
      <div class="row">
         <div id="firstchildcol" class="col col6">
            <div class="dg-dashboard-box">
            <legend class="dg-ellipsis"><?php echo JText::_('COM_DATSOGALLERY_TITLE_AWAITING_APPROVAL'); ?></legend>
            <?php if (count($this->unapproved)) : ?>
            <table class="table table-striped" id="pics" style="table-layout: fixed;">
               <?php
                  foreach ($this->unapproved as $item) :
                  $canChange	= $user->authorise('core.edit.state',	'com_datsogallery');
                  ?>
               <tr>
                  <td style="width:25px;">
                     <div class="zoombox">
                        <div class="crop showbox" style="background-image: url('<?php echo resize($item->original, 200, 200, 1, '1:1', 0, $item->catid);?>');"></div>
                     </div>
                  </td>
                  <td>
                     <div style="position:relative;margin-top:-3px !important;display:block" class="dg-ellipsis"><?php echo $item->title ?></div>
                     <div class="dg-subline">
                        <i class="dgi-user"></i><?php echo '<a href="'.JRoute::_('index.php?option=com_users&task=user.edit&id='.$item->created_by).'" title="'.JText::_('COM_DATSOGALLERY_CLICK_TO_EDIT').'">'.$item->name.'</a>'; ?>&nbsp;&nbsp;<?php echo '<i class="dgi-album"></i><a href="'.JRoute::_('index.php?option=com_datsogallery&task=category.edit&id=' . $item->catid).'" title="'.JText::_('COM_DATSOGALLERY_CLICK_TO_EDIT').'">'.$item->ctitle.'</a>'; ?>&nbsp;&nbsp;
                        <i class="dgi-clock"></i><?php echo dg::timelapse($item->created); ?>
                     </div>
                  </td>
                  <td style="width: 60px;">
                     <div class="btn-group" style="float:right;display:flex">
                        <a id="<?php echo $item->id; ?>" class="btn-state hasTooltip featured toapprove" title="<?php echo JText::_('COM_DATSOGALLERY_CLICK_TO_APPROVE'); ?>">
                        <i class="dgi-visibility-off"></i>
                        </a>
                        <a href="<?php echo JRoute::_('index.php?option=com_datsogallery&task=image.edit&id=' . $item->id); ?>" class="btn-state edit hasTooltip" title="<?php echo JText::_('COM_DATSOGALLERY_CLICK_TO_EDIT'); ?>">
                  <i class="dgi-edit"></i>
                  </a>
                     </div>
                  </td>
               </tr>
               <?php endforeach; ?>
            </table>
            <?php else : ?>
            <div><?php echo JText::_("COM_DATSOGALLERY_NOTHING_TO_SHOW"); ?></div>
            <?php endif; ?>
            </div>
            <div class="dg-dashboard-box">
            <legend class="dg-ellipsis"><?php echo JText::_('COM_DATSOGALLERY_TITLE_LAST_ADDED'); ?></legend>
            <?php if (count($this->lastadded)) : ?>
            <table id="latestpics" class="table table-striped" style="table-layout: fixed;">
               <?php foreach ($this->lastadded as $item) : ?>
               <tr>
                 <td style="width:25px;">
                     <div class="zoombox">
                        <div class="crop showbox" style="background-image: url('<?php echo resize($item->original, 200, 200, 1, '1:1', 0, $item->catid);?>');"></div>
                     </div>
                  </td>
                  <td>
                     <div style="position:relative;margin-top:-3px !important;display:block" class="dg-ellipsis"><?php echo $item->title ?></div>
                     <div class="dg-subline">
                        <i class="dgi-user"></i><?php echo '<a href="'.JRoute::_('index.php?option=com_users&task=user.edit&id='.$item->created_by).'" title="'.JText::_('COM_DATSOGALLERY_CLICK_TO_EDIT').'">'.$item->name.'</a>'; ?>&nbsp;&nbsp;<?php echo '<i class="dgi-album"></i><a href="'.JRoute::_('index.php?option=com_datsogallery&task=category.edit&id=' . $item->catid).'" title="'.JText::_('COM_DATSOGALLERY_CLICK_TO_EDIT').'">'.$item->ctitle.'</a>'; ?>&nbsp;&nbsp;
                        <i class="dgi-clock"></i><?php echo dg::timelapse($item->created); ?>
                     </div>
                  </td>
                  <td style="width: 60px;">
                     <div class="btn-group" style="float: <?php echo ($dir == 0 ? "right" : "left"); ?>;">
                        <a href="<?php echo JRoute::_('index.php?option=com_datsogallery&task=image.edit&id=' . $item->id); ?>" class="btn-state edit hasTooltip" title="<?php echo JText::_('COM_DATSOGALLERY_CLICK_TO_EDIT'); ?>">
                        <i class="dgi-edit"></i>
                        </a>
                     </div>
                  </td>
               </tr>
               <?php endforeach; ?>
            </table>
            <?php else : ?>
            <div><?php echo JText::_("COM_DATSOGALLERY_NOTHING_TO_SHOW"); ?></div>
            <?php endif; ?>
            </div>
         </div>
         <div id="secondchildcol" class="col col6">
            <div class="dg-dashboard-box">
            <legend class="dg-ellipsis"><?php echo JText::_('COM_DATSOGALLERY_TITLE_LATEST_COMMENTS'); ?></legend>
            <ul class="comment-section">
               <?php if (count($this->comments) > 0) { ?>
               <?php foreach ($this->comments as $row) { ?>
               <li id="<?php echo $row->id; ?>" class="comment <?php echo ($dir == 0 ? "direction-ltr" : "direction-rtl"); ?>">
                  <div class="info">
                     <span class="dg-user-name"><?php echo $row->user_name; ?></span>
                     <span><?php echo dg::timelapse($row->date);?></span>
                     <span><?php echo $row->user_url;?></span>
                  </div>
                  <span class="<?php echo ($dir == 0 ? "avatar-ltr" : "avatar-rtl"); ?>">
                  <?php echo dg::avatar($row->created_by, $row->id, false, true, true); ?>
                  </span>

                  <p id="<?php echo $row->id; ?>-edit"><?php echo nl2br($row->text);?></p>

                  <div class="btn-group dg-comment-actions">
                  <a id="<?php echo $row->id; ?>" class="btn-state hasTooltip<?php echo $row->state == 1 ? ' active' : ''; ?> publishcomment" title="<?php echo $row->state == 1 ? JText::_('JTOOLBAR_UNPUBLISH') : JText::_('JTOOLBAR_PUBLISH'); ?>">
                  <i id="<?php echo $row->state; ?>" class="<?php echo $row->state == 1 ? 'dgi-check-circle' : 'dgi-cancel'; ?>"></i>
                  </a>
                  <a href="<?php echo JRoute::_('index.php?option=com_datsogallery&task=comment.edit&id=' . $row->id); ?>" class="btn-state edit hasTooltip" title="<?php echo JText::_('COM_DATSOGALLERY_CLICK_TO_EDIT'); ?>">
                  <i class="dgi-edit"></i>
                  </a>
                  <?php echo JHtml::_('datsogallery.block', $row->user_ip, $row->created_by, 1, 'blacklist'); ?>
                  </div>
               </li>
               <?php } ?>
               <?php } else { ?>
               <li id="no-comments">
                  <div class="dg-alert">
                     <div class="dg-alert-close dg-close"></div>
                     <p><?php echo JText::_("COM_DATSOGALLERY_NO_COMMENTS"); ?></p>
                  </div>
               </li>
               <?php } ?>
            </ul>
            </div>
         </div>
      </div>
   </div>
</div>
<!-- end -->
<script>
jQuery(document).on('click', '.publishcomment', function(){
    var a = jQuery(this),
        b = a.attr('id'),
        c = a.find('i').attr('id');
    jQuery.post('index.php?option=com_datsogallery&task=datsogallery.publishComment', {id: b, state: c}, function(result){
      if (result == 1) {
        a.addClass('active').attr('data-original-title', '<?= JText::_('JTOOLBAR_UNPUBLISH') ?>').find('i').removeClass('dgi-cancel').addClass('dgi-check-circle').attr('id', '1');
      } else {
        a.removeClass('active').attr('data-original-title', '<?= JText::_('JTOOLBAR_PUBLISH') ?>').find('i').removeClass('dgi-check-circle').addClass('dgi-cancel').attr('id', '0');
      }
    });
});
jQuery(document).on('click', '.toapprove', function(){
    var el = jQuery(this);
    var picid = jQuery(this).attr('id');
    jQuery.post('index.php?option=com_datsogallery&task=datsogallery.approveAjax', {id: picid}, function(result){
      if (result) {
        el.parent().parent().parent().fadeOut('slow');
      }
    });
});
jQuery(document).on('click', '.review', function(){
    var el = jQuery(this);
    var picid = jQuery(this).attr('id');
    jQuery.post('index.php?option=com_datsogallery&task=datsogallery.reviewAjax', {id: picid}, function(result){
      if (result) {
        el.parent().parent().parent().fadeOut('slow');
      }
    });
});

jQuery('.max-lines').each(function() {
var maxlines = jQuery(this).text();
if (maxlines.length > 140) {
  var truncated = maxlines.trim().substring(0, 140).split(" ").slice(0, -1).join(" ") + "…";
  jQuery(this).text(truncated);
}
});
</script>
<style>
a {
  cursor: pointer;
}

.lastadded-time {
  color:#808080;
  font-size:11px;
}
.lastadded-time i {
  top: -1px;
  position: relative;
}
.max-lines1 {
  display: block; /* or inline-block */
  text-overflow: ellipsis;
  word-wrap: break-word;
  overflow: hidden;
  max-height: 3.6em;
  line-height: 1.8em;
}
   .rounded2 img, .rounded3 img {
   border-radius: 4px;
   }
   .rounded1 img {
   border-radius: 50%;
   }
   .img {
   position:relative;
   }
   .img:hover:before{
   font-family: 'IcoMoon';
   content: "\47";
   font-size: 14px;
   color: #F5F5F5;
   position: absolute;
   top: 5px;
   right: 20px;
   text-shadow: 0px 0px 1px #000;
   }
   .arrow_box .btn-group {
   float:right;
   position:relative;
   top: 7px;
   right: 2px;
   }
   .arrow_box .btn-group i {
   left: 2px;
   }
   @keyframes horizontal {
   0% {
   transform: translate(0px, 0px);
   }
   6% {
   transform: translate(5px, 0px);
   }
   12% {
   transform: translate(0px, 0px);
   }
   18% {
   transform: translate(5px, 0px);
   }
   24% {
   transform: translate(0px, 0px);
   }
   30% {
   transform: translate(5px, 0px);
   }
   36% {
   transform: translate(0px, 0px);
   }
   }
   .animated {
   animation: 2s ease 0s normal none 1 running horizontal;
   }
   .dg-style .row {
   margin: 0 -10px;
   display: flex;
   flex-wrap: wrap;
   }
   .dg-style .row:after {
   content: '';
   display: table;
   clear: both;
   }
   .dg-style .col {
   float: left;
   min-height: 1px;
   padding-right: 10px;
   padding-left: 10px;
   padding-bottom: 20px;
   box-sizing: border-box;
   -moz-box-sizing: border-box;
   }
   .dg-style .col1 {
   width: calc(100% / 12 * 1);
   }
   .dg-style .col2 {
   width: calc(100% / 12 * 2);
   }
   .dg-style .col3 {
   width: calc(100% / 12 * 3);
   }
   .dg-style .col4 {
   width: calc(100% / 12 * 4);
   }
   .dg-style .col5 {
   width: calc(100% / 12 * 5);
   }
   .dg-style .col6 {
   width: calc(100% / 12 * 6);
   }
   .dg-style .col7 {
   width: calc(100% / 12 * 7);
   }
   .dg-style .col8 {
   width: calc(100% / 12 * 8);
   }
   .dg-style .col9 {
   width: calc(100% / 12 * 9);
   }
   .dg-style .col10 {
   width: calc(100% / 12 * 10);
   }
   .dg-style .col11 {
   width: calc(100% / 12 * 11);
   }
   .dg-style .col12 {
   width: calc(100% / 12 * 12);
   }

@media screen and (max-width: 1919px) {
   #firstchildcol,
   #secondchildcol{
     float: none !important;
     width: 100% !important;
   }
}
@media screen and (min-width: 1920px) {
   .mau {
     float: left !important;
     width: calc(100% / 12 * 4) !important;
   }
}
@media screen and (max-width: 1023px) and (min-width: 601px) {
   .mau {
     float: none !important;
     width: 100% !important;
   }
}
@media screen and (max-width: 600px) and (min-width: 481px) {
   .mau {
     float: left !important;
     width: calc(100% / 12 * 6) !important;
   }
}
@media screen and (max-width: 600px) {
   .dg-style .col {
     float: none;
     width: 100%;
   }
}
   .dashboard-stat {
   position: relative;
   display: block;
   margin-bottom: 25px;
   overflow: hidden;
   border-radius: 10px;
   width: 100%
   }
   .dashboard-stat:before, .dashboard-stat:after {
   content: " ";
   display: table;
   }
   .dashboard-stat:after {
   clear: both;
   }
   .portlet .dashboard-stat:last-child {
   margin-bottom: 0;
   }
   .dashboard-stat .visual {
    width: 100px;
    height: 100px;
    display: block;
    float: left;
    margin-top: -15px;
    padding-left: 12px;
    margin-bottom: 15px;
    font-size: 35px;
    line-height: 35px;
    padding-bottom: 15px;
   }
   .dashboard-stat .visual > i {
   font-size: 110px;
   line-height: 100px;
   }
   .dashboard-stat .details {
   position: absolute;
   right: 15px;
   padding-right: 15px;
   }
   .dashboard-stat .details .number {
   padding-top: 25px;
   text-align: right;
   font-size: 34px;
   line-height: 36px;
   letter-spacing: -1px;
   margin-bottom: 0px;
   font-weight: 300;
   }
   .dashboard-stat .details .desc {
   text-align: right;
   font-size: 16px;
   letter-spacing: 0px;
   font-weight: 300;
   }
   .dashboard-stat .more {
   clear: both;
   display: block;
   padding: 6px 10px 6px 10px;
   position: relative;
   text-transform: uppercase;
   font-weight: 300;
   font-size: 11px;
   opacity: 0.7;
   filter: alpha(opacity=70);
   }
   .dashboard-stat .more:hover {
   text-decoration: none;
   opacity: 0.9;
   filter: alpha(opacity=90);
   }
   .dashboard-stat .more > i {
   display: inline-block;
   margin-top: 1px;
   float: right;
   }
   .dashboard-stat.steelblue {
   background-color:#4682B4;
   }
   .dashboard-stat.steelblue .visual > i {
   color: #FFFFFF;
   opacity: 0.1;
   filter: alpha(opacity=10);
   }
   .dashboard-stat.steelblue .details .number {
   color: #FFFFFF;
   }
   .dashboard-stat.steelblue .details .desc {
   color: #FFFFFF;
   opacity: 1;
   filter: alpha(opacity=100);
   }
   .dashboard-stat.steelblue .more {
   color: #FFFFFF;
   }
   .dashboard-stat.indianred {
   background-color:#CD5C5C;
   }
   .dashboard-stat.indianred .visual > i {
   color: #FFFFFF;
   opacity: 0.1;
   filter: alpha(opacity=10);
   }
   .dashboard-stat.indianred .details .number {
   color: #FFFFFF;
   }
   .dashboard-stat.indianred .details .desc {
   color: #FFFFFF;
   opacity: 1;
   filter: alpha(opacity=100);
   }
   .dashboard-stat.indianred .more {
   color: #FFFFFF;
   }
   .dashboard-stat.darkseagreen {
   background-color:#8FBC8B;
   }
   .dashboard-stat.darkseagreen .visual > i {
   color: #FFFFFF;
   opacity: 0.1;
   filter: alpha(opacity=10);
   }
   .dashboard-stat.darkseagreen .details .number {
   color: #FFFFFF;
   }
   .dashboard-stat.darkseagreen .details .desc {
   color: #FFFFFF;
   opacity: 1;
   filter: alpha(opacity=100);
   }
   .dashboard-stat.darkseagreen .more {
   color: #FFFFFF;
   }
   .dashboard-stat.sandybrown {
   background-color:#F4A460;
   }
   .dashboard-stat.sandybrown .visual > i {
   color: #FFFFFF;
   opacity: 0.1;
   filter: alpha(opacity=10);
   }
   .dashboard-stat.sandybrown .details .number {
   color: #FFFFFF;
   }
   .dashboard-stat.sandybrown .details .desc {
   color: #FFFFFF;
   opacity: 1;
   filter: alpha(opacity=100);
   }
   .dashboard-stat.sandybrown .more {
   color: #FFFFFF;
   }
   /* various containers */
   /*.container {
   width: 200px;
   margin: 0 auto;
   }
   .canvas-container {
   min-height: 300px;
   max-height: 600px;
   position: relative;
   }
   .widget {
   box-sizing: border-box;
   margin-left: -10px;
   padding: 0;
   position: relative;
   top: 0 !important;
   }
   .widget.doughnut .status {
   left: 0.5px;
   position: absolute;
   text-align: center;
   top: 20.7%;
   }
   .widget.doughnut .status img {
   border-radius: 50%;
   width: 49%;
   }*/
   #galleryactivities {
     width: 100%;
   background: #fff;
   border-radius: 4px;
   }
</style>
<script>
jQuery(window)
.on("load", function () {
var e = "#ccb2d9",
    t = "#bde5b3",
    a = "#fdce7c",
    o = "#96cdf4",
    r = "#fbb1a4",
    s = {
      chart: {
        width: "100%",
        height: 340,
        type: "area",
        toolbar: {
          show: true
        },
        sparkline: {
          enabled: false
        }
      },
      colors: [e,t,a,o,r],
      stroke: {
        curve: "smooth",
        width: 2
      },
      fill: {
        type: "gradient",
        gradient: {
          shadeIntensity: .9,
          opacityFrom: .7,
          opacityTo: .5,
          stops: [0, 80, 100]
        }
      },
      xaxis: {
        categories: <?= dg::months() ?>,
        tickPlacement: 'off',
        axisBorder: {
            show: true,
            color: '#78909C',
            height: 1,
            width: '100%',
            offsetX: 0,
            offsetY: 0
        },
        axisTicks: {
            show: true,
            borderType: 'solid',
            color: '#78909C',
            height: 6,
            offsetX: 0,
            offsetY: 0
        },
      },
      series: [
      {
        name: "<?= JText::_('COM_DATSOGALLERY_CATEGORIES') ?>",
        data: <?= dg::combomonths($categories) ?>
      },
      {
        name: "<?= JText::_('COM_DATSOGALLERY_IMAGES') ?>",
        data: <?= dg::combomonths($images) ?>
      },
      {
        name: "<?= JText::_('COM_DATSOGALLERY_COMMENTS') ?>",
        data: <?= dg::combomonths($comments) ?>
      },
      {
        name: "<?= JText::_('COM_DATSOGALLERY_LIKES') ?>",
        data: <?= dg::combomonths($likes) ?>
      },
      {
        name: "<?= JText::_('COM_DATSOGALLERY_TAGS') ?>",
        data: <?= dg::combomonths($tags) ?>
      }
      ],
      tooltip: {
        style: {
          fontSize: '12px',
          fontFamily: 'inherit'
        }
      }
};
new ApexCharts(document.querySelector("#galleryactivities"), s)
.render();
});
</script>