<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

class DatsogalleryViewComment extends JViewLegacy {

	protected $state;
	protected $item;
	protected $form;

	public function display($tpl = null) {
		$this->state = $this->get('State');
		$this->item = $this->get('Item');
		$this->form = $this->get('Form');
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
		$this->addToolbar();
		parent::display($tpl);
	}

	protected function addToolbar() {
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$user = JFactory::getUser();
		$isNew = ($this->item->id == 0);
		if (isset($this->item->checked_out)) {
			$checkedOut = !($this->item->checked_out == 0 || $this->item->checked_out == $user->get('id'));
		}
		else {
			$checkedOut = false;
		}
		$canDo = dg::getActions();
		JToolBarHelper::title(JText::_('COM_DATSOGALLERY_TITLE_COMMENT'), 'comment.png');
		if (!$checkedOut && ($canDo->get('core.edit') || ($canDo->get('core.create')))) {
			JToolBarHelper::apply('comment.apply', 'JTOOLBAR_APPLY');
			JToolBarHelper::save('comment.save', 'JTOOLBAR_SAVE');
		}
		JToolBarHelper::cancel('comment.cancel', 'JTOOLBAR_CANCEL');
	}

}