<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

class DatsogalleryViewCategory extends JViewLegacy
{
  protected $published;
  protected $item;
  protected $form;

  public function display($tpl = null)
  {
    $this->published = $this->get('State');
    $this->item      = $this->get('Item');
    $this->form      = $this->get('Form');

    if (count($errors = $this->get('Errors'))) {
      throw new Exception(implode("\n", $errors));
    }

    $this->addToolbar();
    parent::display($tpl);
  }

  protected function addToolbar()
  {
    JFactory::getApplication()->input->set('hidemainmenu', true);

    $user  = JFactory::getUser();
    $isNew = ($this->item->id == 0);
    if (isset($this->item->checked_out)) {
      $checkedOut = !($this->item->checked_out == 0 || $this->item->checked_out == $user->get('id'));
    } else {
      $checkedOut = false;
    }
    $canDo = dg::getActions();

    JToolBarHelper::title(JText::_('COM_DATSOGALLERY_TITLE_CATEGORY'), 'folder categories');

    if (!$checkedOut && ($canDo->get('core.edit') || ($canDo->get('core.create')))) {
      JToolBarHelper::apply('category.apply', 'JTOOLBAR_APPLY');
      JToolBarHelper::save('category.save', 'JTOOLBAR_SAVE');
    }
    if (!$checkedOut && ($canDo->get('core.create'))) {
      JToolBarHelper::custom('category.save2new', 'save-new.png', 'save-new_f2.png', 'JTOOLBAR_SAVE_AND_NEW', false);
    }
    if (!$isNew && $canDo->get('core.create')) {
      JToolBarHelper::custom('category.save2copy', 'save-copy.png', 'save-copy_f2.png', 'JTOOLBAR_SAVE_AS_COPY', false);
    }
    if (empty($this->item->id)) {
      JToolBarHelper::cancel('category.cancel', 'JTOOLBAR_CANCEL');
    } else {
      JToolBarHelper::cancel('category.cancel', 'JTOOLBAR_CLOSE');
    }
  }
}
