<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$doc = JFactory::getDocument();
$doc->addStyleSheet('components/com_datsogallery/assets/css/datsogallery.css');
$user	    = JFactory::getUser();
$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$canOrder	= $user->authorise('core.edit.state', 'com_datsogallery');
$saveOrder = ($listOrder == 'a.lft' && strtolower($listDirn) == 'asc');
if ($saveOrder) {
	$saveOrderingUrl = 'index.php?option=com_datsogallery&task=categories.saveOrderAjax';
	JHtml::_('sortablelist.sortable', 'categoryList', 'adminForm', strtolower($listDirn), $saveOrderingUrl, false, true);
}
?>
<form action="<?php echo JRoute::_('index.php?option=com_datsogallery&view=categories'); ?>" method="post" name="adminForm" id="adminForm" class="dg-style">
   <?php if(!empty($this->sidebar)): ?>
   <div id="j-sidebar-container" class="col col-2">
      <div class="filling"><?php echo $this->sidebar; ?></div>
   </div>
   <div id="j-main-container" class="col col-10">
      <?php else : ?>
      <div id="j-main-container">
         <?php endif;?>
         <?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>

         <div class="clearfix"> </div>
         <table class="table table-striped" id="categoryList">
            <thead>
               <tr>
                  <?php if (isset($this->items[0]->ordering)): ?>
                  <th width="1%" class="nowrap center hidden-phone">
                     <?php echo JHtml::_('searchtools.sort', '', 'a.lft', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
                  </th>
                  <?php endif; ?>
                  <th width="1%" class="hidden-phone">
                     <input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                  </th>
                  <?php if (isset($this->items[0]->published)): ?>
                  <th width="1%" class="nowrap center">
                    <?php echo JText::_('COM_DATSOGALLERY_ACTIONS'); ?>
                  </th>
                <?php endif; ?>
                  <th class='left'>
                     <?php echo JHtml::_('searchtools.sort',  'COM_DATSOGALLERY_CATEGORIES_TITLE', 'a.title', $listDirn, $listOrder); ?>
                  </th>
                  <th class='center hidden-phone'>
                     <?php echo JText::_('COM_DATSOGALLERY_IMAGES'); ?>
                  </th>
                  <th class='left hidden-phone'>
                     <?php echo JHtml::_('searchtools.sort',  'COM_DATSOGALLERY_CATEGORIES_ACCESS', 'a.access', $listDirn, $listOrder); ?>
                  </th>
                  <th class='left hidden-phone'>
                     <?php echo JHtml::_('searchtools.sort',  'COM_DATSOGALLERY_CATEGORIES_CREATED_BY', 'a.created_by', $listDirn, $listOrder); ?>
                  </th>
                  <th class='left hidden-phone'>
                     <?php echo JHtml::_('searchtools.sort',  'COM_DATSOGALLERY_CATEGORIES_CREATED_TIME', 'a.created_time', $listDirn, $listOrder); ?>
                  </th>
                  <th class='left hidden-phone'>
                     <?php echo JHtml::_('searchtools.sort',  'COM_DATSOGALLERY_CATEGORIES_LANGUAGE', 'a.language', $listDirn, $listOrder); ?>
                  </th>
                  <?php if (isset($this->items[0]->id)): ?>
                  <th width="1%" class="nowrap center hidden-phone">
                     <?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                  </th>
                  <?php endif; ?>
               </tr>
            </thead>
            <tfoot>
               <?php
                  if(isset($this->items[0])){
                      $colspan = count(get_object_vars($this->items[0]));
                  }
                  else{
                      $colspan = 10;
                  }
                  ?>
               <tr>
                  <td colspan="<?php echo $colspan ?>">
                     <?php echo $this->pagination->getListFooter(); ?>
                  </td>
               </tr>
            </tfoot>
            <tbody>
            <?php foreach ($this->items as $i => $item) :
                $orderkey = array_search($item->id, $this->ordering[$item->parent_id]);
                $canCreate = $user->authorise('core.create', 'com_datsogallery');
                $canEdit = $user->authorise('core.edit', 'com_datsogallery');
                $canCheckin = $user->authorise('core.manage', 'com_datsogallery');
                $canChange = $user->authorise('core.edit.state', 'com_datsogallery');
                if ($item->level > 1) {
                  $parentsStr = "";
                  $_currentParentId = $item->parent_id;
                  $parentsStr = " ".$_currentParentId;
                  for ($i2 = 0; $i2 < $item->level; $i2++) {
                    foreach ($this->ordering as $k => $v) {
                      $v = implode("-", $v);
                      $v = "-".$v."-";
                      if (strpos($v, "-".$_currentParentId."-") !== false) {
                        $parentsStr .= " ".$k;
                        $_currentParentId = $k;
                        break;
                      }
                    }
                  }
                }
                else {
                  $parentsStr = "";
                }
               ?>
               <tr class="row<?php echo $i % 2; ?>" sortable-group-id="<?php echo $item->parent_id; ?>" item-id="<?php echo $item->id ?>" parents="<?php echo $parentsStr ?>" level="<?php echo $item->level ?>">
                  <td class="order nowrap center hidden-phone">
                     <?php
                        $iconClass = '';
                        if (!$canChange)
                        {
                        	$iconClass = ' inactive';
                        }
                        elseif (!$saveOrder)
                        {
                        	$iconClass = ' inactive tip-top hasTooltip" title="' . JHtml::tooltipText('JORDERINGDISABLED');
                        }
                        ?>
                     <span class="sortable-handler<?php echo $iconClass ?>">
                     <i class="icon-menu" style="margin-top: 5px"></i>
                     </span>
                     <?php if ($canChange && $saveOrder) : ?>
                     <input type="text" style="display:none" name="order[]" size="5" value="<?php echo $orderkey + 1; ?>" />
                     <?php endif; ?>
                  </td>
                  <td class="center hidden-phone">
                     <div style="margin:0"><?php echo JHtml::_('grid.id', $i, $item->id); ?></div>
                  </td>
                  <?php if (isset($this->items[0]->published)): ?>
                  <td class="center">
                  <div style="display:flex">
                  <?php
                     echo JHtml::_('jgrid.published', $item->published, $i, 'categories.', $canChange, 'cb', $item->publish_up, $item->publish_down);
                     echo JHtml::_('datsogallery.approved', $item->approved, $i, $canChange, 'categories');
                     echo JHtml::_('datsogallery.edit', $item->id, $canChange, 'category');
                  ?>
                  </div>
                  </td>
                  <?php endif; ?>
                  <td>
                     <?php echo str_repeat('<span class="mdash">|&mdash;</span>', $item->level - 1) ?>
                     <?php if ($item->checked_out) : ?>
                     <?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'categories.', $canCheckin); ?>
                     <?php endif; ?>
                     <?php if ($canEdit || $canEditOwn) : ?>
                     <a href="<?php echo JRoute::_('index.php?option=com_datsogallery&task=category.edit&id=' . $item->id); ?>">
                     <?php echo $this->escape($item->title); ?></a>
                     <span style="font-size: 10px; font-weight: 500; margin-top: -4px; color: rgb(136, 136, 136);display:flex">
                         <i class="dgi-link" style="top: -1px; position: relative;" title="<?php echo JText::_('JFIELD_ALIAS_LABEL'); ?>"></i> <?php echo $this->escape($item->alias); ?>
          						</span>
                     <?php else : ?>
                     <?php echo $this->escape($item->title); ?>
                     <?php endif; ?>
                     <span class="small" title="<?php echo $this->escape($item->path); ?>"></span>
                  </td>
                  <td class="center hidden-phone">
                     <div class="badge <?php if (dg::numimagesCat($item->id) > 0) echo "badge-success"; ?>"><?php echo dg::numimagesCat($item->id); ?></div>
                  </td>
                  <td class="hidden-phone">
                     <?php echo $this->escape($item->access_level); ?>
                  </td>
                  <td class="hidden-phone">
                     <a class="hasTooltip" href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id=' . (int) $item->created_by); ?>" title="<?php echo JText::_('JAUTHOR'); ?>">
                     <?php echo $this->escape($item->created_by); ?></a>
                  </td>
                  <td class="hidden-phone" style="font-size: 10px; font-weight: 500;line-height: 15px;">
                      <?php echo JHtml::_('date', dg::timezone($item->created_time), JText::_('COM_DATSOGALLERY_DATE_FORMAT')); ?>
                      <div style="color: rgb(136, 136, 136);display:flex">
          						  <i class="dgi-time" style="top: -1px;position: relative;"></i><?php echo strftime("%H:%M:%S", strtotime(dg::timezone($item->created_time))); ?>
          						</div>
          				</td>
                  <td class="hidden-phone">
                     <?php if ($item->language == '*') : ?>
                     <?php echo JText::alt('JALL', 'language'); ?>
                     <?php else: ?>
                     <?php echo $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
                     <?php endif; ?>
                  </td>
                  <td class="center hidden-phone">
                     <span title="<?php echo sprintf('%d-%d', $item->lft, $item->rgt); ?>">
                     <?php echo (int) $item->id; ?></span>
                  </td>
               </tr>
               <?php endforeach; ?>
            </tbody>
         </table>
         <?php if ($user->authorise('core.create', 'com_datsogallery')
    				&& $user->authorise('core.edit', 'com_datsogallery')
    				&& $user->authorise('core.edit.state', 'com_datsogallery')) : ?>
    				<?php echo JHtml::_(
    					'bootstrap.renderModal',
    					'collapseModal',
    					array(
    						'title'  => JText::_('COM_DATSOGALLERY_BATCH_OPTIONS'),
    						'footer' => $this->loadTemplate('batch_footer'),
    					),
    					$this->loadTemplate('batch_body')
    				); ?>
    			<?php endif; ?>
         <input type="hidden" name="task" value="" />
         <input type="hidden" name="boxchecked" value="0" />
         <?php echo JHtml::_('form.token'); ?>
      </div>
   </div>
</form>
