<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewBlacklists extends JViewLegacy {
	protected $items;
	protected $pagination;
	protected $state;
  public $filterForm;
	public $activeFilters;

	public function display($tpl = null) {
		$this->state = $this->get('State');
		$this->items = $this->get('Items');
    $this->filterForm = $this->get('FilterForm');
    $this->activeFilters = $this->get('ActiveFilters');
		$this->pagination = $this->get('Pagination');
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
		dg::addSubmenu('blacklists');
		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		parent::display($tpl);
	}

	protected function addToolbar() {
		require_once JPATH_COMPONENT.'/helpers/datsogallery.php';
		$state = $this->get('State');
		$canDo = dg::getActions($state->get('filter.id'));
		JToolBarHelper::title(JText::_('COM_DATSOGALLERY_TITLE_BLACKLISTS'), 'blacklists.png');
		$formPath = JPATH_COMPONENT_ADMINISTRATOR.'/views/blacklist';
		if (file_exists($formPath)) {
			if ($canDo->get('core.create')) {
				JToolBarHelper::addNew('blacklist.add', 'JTOOLBAR_NEW');
			}
			if ($canDo->get('core.edit') && isset($this->items[0])) {
				JToolBarHelper::editList('blacklist.edit', 'JTOOLBAR_EDIT');
			}
		}
		if ($canDo->get('core.edit.state')) {
			if (isset($this->items[0]->state)) {
				JToolBarHelper::divider();
				JToolBarHelper::custom('blacklists.publish', 'publish.png', 'publish_f2.png', 'JTOOLBAR_PUBLISH', true);
				JToolBarHelper::custom('blacklists.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
			}
			else
				if (isset($this->items[0])) {
					JToolBarHelper::deleteList('', 'blacklists.delete', 'JTOOLBAR_DELETE');
				}
				/*if (isset($this->items[0]->checked_out)) {
					JToolBarHelper::custom('blacklists.checkin', 'checkin.png', 'checkin_f2.png', 'JTOOLBAR_CHECKIN', true);
				}*/
		}
    if ($canDo->get('core.delete') && isset($this->items[0]->state)) {
				JToolBarHelper::deleteList('', 'blacklists.delete', 'JTOOLBAR_DELETE');
		}
		JHtmlSidebar::setAction('index.php?option=com_datsogallery&view=blacklists');
	}

	protected function getSortFields() {
		return array(
    'a.id' => JText::_('JGRID_HEADING_ID'),
    'a.ip' => JText::_('COM_DATSOGALLERY_BLACKLISTS_IP'),
    'a.date' => JText::_('COM_DATSOGALLERY_BLACKLISTS_DATE'),
    'a.state' => JText::_('JSTATUS'),
    'a.created_by' => JText::_('COM_DATSOGALLERY_BLACKLISTS_USER_NAME'),
    );
	}

}