<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

//require_once JPATH_COMPONENT.'/helpers/datsogallery.php';
JLoader::register('dg', JPATH_ADMINISTRATOR . '/components/com_datsogallery/helpers/datsogallery.php');

class DatsogalleryModelSettings extends JModelAdmin {

	public function __construct() {
		parent::__construct();
	}

	public function getForm($data = array(), $loadData = true) {
		$form = $this->loadForm('com_datsogallery.settings', 'settings',
    array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}
		return $form;
	}

	public function loadFormData() {
		require_once JPATH_COMPONENT.'/helpers/datsogallery.php';
		$data = (array) dg::getConfig();
		return $data;
	}

	public function save($data) {
	  $app = JFactory::getApplication();
		require_once JPATH_COMPONENT.'/helpers/config.php';
		$config = DatsogalleryConfig::getInstance();
		if (isset($data['restoring']) && $data['restoring'] == 1) {
      if ($this->restoring($data)) {
        $app->enqueueMessage(
          JText::_('COM_DATSOGALLERY_RESTORING_MSG'), 'Notice'
        );
      }
      unset($data['restoring']);
		}
    else {
      if (isset($data['rules'])) unset($data['rules']);
      if (isset($data['protect_originals']) && $data['protect_originals'] == 1) {
        dg::protect_dir();
      }
      if (isset($data['protect_originals']) && $data['protect_originals'] == 0) {
        dg::unprotect_dir();
      }
      if (isset($data['custom_css'])) {
        dg::write_custom_css($data['custom_css']);
        unset($data['custom_css']);
      }
      foreach ($data as $prop => $val) {
        $config->set($prop, $val);
      }
    }
    dg::readConfig(true);
		return true;
	}

  public function restoring($data) {
    require_once JPATH_COMPONENT.'/helpers/config.php';
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->delete($db->quoteName('#__datsogallery_settings'));
    $db->setQuery($query);
    $db->execute();
    dg::readConfig(true);
    $config = DatsogalleryConfig::getInstance();
    $xml = simplexml_load_file(JPATH_COMPONENT.'/models/forms/settings.xml');
    foreach($xml->children() as $fields) {
      foreach($fields as $field) {
        if (in_array($field['name'], array('restoring','license','rules'))) continue;
        $name = (string) $field['name'];
        $value = (string) $field['default'];
        $config->set($name, $value);
      }
    }
    if (isset($data['license'])) {
      $config->set('license', $data['license']);
    }
    return true;
  }

  public function existsTable($table_name) {
    $db = JFactory::getDbo();
    $table_name = str_replace('#__', $db->getPrefix(), (string) $table_name);
    return in_array($table_name, $db->getTableList());
  }

  public function clearcolors() {
    $app = JFactory::getApplication();
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->delete('#__datsogallery_colors');
    $db->setQuery($query);
    try {
      $db->execute();
      return $db->getAffectedRows();
    }
    catch (Exception $ex) {
      $app->enqueueMessage($ex->getMessage(), 'error');
      return false;
    }
  }

  public function getPhoca() {
    jimport('joomla.filesystem.file');
    jimport('joomla.filesystem.folder');
    $app = JFactory::getApplication();
    if ($this->existsTable('#__datsogallery_categories')) {
      $db = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select('*')
            ->from($db->qn('#__datsogallery_categories'));
      $db->setQuery($query);
      $categories = $db->loadObjectList();
      if (count($categories) > 1) {
        return false;
      }
    }
    else {
      return false;
    }
    if ($this->existsTable('#__phocagallery_categories')) {
      $db = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select('*')
            ->from($db->qn('#__phocagallery_categories'));
      $db->setQuery($query);
      if (!$db->loadObjectList()) {
        return false;
      }
    }
    else {
      return false;
    }
    if ($this->existsTable('#__phocagallery')) {
      $db = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select('*')
            ->from($db->qn('#__phocagallery'));
      $db->setQuery($query);
      if (!$db->loadObjectList()) {
        return false;
      }
    }
    else {
      return false;
    }
    if (!JFolder::exists(JPATH_ROOT.'/images/phocagallery')) {
      return false;
    }
    return true;
  }

  public function msleep($time) {
    usleep($time * 1000000);
  }

	public function mphocatodg() {
	  jimport('joomla.filesystem.file');
    $content = '{"progress":100}';
    JFile::write(JPATH_COMPONENT.'/progress.json', $content);
		require_once JPATH_COMPONENT.'/helpers/datsogallery.php';
		$config = dg::getConfig();
    $app = JFactory::getApplication();
    $user = JFactory::getUser();
    $db = JFactory::getDbo();
		$query = $db->getQuery(true);
    $query->delete('#__datsogallery_categories');
    $db->setQuery($query);
    $db->execute();
    $query->clear()
          ->select('*')
          ->from($db->qn('#__phocagallery_categories'));
    $db->setQuery($query);
    $categories = $db->loadObjectList();
    $count = count($categories);
    $i = 0;
    foreach ($categories as $category) {
      $createdby = $category->owner_id == 0 ? $user->id : $category->owner_id;
      $query->clear()
            ->insert('#__datsogallery_categories')
            ->set($db->qn('id').' = '.$category->id)
            ->set($db->qn('parent_id').' = '.$category->parent_id)
            ->set($db->qn('title').' = '.$db->q($category->title))
            ->set($db->qn('alias').' = '.$db->q($category->alias))
            ->set($db->qn('description').' = '.$db->q($category->description))
            ->set($db->qn('created_by').' = '.(int) $createdby)
            ->set($db->qn('created_time').' = '.$db->q($category->date))
            ->set($db->qn('published').' = '.$category->published)
            ->set($db->qn('approved').' = '.$category->approved)
            ->set($db->qn('access').' = '.$db->q($category->access))
            ->set($db->qn('params').' = '.$db->q($category->params))
            ->set($db->qn('ordering').' = '.$category->ordering)
            ->set($db->qn('hits').' = '.$db->q($category->hits))
            ->set($db->qn('metakey').' = '.$db->q($category->metakey))
            ->set($db->qn('metadesc').' = '.$db->q($category->metadesc))
            ->set($db->qn('metadata').' = '.$db->q($category->metadata))
            ->set($db->qn('language').' = '.$db->q($category->language));
      $db->setQuery($query);
      try {
        $db->execute();
      }
      catch (Exception $ex) {
        $app->enqueueMessage($ex->getMessage(), 'error');
        JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => 100, 'action' => 'error')));
        return false;
      }
      $i++;
      JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => round(($i / $count) * 100), 'action' => 'categories', 'migrated' => $i, 'total' => $count)));
      $this->msleep(.1);
    }
    $squery = $db->getQuery(true);
    $squery->select('1')
           ->from($db->qn('#__datsogallery_categories', 'b'))
           ->where($db->qn('b.id').' = a.id + 1');
    $query->clear()
          ->select('min(a.id + 1) as gap')
          ->from($db->qn('#__datsogallery_categories', 'a'))
          ->where('not exists ('.$squery.')');
    $db->setQuery($query);
    $gapid = $db->loadResult();
    $query->clear()
          ->update($db->qn('#__datsogallery_categories'))
          ->set($db->qn('id').' = '.$gapid)
          ->where($db->qn('id').' = 1')
          ->order($db->qn('id').' desc');
    $db->setQuery(str_replace('UPDATE', 'UPDATE IGNORE', $query));
    try {
      $db->execute();
    }
    catch (Exception $ex) {
      $app->enqueueMessage($ex->getMessage(), 'error');
      JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => 100, 'action' => 'error')));
      return false;
    }
    $this->migrateimages();
    $query->clear()
          ->update('#__datsogallery_images')
          ->set('catid = '.$gapid)
          ->where('catid = 1');
    $db->setQuery($query);
    try {
      $db->execute();
    }
    catch (Exception $ex) {
      $app->enqueueMessage($ex->getMessage(), 'error');
      JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => 100, 'action' => 'error')));
      return false;
    }
    $this->addRoot();
    $query->clear()
          ->update('#__datsogallery_categories')
          ->set('parent_id = '.$gapid)
          ->where('parent_id = 1')
          ->where('id != 1');
    $db->setQuery($query);
    try {
      $db->execute();
    }
    catch (Exception $ex) {
      $app->enqueueMessage($ex->getMessage(), 'error');
      JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => 100, 'action' => 'error')));
      return false;
    }
    $query->clear()
          ->update('#__datsogallery_categories')
          ->set('parent_id = 1')
          ->where('id = '.$gapid);
    $db->setQuery($query);
    try {
      $db->execute();
    }
    catch (Exception $ex) {
      $app->enqueueMessage($ex->getMessage(), 'error');
      JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => 100, 'action' => 'error')));
      return false;
    }
    JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_datsogallery/tables');
    $table = JTable::getInstance('Category', 'DatsogalleryTable');
    if (!$table->rebuild()) {
      $app->enqueueMessage($table->getError(), 'error');
      JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => 100, 'action' => 'error')));
      return false;
    }
    $this->migratecomments();
    $this->migratevotes();
    JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => 100, 'action' => 'completed')));
	}

  public function migrateimages() {
    jimport('joomla.filesystem.folder');
    jimport('joomla.filesystem.file');
    require JPATH_COMPONENT_SITE.'/controllers/datso.iptc.php';
    require_once (JPATH_COMPONENT.'/images.php');
    $phocapath = JPATH_ROOT.'/images/phocagallery/';
    $settings = dg::getConfig();
    $app = JFactory::getApplication();
    $user = JFactory::getUser();
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('*')
          ->from($db->qn('#__phocagallery'));
    $db->setQuery($query);
    $images = $db->loadObjectList();
    $count = count($images);
    $i = 0;
    foreach ($images as $image) {
      $createdby = $image->userid == 0 ? $user->id : $image->userid;
      $ext = strtolower(JFile::getExt($image->filename));
      $original = $this->newimgid($image->catid, $ext);
      if (JFile::exists($phocapath.$image->filename)) {
        if (JFile::copy($phocapath.$image->filename, JPATH_SITE.$settings->path_to_originals.'/'.$original)) {
          $info = getImageInfo(JPATH_SITE.$settings->path_to_originals.'/'.$original);
          foreach ($info as $k => $v){
            $d[$k] = $v;
          }
          $description = (!empty($info['description']) && $info['description'] != null) ? $info['description'] : '';
          $author = (!empty($info['author'])) ? $info['author'] : '';
          $exif = @exif_read_data(JPATH_SITE.$settings->path_to_originals.'/'.$original);
          $lat = (!empty($exif['GPSLatitude'])) ? dg::geo_single_gps($exif["GPSLatitude"], $exif['GPSLatitudeRef']) : '';
          $lng = (!empty($exif['GPSLongitude'])) ? dg::geo_single_gps($exif["GPSLongitude"], $exif['GPSLongitudeRef']) : '';
        }
        $desc = !empty($image->description) ? $image->description : $description;
        $latitude = !empty($image->latitude) ? $image->latitude : $lat;
        $longitude = !empty($image->longitude) ? $image->longitude : $lng;
        $query->clear()
              ->insert('#__datsogallery_images')
              ->set($db->qn('id').' = '.$image->id)
              ->set($db->qn('catid').' = '.$image->catid)
              ->set($db->qn('title').' = '.$db->q($image->title))
              ->set($db->qn('alias').' = '.$db->q($image->alias))
              ->set($db->qn('description').' = '.$db->q($desc))
              ->set($db->qn('original').' = '.$db->q($original))
              ->set($db->qn('hits').' = '.$db->q($image->hits))
              ->set($db->qn('state').' = '.$db->q($image->published))
              ->set($db->qn('approved').' = '.$image->approved)
              ->set($db->qn('ordering').' = '.$image->ordering)
              ->set($db->qn('access').' = 1')
              ->set($db->qn('params').' = '.$db->q($image->params))
              ->set($db->qn('language').' = '.$db->q($image->language))
              ->set($db->qn('created_by').' = '.(int) $createdby)
              ->set($db->qn('metakey').' = '.$db->q($image->metakey))
              ->set($db->qn('metadesc').' = '.$db->q($image->metadesc))
              ->set($db->qn('metadata').' = '.$db->q($image->metadata))
              ->set($db->qn('lat').' = '.$db->q($latitude))
              ->set($db->qn('lng').' = '.$db->q($longitude))
              ->set($db->qn('created').' = '.$db->q($image->date))
              ->set($db->qn('author').' = '.$db->q($author));
        $db->setQuery($query);
        try {
          $db->execute();
        }
        catch (Exception $ex) {
          $app->enqueueMessage(
            JText::sprintf('An error occurred while migrating images. %s',
            $ex->getMessage()), 'error'
          );
          JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => 100, 'action' => 'error')));
          return false;
        }
        $i++;
        JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => round(($i / $count) * 100), 'action' => 'images', 'migrated' => $i, 'total' => $count)));
        $this->msleep(.1);
      }
    }
  }

  public function migratecomments() {
    jimport('joomla.filesystem.file');
    require_once JPATH_COMPONENT.'/helpers/datsogallery.php';
    $app = JFactory::getApplication();
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('*')
          ->from($db->qn('#__phocagallery_img_comments'));
    $db->setQuery($query);
    $comments = $db->loadObjectList();
    $count = count($comments);
    $i = 0;
    foreach ($comments as $comment) {
      $user = $comment->userid ? JFactory::getUser($comment->userid) : '';
      $user_name = $comment->userid ? $user->name : '';
      $user_email = $comment->userid ? $user->email : '';
      $query->clear()
            ->insert('#__datsogallery_comments')
            ->set($db->qn('id').' = '.$comment->id)
            ->set($db->qn('image_id').' = '.$comment->imgid)
            ->set($db->qn('user_name').' = '.$db->q($user_name))
            ->set($db->qn('user_email').' = '.$db->q($user_email))
            ->set($db->qn('text').' = '.$db->q($comment->comment))
            ->set($db->qn('date').' = '.$db->q($comment->date))
            ->set($db->qn('ordering').' = '.$comment->ordering)
            ->set($db->qn('state').' = '.$comment->published)
            ->set($db->qn('created_by').' = '.$comment->userid);
      $db->setQuery($query);
      try {
        $db->execute();
      }
      catch (Exception $ex) {
        $app->enqueueMessage(
          JText::sprintf('An error occurred while migrating comments. %s',
          $ex->getMessage()), 'error'
        );
        JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => 100, 'action' => 'error')));
        return false;
      }
      $i++;
      JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => round(($i / $count) * 100), 'action' => 'comments', 'migrated' => $i, 'total' => $count)));
      $this->msleep(.1);
    }
  }

  public function migratevotes() {
    jimport('joomla.filesystem.file');
    $app = JFactory::getApplication();
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('*')
          ->from($db->qn('#__phocagallery_img_votes'))
          ->where($db->qn('rating').' in (1,5)')
          ->order('date');
    $db->setQuery($query);
    $likes = $db->loadObjectList();
    $count = count($likes);
    $i = 0;
    foreach ($likes as $like) {
      $rating = $like->rating == 5 ? 1 : 2;
      $query->clear()
            ->insert('#__datsogallery_likes')
            ->set($db->qn('id').' = '.$like->id)
            ->set($db->qn('image_id').' = '.$like->imgid)
            ->set($db->qn('user_id').' = '.$like->userid)
            ->set($db->qn('ip').' = '.$db->q('127.0.0.0'))
            ->set($db->qn('rate').' = '.$rating)
            ->set($db->qn('rated_on').' = '.$db->q($like->date));
      $db->setQuery($query);
      try {
        $db->execute();
      }
      catch (Exception $ex) {
        $app->enqueueMessage(
          JText::sprintf('An error occurred while migrating votes. %s',
          $ex->getMessage()), 'error'
        );
        JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => 100, 'action' => 'error')));
        return false;
      }
      $i++;
      JFile::write(JPATH_COMPONENT.'/progress.json', json_encode(array('progress' => round(($i / $count) * 100), 'action' => 'votes', 'migrated' => $i, 'total' => $count)));
      $this->msleep(.1);
    }
  }

  public function newimgid($catid, $imgext) {
    return substr(strtoupper(md5(uniqid(time()))), 5, 12).'-'.$catid.'.'.strtolower($imgext);
  }

  public function addRoot() {
    jimport('joomla.filesystem.file');
    $app = JFactory::getApplication();
    $db = JFactory::getDbo();
    $columns = array('id', 'asset_id', 'parent_id', 'lft', 'rgt', 'level', 'path',
                     'ordering', 'title', 'alias', 'note', 'description', 'published', 'approved',
                     'publish_up', 'publish_down', 'checked_out', 'checked_out_time',
                     'access', 'params', 'metadesc', 'metakey', 'metadata',
                     'created_by', 'created_time', 'modified_by',
                     'modified_time', 'hits', 'language', 'cover', 'image_id'
                     );
    $values  = array(1, 0, 0, 0, 1, 0, $db->q(''), 1, $db->q('ROOT'), $db->q('root'),
                     $db->q(''), $db->q(''), 1, 0, $db->q('0000-00-00 00:00:00'),
                     $db->q('0000-00-00 00:00:00'), 0, $db->q('0000-00-00 00:00:00'), 1,
                     $db->q('{}'), $db->q(''), $db->q(''), $db->q('{}'), 62,
                     $db->q('2011-01-01 00:00:01'), 0, $db->q('0000-00-00 00:00:00'), 0,
                     $db->q('*'), 0, 0
                     );
    $query = $db->getQuery(true);
    $query->insert('#__datsogallery_categories')
          ->columns($db->qn($columns))
          ->values(implode(',', $values));
    $db->setQuery($query);
    try {
      $db->execute();
    }
    catch (Exception $ex) {
      $app->enqueueMessage(
        JText::sprintf('An error occurred while creating ROOT category. %s',
        $ex->getMessage()), 'error'
      );
      return false;
    }
  }
}