<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('JPATH_PLATFORM') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldCategoryowner extends JFormFieldList {

  public $type = 'Categoryowner';
  protected static $options = array();

  protected function getOptions() {
    $hash = md5($this->element);
    if (!isset(static::$options[$hash])) {
      static::$options[$hash] = parent::getOptions();
      $options = array();
      $db = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select('u.id AS value, u.name AS text')
            ->from('#__users AS u')
            ->join('INNER', '#__datsogallery_categories AS c ON c.created_by = u.id')
            ->group('u.id, u.name')
            ->order('u.name');
      $db->setQuery($query);
      if ($options = $db->loadObjectList()) {
        static::$options[$hash] = array_merge(static::$options[$hash], $options);
      }
    }
    return static::$options[$hash];
  }

}