<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

class JFormFieldAllowedMultiple extends JFormFieldList {
  
	protected $type = 'allowedmultiple';

	public function getInput() {
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('DISTINCT id AS value, title AS text')
          ->from($db->qn('#__datsogallery_categories'))
          ->where('NOT '.$db->qn('alias').' = '.$db->q('root'))
          ->where($db->qn('parent_id').' > 0')
          ->order('ordering, title');
		$rows = $db->setQuery($query)->loadObjectlist();
    $lang = JFactory::getLanguage();
    $allowed_categories = explode(',', dg::getConfig('allowed_categories'));
    $out = '';
		$out .= '<select id="jform_allowed_categories" name="jform[allowed_categories][]" multiple="" style="display: none;">';
    $out .= '<option value="">--</option>';
    foreach ($rows as $row) {
      $selected = in_array($row->value, $allowed_categories) ? ' selected' : '';
      $out .= '<option value="'.$row->value.'"'.$selected.'>'.$row->text.'</option>';
    }
    $out .= '</select>';
    return $out;
	}

}