<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Datsogallery records.
 */
class DatsogalleryModelDatsogallery extends JModelList {

  public function __construct($config = array()) {
    parent::__construct($config);
  }
  function getcategories() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(id)')
          ->from('#__datsogallery_categories')
          ->where('alias != '.$db->q('root'));
    $db->setQuery($query);
    return $db->loadResult();
  }

  function getimages() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(id)')
          ->from('#__datsogallery_images');
    $db->setQuery($query);
    return $db->loadResult();
  }

  function getcomments() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(id)')
          ->from('#__datsogallery_comments');
    $db->setQuery($query);
    return $db->loadResult();
  }

  function gettotallikes() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(id)')
          ->from('#__datsogallery_likes')
          ->where('rate = 1');
    $db->setQuery($query);
    return $db->loadResult();
  }

  function gettotalunlikes() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(id)')
          ->from('#__datsogallery_likes')
          ->where('rate = 2');
    $db->setQuery($query);
    return $db->loadResult();
  }

  /*function getpurchases() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(*)')
          ->from('#__datsogallery_purchases');
    $db->setQuery($query);
    return $db->loadResult();
  }*/

  function getunpublished() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('i.*, c.title as ctitle, u.name')
          ->from('#__datsogallery_images as i')
          ->join('left', $db->qn('#__datsogallery_categories').' c on c.id = i.catid')
          ->join('left', $db->qn('#__users').' u on u.id = i.created_by')
          ->where('i.state = 0')
          ->order($db->qn('i.created') . ' desc')
          ->setLimit('7');
    $db->setQuery($query);
    return $db->loadObjectList();
  }

  function getunapproved() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('i.*, c.title as ctitle, u.name')
          ->from('#__datsogallery_images as i')
          ->join('left', $db->qn('#__datsogallery_categories').' c on c.id = i.catid')
          ->join('left', $db->qn('#__users').' u on u.id = i.created_by')
          ->where('i.approved = 0')
          ->order($db->qn('i.created') . ' desc')
          ->setLimit('7');
    $db->setQuery($query);
    return $db->loadObjectList();
  }

  function getreportedimages() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('i.*, r.message')
          ->from('#__datsogallery_images as i')
          ->join('left', $db->qn('#__datsogallery_reports').' r on r.image_id = i.id')
          ->where($db->qn('r.state').' = 1')
          ->group($db->qn('i.id'))
          ->order($db->qn('r.id') . ' desc')
          ->setLimit('7');
    $db->setQuery($query);
    return $db->loadObjectList();
  }

  function getlatestcomments() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('*')
          ->from('#__datsogallery_comments')
          ->order($db->qn('date') . ' desc')
          ->setLimit('7');
    $db->setQuery($query);
    return $db->loadObjectList();
  }

  function getlastadded() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('i.*, c.title as ctitle, u.name')
          ->from('#__datsogallery_images as i')
          ->join('left', $db->qn('#__datsogallery_categories').' c on c.id = i.catid')
          ->join('left', $db->qn('#__users').' u on u.id = i.created_by')
          ->group($db->qn('i.id'))
          ->order($db->qn('i.created') . ' desc')
          ->setLimit('12');
    $db->setQuery($query);
    return $db->loadObjectList();
  }

  function getmostactiveusers() {
    $db    = JFactory::getDbo();
    $ci    = '(SELECT COUNT(distinct id) FROM `#__datsogallery_images` WHERE `created_by` = `u`.`id`) AS ci';
    $cc    = '(SELECT COUNT(distinct id) FROM `#__datsogallery_categories` WHERE `created_by` = `u`.`id`) AS cc';
    $cm    = '(SELECT COUNT(distinct id) FROM `#__datsogallery_comments` WHERE `created_by` = `u`.`id`) AS cm';
    $cl    = '(SELECT COUNT(distinct id) FROM `#__datsogallery_likes` WHERE `user_id` = `u`.`id`) AS cl';
    $tci   = 'SELECT COUNT(distinct id) FROM `#__datsogallery_images` WHERE `created_by` = `u`.`id`';
    $tcc   = 'SELECT COUNT(distinct id) FROM `#__datsogallery_categories` WHERE `created_by` = `u`.`id`';
    $tcm   = 'SELECT COUNT(distinct id) FROM `#__datsogallery_comments` WHERE `created_by` = `u`.`id`';
    $tcl   = 'SELECT COUNT(distinct id) FROM `#__datsogallery_likes` WHERE `user_id` = `u`.`id`';
    $query = $db->getQuery(true);
    $query->select('u.id,u.name,u.lastvisitDate,'.$ci.','.$cc.','.$cm.','.$cl.',(('.$tci.')+('.$tcc.')+('.$tcm.')+('.$tcl.')) AS total')
          ->from($db->qn('#__users').' as u')
          ->group($db->qn('u.id'))
          ->order('total DESC')
          ->setLimit('9');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  function getUploadactivities($user_id = null) {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query
      ->select('MONTH(' .
        $query->concatenate(
          array(
            $query->year($query->qn('created')),
            $query->q('-'),
            $query->month($query->qn('created')),
            $query->q('-01')
          )
        ) . ') as m'
      )
      ->select('COUNT(*) as c')
      ->from($query->qn('#__datsogallery_images'))
      ->group($query->qn('m'))
      ->order($query->qn('m') . ' desc');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  function getCategoriesactivities() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query
      ->select('MONTH(' .
        $query->concatenate(
          array(
            $query->year($query->qn('created_time')),
            $query->q('-'),
            $query->month($query->qn('created_time')),
            $query->q('-01')
          )
        ) . ') as m'
      )
      ->select('COUNT(*) as c')
      ->from($query->qn('#__datsogallery_categories'))
      ->group($query->qn('m'))
      ->order($query->qn('m') . ' desc');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  function getCommentsactivities() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query
      ->select('MONTH(' .
        $query->concatenate(
          array(
            $query->year($db->qn('date')),
            $db->q('-'),
            $query->month($db->qn('date')),
            $db->q('-01')
          )
        ) . ') as m'
      )
      ->select('COUNT(*) as c')
      ->from($db->qn('#__datsogallery_comments'))
      ->group($db->qn('m'))
      ->order($db->qn('m') . ' desc');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  function getLikesactivities() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query
      ->select('MONTH(' .
        $query->concatenate(
          array(
            $query->year($query->qn('rated_on')),
            $query->q('-'),
            $query->month($query->qn('rated_on')),
            $query->q('-01')
          )
        ) . ') as m'
      )
      ->select('COUNT(*) as c')
      ->from($db->qn('#__datsogallery_likes'))
      ->group($db->qn('m'))
      ->order($db->qn('m') . ' desc');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  function getTagsactivities() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query
      ->select('MONTH(' .
        $query->concatenate(
          array(
            $query->year($query->qn('created')),
            $query->q('-'),
            $query->month($query->qn('created')),
            $query->q('-01')
          )
        ) . ') as m'
      )
      ->select('COUNT(*) as c')
      ->from($query->qn('#__datsogallery_tags', 'b'))
      ->group($query->qn('m'))
      ->order($query->qn('m') . ' desc');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

}
