<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
jimport('joomla.application.component.modeladmin');

class DatsogalleryModelComment extends JModelAdmin {
	protected $text_prefix = 'COM_DATSOGALLERY';

	public function getTable($type = 'Comment', $prefix = 'DatsogalleryTable', $config = array()) {
		return JTable::getInstance($type, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true) {
		$app = JFactory::getApplication();
		$form = $this->loadForm('com_datsogallery.comment', 'comment', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}
		return $form;
	}

	protected function loadFormData() {
		$data = JFactory::getApplication()->getUserState('com_datsogallery.edit.comment.data', array());
		if (empty($data)) {
			$data = $this->getItem();
		}
		return $data;
	}

	public function getItem($pk = null) {
		if ($item = parent::getItem($pk)) {
		}
		return $item;
	}

	protected function prepareTable($table) {
		jimport('joomla.filter.output');
		if (empty($table->id)) {
			if (@$table->ordering === '') {
				$db = JFactory::getDbo();
				$db->setQuery('SELECT MAX(ordering) FROM #___datsogallery_comments');
				$max = $db->loadResult();
				$table->ordering = $max + 1;
			}
		}
	}

  public function publish(&$pks, $value = 0)
  {
    $pks = (array) $pks;
    $settings = dg::getConfig();
    JArrayHelper::toInteger($pks);
    if (empty($pks)) {
      $this->setError(JText::_('COM_DATSOGALLERY_NO_ITEM_SELECTED'));
      return false;
    }
    try {
      $db    = $this->getDbo();
      $query = $db->getQuery(true);
      $query->update('#__datsogallery_comments');
      $query->set('state = ' . (int) $value);
      $query->where('id IN (' . implode(',', $pks) . ')');
      $db->setQuery($query);
      $db->execute();
    } catch (Exception $e) {
      $this->setError($e->getMessage());
      return false;
    }
    if ($settings->comments_approval && $value == 1) {
      foreach ($pks as $pk) {
         dg::comment_approval_notify($pk);
      }
    }
    return true;
  }

}