<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

class DatsogalleryModelCategories extends JModelList {

  public function __construct($config = array()) {
    if (empty ($config['filter_fields'])) {
    	$config['filter_fields'] = array(
    		'id', 'a.id',
    		'title', 'a.title',
    		'alias', 'a.alias',
    		'published', 'a.published',
    		'access', 'a.access', 'access_level',
    		'language', 'a.language',
    		'checked_out', 'a.checked_out',
    		'checked_out_time', 'a.checked_out_time',
    		'created_time', 'a.created_time',
    		'created_by', 'a.created_by',
    		'lft', 'a.lft',
    		'rgt', 'a.rgt',
    		'level', 'a.level',
    		'path', 'a.path',
        'author_id'
    	);
    }
    parent::__construct($config);
  }

  protected function populateState($ordering = 'a.lft', $direction = 'asc') {
    $app = JFactory::getApplication();
    $forcedLanguage = $app->input->get('forcedLanguage', '', 'cmd');
    if ($layout = $app->input->get('layout')) {
      $this->context .= '.' . $layout;
    }
    if ($forcedLanguage) {
      $this->context .= '.' . $forcedLanguage;
    }
    $this->setState('filter.search', $this->getUserStateFromRequest($this->context . '.search', 'filter_search', '', 'string'));
    $this->setState('filter.published', $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '', 'string'));
    $this->setState('filter.access', $this->getUserStateFromRequest($this->context . '.filter.access', 'filter_access', '', 'cmd'));
    $this->setState('filter.language', $this->getUserStateFromRequest($this->context . '.filter.language', 'filter_language', '', 'string'));
    $this->setState('filter.level', $this->getUserStateFromRequest($this->context . '.filter.level', 'filter_level', '', 'string'));
    $this->setState('filter.author_id', $this->getUserStateFromRequest($this->context.'.filter.author_id', 'filter_author_id'));

    $this->setState('params', JComponentHelper::getParams('com_datsogallery'));
    parent::populateState($ordering, $direction);
    if (!empty($forcedLanguage)) {
      $this->setState('filter.language', $forcedLanguage);
    }
  }

  protected function getStoreId($id = '') {
    $id .= ':'.$this->getState('filter.search');
    $id .= ':'.$this->getState('filter.published');
    $id .= ':'.$this->getState('filter.access');
    $id .= ':'.$this->getState('filter.language');
    $id .= ':'.$this->getState('filter.level');
    $id .= ':'.$this->getState('filter.author_id');
    return parent::getStoreId($id);
  }

  protected function getListQuery() {
    $db = $this->getDbo();
    $query = $db->getQuery(true);
    $user = JFactory::getUser();
    $query->select($this->getState('list.select', 'a.*'));
    $query->from('`#__datsogallery_categories` AS a');
    $query->select('uc.name AS editor');
    $query->join('LEFT', '#__users AS uc ON uc.id = a.checked_out');
    $query->select('p.title AS parent_title');
    $query->join('LEFT', '#__datsogallery_categories AS p ON p.id = a.parent_id');
    $query->select('checked_out.name AS checked_out');
    $query->join('LEFT', '#__users AS checked_out ON checked_out.id = a.checked_out');
    $query->select('created_by.name AS created_by');
    $query->join('LEFT', '#__users AS created_by ON created_by.id = a.created_by');
    $query->select('created_user_id.id AS created_user_id');
    $query->join('LEFT', '#__users AS created_user_id ON created_user_id.id = a.created_by');
    $query->select('l.title AS language_title');
    $query->join('LEFT', $db->quoteName('#__languages').' AS l ON l.lang_code = a.language');
    $query->select('ag.title AS access_level');
    $query->join('LEFT', '#__viewlevels AS ag ON ag.id = a.access');
    $query->select('u.name AS modified_user_id');
    $query->join('LEFT', '#__users AS u ON u.id = a.modified_by');
    $query->where('NOT (a.id = 1)');
    if ($authorId = $this->getState('filter.author_id')) {
      $query->where('a.created_by = '.(int) $authorId);
    }
    if ($level = $this->getState('filter.level')) {
      $query->where('a.level <= '.(int) $level);
    }
    if ($access = $this->getState('filter.access')) {
      $query->where('a.access = '.(int) $access);
    }
    if (!$user->authorise('core.admin')) {
      $groups = implode(',', $user->getAuthorisedViewLevels());
      $query->where('a.access IN ('.$groups.')');
    }
    $published = $this->getState('filter.published');
    if (is_numeric($published)) {
      $query->where('a.published = '.(int) $published);
    }
    elseif ($published === '') {
      $query->where('(a.published IN (0, 1))');
    }
    $search = $this->getState('filter.search');
    if (!empty($search)) {
      if (stripos($search, 'id:') === 0) {
        $query->where('a.id = '.(int) substr($search, 3));
      }
      else {
        $search = $db->quote('%'.str_replace(' ', '%', $db->escape(trim($search), true).'%'));
        $query->where('(a.title LIKE '.$search.' OR a.alias LIKE '.$search.')');
      }
    }
    if ($language = $this->getState('filter.language')) {
      $query->where('a.language = '.$db->quote($language));
    }
    $listOrdering = $this->getState('list.ordering', 'a.lft');
    $listDirn = $db->escape($this->getState('list.direction', 'ASC'));
    if ($listOrdering == 'a.access') {
      $query->order('a.access '.$listDirn.', a.lft '.$listDirn);
    }
    else {
      $query->order($db->escape($listOrdering).' '.$listDirn);
    }
    $query->group('a.id,
        a.title,
        a.alias,
        a.published,
        a.access,
        a.checked_out,
        a.checked_out_time,
        a.created_by,
        a.path,
        a.parent_id,
        a.level,
        a.lft,
        a.rgt,
        a.language,
        l.title,
        l.image,
        uc.name,
        ag.title'
    );
    return $query;
  }

  public function getItems() {
    return parent::getItems();
  }

}