<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
jimport('joomla.application.component.modeladmin');

class DatsogalleryModelblacklist extends JModelAdmin {
	protected $text_prefix = 'COM_DATSOGALLERY';

	public function getTable($type = 'Blacklist', $prefix = 'DatsogalleryTable', $config = array()) {
		return JTable::getInstance($type, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true) {
		$app = JFactory::getApplication();
		$form = $this->loadForm('com_datsogallery.blacklist', 'blacklist', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}
		return $form;
	}

	protected function loadFormData() {
		$data = JFactory::getApplication()->getUserState('com_datsogallery.edit.blacklist.data', array());
		if (empty($data)) {
			$data = $this->getItem();
		}
		return $data;
	}

	public function getItem($pk = null) {
		if ($item = parent::getItem($pk)) {
		}
		return $item;
	}

	protected function prepareTable($table) {
		jimport('joomla.filter.output');
		if (empty($table->id)) {
			if (@$table->ordering === '') {
				$db = JFactory::getDbo();
				$db->setQuery('SELECT MAX(ordering) FROM #___datsogallery_blacklist');
				$max = $db->loadResult();
				$table->ordering = $max + 1;
			}
		}
	}

  public function blockuser($ip, $userid) {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $columns = array('id', 'ip', 'date', 'ordering', 'state', 'created_by');
    $values = array($db->q(''), $db->q($ip), 'now()', 0, 1, $userid);
    $query->insert($db->qn('#__datsogallery_blacklist'))->columns($db->qn($columns))->values(implode(',', $values));
    $db->setQuery($query);
    $db->execute();
    $query->clear();
    $query->delete($db->qn('#__datsogallery_comments'));
    if ($userid != 0) :
      $query->where($db->qn('created_by').' = '.$userid);
    endif;
    $query->where($db->qn('user_ip').' = '.$db->q($ip));
    $db->setQuery($query);
    $db->execute();
    return true;
  }

}