<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

abstract class JHtmlDatsogallery {

  public static function published($value = 0, $i, $canChange = true, $task = 'images') {
    JHtml::_('bootstrap.tooltip');
    $states = array(
      0 => array('visibility-off', $task . '.publish', 'COM_DATSOGALLERY_PUBLISHED', 'JTOOLBAR_PUBLISH'),
      1 => array('visibility', $task . '.unpublish', 'COM_DATSOGALLERY_UNPUBLISHED', 'JTOOLBAR_UNPUBLISH'),
    );
    $state = JArrayHelper::getValue($states, (int) $value, $states[1]);
    $icon  = $state[0];
    if ($canChange) {
      $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" class="btn-state hasTooltip'
      . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[3]) . '"><i class="dgi-' . $icon . '"></i></a>';
    } else {
      $html = '<a class="btn-state hasTooltip disabled' . ($value == 1 ? ' active' : '')
      . '" title="' . JHtml::tooltipText($state[2]) . '"><i class="dgi-' . $icon . '"></i></a>';
    }
    return $html;
  }

  public static function approved($value = 0, $i, $canChange = true, $task = 'images') {
    JHtml::_('bootstrap.tooltip');
    $states = array(
      0 => array('visibility-off', $task . '.approved', 'COM_DATSOGALLERY_UNAPPROVED', 'COM_DATSOGALLERY_APPROVE'),
      1 => array('visibility', $task . '.unapproved', 'COM_DATSOGALLERY_APPROVED', 'COM_DATSOGALLERY_UNAPPROVE'),
    );
    $state = JArrayHelper::getValue($states, (int) $value, $states[1]);
    $icon  = $state[0];
    if ($canChange) {
      $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" class="btn-state hasTooltip'
      . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[3]) . '"><i class="dgi-' . $icon . '"></i></a>';
    } else {
      $html = '<a class="btn-state hasTooltip disabled' . ($value == 1 ? '' : '') . '" title="' . JHtml::tooltipText($state[2])
        . '"><i class="dgi-' . $icon . '"></i></a>';
    }
    return $html;
  }

  public static function featured($value = 0, $i, $canChange = true, $task = 'images') {
    JHtml::_('bootstrap.tooltip');
    $states = array(
      0 => array('hot', $task . '.featured', 'JUNFEATURED', 'COM_DATSOGALLERY_FEATURE_IT'),
      1 => array('hot', $task . '.unfeatured', 'JFEATURED', 'COM_DATSOGALLERY_UNFEATURE_IT'),
    );
    $state = JArrayHelper::getValue($states, (int) $value, $states[1]);
    $icon  = $state[0];
    if ($canChange) {
      $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" class="btn-state gray hasTooltip'
      . ($value == 1 ? ' featured' : '') . '" title="' . JHtml::tooltipText($state[3]) . '"><i class="dgi-' . $icon . '"></i></a>';
    } else {
      $html = '<a class="btn-state hasTooltip disabled' . ($value == 1 ? ' featured' : '') . '" title="' . JHtml::tooltipText($state[2])
        . '"><i class="dgi-' . $icon . '"></i></a>';
    }
    return $html;
  }

  public static function edit($id, $canChange = true, $task = 'image') {
    JHtml::_('bootstrap.tooltip');
    if ($canChange) {
      $html = '<a class="btn-state edit hasTooltip" href="'
      . JRoute::_('index.php?option=com_datsogallery&task=' . $task . '.edit&id='
        . $id) . '" title="' . JText::_('JACTION_EDIT') . '"><i class="dgi-edit"></i></a>';
    } else {
      $html = '';
    }
    return $html;
  }

  public static function delete($id, $canChange = true, $task = 'image') {
    JHtml::_('bootstrap.tooltip');
    if ($canChange) {
      $html = '<a class="btn-state gray hasTooltip" href="'
      . JRoute::_('index.php?option=com_datsogallery&task=' . $task . '.delete')
      . '" title="' . JText::_('JACTION_DELETE') . '"><i class="dgi-trash"></i></a>';
    } else {
      $html = '';
    }
    return $html;
  }

  public static function block($ip, $user_id = 0, $canChange = true, $task = 'image') {
    JHtml::_('bootstrap.tooltip');
    if ($canChange) {
      $user = $user_id != 0 ? '&user_id=' . $user_id : '';
      $html = '<a class="btn-state hasTooltip" href="'
      . JRoute::_('index.php?option=com_datsogallery&task=' . $task . '.block&ip=' . $ip . $user)
      . '" title="' . JText::_('COM_DATSOGALLERY_COMMENTS_BLOCK_USER_BTN') . '"><i class="dgi-block"></i></a>';
    } else {
      $html = '';
    }
    return $html;
  }

  public static function published1($value = 0, $i, $canChange = true) {
    JHtml::_('bootstrap.tooltip');
    $states = array(0 => array('eye-slash', 'categories.publish', 'COM_CONTENT_PUBLISHED', 'COM_CONTENT_TOGGLE_TO_PUBLISH'), 1 => array('eye', 'categories.unpublish', 'COM_CONTENT_UNPUBLISHED', 'COM_CONTENT_TOGGLE_TO_UNPUBLISH'), );
    $state  = JArrayHelper::getValue($states, (int) $value, $states[1]);
    $icon   = $state[0];
    if ($canChange) {
      $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" class="btn-state hasTooltip' . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[3]) . '"><i class="icon-' . $icon . '"></i></a>';
    } else {
      $html = '<a class="btn-state hasTooltip disabled' . ($value == 1 ? ' active' : '') . '" title="' . JHtml::tooltipText($state[2]) . '"><i class="icon-' . $icon . '"></i></a>';
    }
    return $html;
  }

  public static function batch() {
    $input = JFactory::getApplication()->input;
    $root  = $input->getCmd('view') == 'categories' ? 1 : 0;
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('DISTINCT id AS value, title AS text');
    $query->from($db->qn('#__datsogallery_categories'));
    $query->where('NOT ' . $db->qn('alias') . ' = ' . $db->q('root'));
    $query->where($db->qn('parent_id') . ' > 0');
    $query->order('ordering, title');
    $rows = $db->setQuery($query)->loadObjectlist();
    $out  = '';
    if ($root) {
      $out .= '<option value="1">' . JText::_('COM_DATSOGALLERY_BATCH_ADD_TO_ROOT') . '</option>';
    }
    foreach ($rows as $row) {
      $out .= '<option value="' . $row->value . '">' . $row->text . '</option>';
    }
    return $out;
  }
}
