<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class DatsogalleryControllerSettings extends JControllerAdmin
{

  public function __construct()
  {
    parent::__construct();
    $user = JFactory::getUser();
    if (!$user->authorise('core.admin', 'com_datsogallery')) {
      $app = JFactory::getApplication();
      $this->setMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'error');
      $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=datsogallery', false));
    }
    $this->registerTask('apply', 'save');
  }

  public function wmupload()
  {
    $html = require_once JPATH_COMPONENT . '/helpers/wmupload.php';
    return $html;
  }

  public function save()
  {
    JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
    $data  = JFactory::getApplication()->input->get('jform', array(), 'array');
    $model = $this->getModel('settings');
    $form  = $model->loadFormData();
    if ($form === false) {
      $errors = $model->getErrors();
      for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
        if ($errors[$i] instanceof Exception) {
          $this->setMessage($errors[$i]->getMessage(), 'warning');
        } else {
          $this->setMessage($errors[$i], 'warning');
        }
      }
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=settings', false));
      return false;
    }
    if (!$model->save($data)) {
      $this->setMessage($model->getError(), 'error');
    } else {
      $this->setMessage(JText::_('COM_DATSOGALLERY_SETTINGS_SUCCESSFUL'));
    }
    $task = $this->getTask();
    if ($task == 'apply') {
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=settings', false));
    } elseif ($task == 'save') {
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=datsogallery', false));
    }
  }

  public function cancel()
  {
    $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=datsogallery', false));
  }

  public function mphocatodg()
  {
    $app = JFactory::getApplication();
    try {
      $count = $this->getModel('settings')->mphocatodg();
      echo new JResponseJson($count);
    } catch (Exception $e) {
      echo new JResponseJson($e);
    }
    $app->close();
  }

  public function clearcolors()
  {
    $user = JFactory::getUser();
    if (!$user->id)
      exit;
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $model = $this->getModel('settings');
      $num   = $model->clearcolors();
      if ($num === false) {
        $result = array('status' => 'error', 'message' => $model->getError());
      } else {
        if ($num > 0) {
          $result = array('status' => 'success', 'message' => JText::sprintf('COM_DATSOGALLERY_DELETED_ENTRIES', $num));
        } else {
          $result = array('status' => 'warning', 'message' => JText::_('COM_DATSOGALLERY_NO_CLEANING_REQUIRED'));
        }
      }
      echo json_encode($result);
    } else {
      $this->setMessage(JText::_('JINVALID_TOKEN'), 'error');
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=datsogallery', false));
    }
    $app->close();
  }

  public function cleandir()
  {
    $user = JFactory::getUser();
    if (!$user->id)
      exit;
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      if ($app->input->getWord('dir', '') == 'cache' || $app->input->getWord('dir', '') == 'webp') {
        $settings = dg::getConfig();
        $path     = $app->input->getWord('dir', '') == 'webp' ? $settings->path_to_webp : $settings->path_to_images;
        $dir      = JPATH_SITE . $path;
        $conf     = JFactory::getConfig();
        $options  = array(
          'defaultgroup' => '',
          'storage' => $conf->get('cache_handler', ''),
          'caching' => true,
          'cachebase' => $conf->get('cache_path', $dir)
        );
        $cache  = JCache::getInstance('', $options);
        $caches = array_keys($cache->getAll());
        foreach ($caches as $key => $group) {
          $cache->clean($group);
        }
        $result = array('status' => 'success', 'message' => JText::_('COM_DATSOGALLERY_DIRECTORY_CLEARED'));
        echo json_encode($result);
      }
    } else {
      $this->setMessage(JText::_('JINVALID_TOKEN'), 'error');
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=datsogallery', false));
    }
    $app->close();
  }
}
