<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

class DatsogalleryControllerImages extends JControllerAdmin {

	public function __construct($config = array()) {
		parent::__construct($config);
		$this->registerTask('unfeatured', 'featured');
		$this->registerTask('unapproved', 'approved');
	}

	public function getModel($name = 'Image', $prefix = 'DatsogalleryModel', $config = array('ignore_request' => true)) {
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}

	public function saveOrderAjax() {
		$input = JFactory::getApplication()->input;
		$pks = $input->post->get('cid', array(), 'array');
		$order = $input->post->get('order', array(), 'array');
		JArrayHelper::toInteger($pks);
		JArrayHelper::toInteger($order);
		$model = $this->getModel();
		$return = $model->saveorder($pks, $order);
		if ($return) {
			echo "1";
		}
		JFactory::getApplication()->close();
	}

	public function featured() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$user = JFactory::getUser();
		$ids = $this->input->get('cid', array(), 'array');
		$values = array('featured' => 1, 'unfeatured' => 0);
		$task = $this->getTask();
		$value = JArrayHelper::getValue($values, $task, 0, 'int');
		$model = $this->getModel();
		foreach ($ids as $i => $id) {
			$item = $model->getItem($id);
			if (!$user->authorise('core.edit.state', 'com_datsogallery.category.'.(int) $item->catid)) {
				unset($ids[$i]);
        $this->setMessage(JText::_('JLIB_APPLICATION_ERROR_EDITSTATE_NOT_PERMITTED'), 'notice');
			}
		}
		if (empty($ids)) {
			$this->setMessage(JText::_('COM_DATSOGALLERY_NO_ITEM_SELECTED'), 'warning');
		}
		else {
			if (!$model->featured($ids, $value)) {
				$this->setMessage($model->getError(), 'error');
			}
		}
		$this->setRedirect('index.php?option=com_datsogallery&view=images');
	}

	public function approved() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
    $settings = dg::getConfig();
		$user = JFactory::getUser();
		$ids = $this->input->get('cid', array(), 'array');
		$values = array('approved' => 1, 'unapproved' => 0);
		$task = $this->getTask();
		$value = JArrayHelper::getValue($values, $task, 0, 'int');
		$model = $this->getModel();
		foreach ($ids as $i => $id) {
			$item = $model->getItem($id);
			if (!$user->authorise('core.edit.state', 'com_datsogallery.category.'.(int) $item->catid)) {
				unset($ids[$i]);
				$this->setMessage(JText::_('JLIB_APPLICATION_ERROR_EDITSTATE_NOT_PERMITTED'), 'notice');
			}
		}
		if (empty($ids)) {
			$this->setMessage(JText::_('COM_DATSOGALLERY_NO_ITEM_SELECTED'), 'warning');
		}
		else {
			if (!$model->approved($ids, $value)) {
				$this->setMessage($model->getError(), 'error');
			}
      if ($settings->upload_approval && $settings->upload_approval_notify && $value == 1) {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
  					->select('DISTINCT created_by')
  					->from($db->qn('#__datsogallery_images'))
  					->where($db->qn('id') . ' IN (' . implode(',', $ids) . ')');
        $db->setQuery($query);
        $owners = $db->loadObjectList();
        foreach ($owners as $owner) {
          $this->approveNotify($owner->created_by);
        }
      }
		}
		$this->setRedirect('index.php?option=com_datsogallery&view=images');
	}

  public function approveNotify($id) {
    $app = JFactory::getApplication();
    $user = JFactory::getUser($id);
    $itemId = dg::itemId(false,true);
    $link = dg::backendRoute('index.php?option=com_datsogallery&amp;view=member&amp;id='.$id.$itemId);
    $text = sprintf(JText::_('COM_DATSOGALLERY_IMAGE_APPROVED_NOTIFICATION_HELLO'), $user->name)."\r\n\r\n";
    $text .= JText::_('COM_DATSOGALLERY_IMAGE_APPROVED_NOTIFICATION_TEXT')."\r\n\r\n";
    $text .= $link."\r\n\r\n";
    $text .= JText::_('COM_DATSOGALLERY_MAIL_MSG');
    $subject = sprintf(JText::_('COM_DATSOGALLERY_IMAGE_APPROVED_NOTIFICATION_SUBJECT'), $app->getCfg('sitename'));
    return dg::sendmail($user->email, $subject, $text);
  }

}