<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');
require_once JPATH_COMPONENT . '/images.php';

class DatsogalleryControllerImage extends JControllerForm
{

  public function __construct()
  {
    $this->view_list = 'images';
    parent::__construct();
  }

  public function imagerefresh()
  {
    $input    = JFactory::getApplication()->input;
    $original = $input->get('original');
    $catid    = $input->get('catid');
    $array    = array();
    $array[]  = getCacheFile($original, 1000, 1000, $catid, '1:1');
    $array[]  = getCacheFile($original, 400, 500, $catid, '1:1');
    $array[]  = getCacheFile($original, 200, 200, $catid, '1:1');
    foreach ($array as $file) {
      if (JFile::exists($file)) {
        JFile::delete($file);
      }
    }
    resize($original, 1000, 1000, 0, '1:1', 0, $catid);
    resize($original, 200, 200, 0, '1:1', 0, $catid);
    echo resize($original, 400, 500, 0, '1:1', 0, $catid);
    JFactory::getApplication()->close();
  }

  public function sbox()
  {
    dg::sbox();
  }

  public function batch($model = null)
  {
    JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
    $model = $this->getModel();
    $this->setRedirect('index.php?option=com_datsogallery&view=images');
    return parent::batch($model);
  }

  public function originalupload()
  {
    JSession::checkToken('get') or die(JText::_('JINVALID_TOKEN'));
    $app = JFactory::getApplication();
    require_once JPATH_COMPONENT_SITE . '/helpers/uploader.php';
    $settings = dg::getConfig();
    $settings = array(
      'uploadFolder' => JPATH_SITE . $settings->path_to_originals,
      'maxFileSize' => dg::maxuploadsize(),
      'changeFile' => true
    );
    $uploader = new RealTimeUpload();
    $uploader->init($settings);
    $app->close();
  }

  public function updateoriginal()
  {
    JSession::checkToken('get') or die(JText::_('JINVALID_TOKEN'));
    $app = JFactory::getApplication();
    $settings = dg::getConfig();
    $id       = $app->input->getInt('id');
    $catid    = $app->input->getInt('catid');
    $original = $app->input->getString('original');
    $new      = $app->input->getString('newfile');
    $newfile  = JFile::stripExt($original) . '.' . JFile::getExt($new);
    $dir      = JPATH_SITE . $settings->path_to_originals . '/';
    JFile::delete($dir . $original);
    if (JFile::move($dir . $new, $dir . $newfile)) {
      $model = $this->getModel('Image', 'DatsogalleryModel');
      $model->updateOriginal($id, $newfile);
      echo resize($newfile,
        $settings->image_width_details,
        $settings->image_height_details,
        0,
        $settings->image_aspect_ratio_details,
        $settings->image_watermark,
        $catid,
        '',
        $settings->categories_image_quality
      );
    }
    $app->close();
  }
}
