<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

class DatsogalleryControllerDatsogallery extends JControllerAdmin {

	public function __construct($config = array()) {
		parent::__construct($config);
	}

	public function getModel($name = 'Image', $prefix = 'DatsogalleryModel', $config = array('ignore_request' => true)) {
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}

	public function publishAjax() {
		$input = JFactory::getApplication()->input;
		$pks = $input->post->get('id', array(), 'array');
		JArrayHelper::toInteger($pks);
		$model = $this->getModel();
		$return = $model->publish($pks, 1);
		if ($return) {
			echo JText::_('COM_DATSOGALLERY_PUBLISH_IMAGE_SUCCESS');
		}
		JFactory::getApplication()->close();
	}

	public function approveAjax() {
		$input = JFactory::getApplication()->input;
		$pks = $input->post->get('id', array(), 'array');
		JArrayHelper::toInteger($pks);
		$model = $this->getModel();
		$return = $model->approved($pks, 1);
		if ($return) {
			echo JText::_('COM_DATSOGALLERY_APPROVE_IMAGE_SUCCESS');
		}
		JFactory::getApplication()->close();
	}

	public function reviewAjax() {
		$input = JFactory::getApplication()->input;
		$pks = $input->post->get('id', array(), 'array');
		JArrayHelper::toInteger($pks);
		$model = $this->getModel();
		$return = $model->review($pks, 1);
		if ($return) {
			echo JText::_('COM_DATSOGALLERY_REVIEW_IMAGE_SUCCESS');
		}
		JFactory::getApplication()->close();
	}

	public function publishComment() {
		$input = JFactory::getApplication()->input;
		$id = $input->getInt('id');
    $state = $input->getInt('state');
    $value = $state == 1 ? 0 : 1;
		$model = $this->getModel();
		$return = $model->publishcomment($id, $value);
		if ($return) {
			echo $value;
		}
		JFactory::getApplication()->close();
	}

	public function pushajax() {
		$app = JFactory::getApplication();
		$id = $app->input->getInt('article_id');
		$model = $this->getModel();
		$result = $model->sendPush($id);
		if ($result) {
      echo new JResponseJson($result);
		}
		$app->close();
	}

}