<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

public function getImageInfo($img) {
  $data = array();
  getimagesize($img, $info);
  if (isset ($info['APP13'])) :
    $iptc = iptcparse($info["APP13"]);
    if (!empty ($iptc["2#025"])) :
      $count = count($iptc["2#025"]);
      for ($i = 0; $i < $count; $i++) {
        $data["tag"] = @implode(', ', $iptc["2#025"][$i]);
      }
    endif;
    if (!empty ($iptc["2#005"][0])) :
      $data["title"] = $iptc['2#005'][0];
    endif;
    if (!empty ($iptc["2#120"][0])) :
      $data["description"] = $iptc["2#120"][0];
    endif;
    if (!empty ($iptc["2#080"][0])) :
      $data["author"] = $iptc["2#080"][0];
    endif;
  endif;
  $xmp = getImageXMP($img);
  foreach ($xmp as $key => $value) :
    if (!empty ($value)) :
      $data[$key] = $value;
    endif;
  endforeach;
  return $data;
}

public function getImageXMP($filename) {
  $source = JFile::read($filename);
  $xmpdata_start = strpos($source, "<x:xmpmeta");
  $xmpdata_end = strpos($source, "</x:xmpmeta>");
  $xmplenght = $xmpdata_end - $xmpdata_start;
  $xmpdata = substr($source, $xmpdata_start, $xmplenght + 12);
  $xmp = array();
  foreach (array(
    'url' => '<xmpRights:WebStatement>(.+)<\/xmpRights:WebStatement>',
    'title' => '<dc:title>\s*<rdf:Alt>\s*<rdf:li xml:lang=\"x-default\">(.+)<\/rdf:li>\s*<\/rdf:Alt>\s*<\/dc:title>',
    'description' => '<dc:description>\s*<rdf:Alt>\s*<rdf:li xml:lang=\"x-default\">(.+)<\/rdf:li>\s*<\/rdf:Alt>\s*<\/dc:description>',
    'author' => '<dc:creator>\s*<rdf:Seq>\s*<rdf:li>(.+)<\/rdf:li>\s*<\/rdf:Seq>\s*<\/dc:creator>',
    'tag' => '<dc:subject>\s*<rdf:Bag>\s*(.*?)\s*<\/rdf:Bag>\s*<\/dc:subject>',
  ) as $key => $regex) :
    $xmp[$key] = preg_match("/$regex/is", $xmpdata, $match) ? $match[1] : '';
    $xmp[$key] = preg_match_all("/<rdf:li>([^>]*)<\/rdf:li>/is", $xmp[$key], $match) ? implode(', ', $match[1]) : $xmp[$key];
  endforeach;
  return $xmp;
}