<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

class DatsogalleryControllerCategories extends JControllerAdmin {

  public function __construct($config = array()) {
    parent::__construct($config);
    $this->registerTask('unapproved', 'approved');
  }

  public function getModel($name = 'Category', $prefix = 'DatsogalleryModel', $config = array('ignore_request' => true)) {
    return parent::getModel($name, $prefix, $config);
  }

  public function saveOrderAjax() {
    $input = JFactory::getApplication()->input;
    $pks = $input->post->get('cid', array(), 'array');
    $order = $input->post->get('order', array(), 'array');
    JArrayHelper::toInteger($pks);
    JArrayHelper::toInteger($order);
    $model = $this->getModel();
    $model->saveorder($pks, $order);
    $model->rebuild();
    /*if ($return) {
      $model->rebuild();
      echo "1";
    }*/
    JFactory::getApplication()->close();
  }

  public function rebuild() {
    JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
    $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=categories', false));
    $model = $this->getModel();
    if ($model->rebuild()) {
      $this->setMessage(JText::_('COM_DATSOGALLERY_CATEGORIES_REBUILD_SUCCESS'));
      return true;
    }
    else {
      $this->setMessage(JText::_('COM_DATSOGALLERY_CATEGORIES_REBUILD_FAILURE'));
      return false;
    }
  }

  public function delete() {
    JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
    $cid = $this->input->get('cid', array(), 'array');
    if (!is_array($cid) || count($cid) < 1) {
      $this->setMessage(JText::_($this->text_prefix.'_NO_ITEM_SELECTED'), 'warning');
    }
    else {
      $model = $this->getModel();
      $cid = ArrayHelper::toInteger($cid);
      if ($model->delete($cid)) {
        $this->setMessage(JText::plural($this->text_prefix.'_N_ITEMS_DELETED', count($cid)));
      }
      else {
        $this->setMessage($model->getError());
      }
    }
    $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=categories', false));
  }

  public function approved() {
    JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
    $user = JFactory::getUser();
    $ids = $this->input->get('cid', array(), 'array');
    $values = array('approved' => 1, 'unapproved' => 0);
    $task = $this->getTask();
    $value = JArrayHelper::getValue($values, $task, 0, 'int');
    $model = $this->getModel();
    foreach ($ids as $i => $id) {
      $item = $model->getItem($id);
      if (!$user->authorise('core.edit.state', 'com_datsogallery.category.' . (int) $item->id)) {
        unset($ids[$i]);
        $this->setMessage(JText::_('JLIB_APPLICATION_ERROR_EDITSTATE_NOT_PERMITTED'), 'notice');
      }
    }
    if (empty($ids)) {
      $this->setMessage(JText::_('COM_DATSOGALLERY_NO_ITEM_SELECTED'), 'warning');
    }
    else {
      if (!$model->approved($ids, $value)) {
        $this->setMessage($model->getError(), 'error');
      }
    }
    $this->setRedirect('index.php?option=com_datsogallery&view=categories');
  }

}